# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/hospitalResidencyMatch.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def hospitalResidencyMatch(R: Matrix,
                           H: Matrix,
                           capacity: Matrix,
                           **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     This script computes a solution for the hospital residency match problem.
    
     Residents.mtx:
     2.0,1.0,3.0
     1.0,2.0,3.0
     1.0,2.0,0.0
    
     Since it is an ORDERED  matrix, this means that Resident 1 (row 1) likes hospital 2 the most, followed by hospital 1 and hospital 3.
     If it was UNORDERED, this would mean that resident 1 (row 1) likes hospital 3 the most (since the value at [1,3] is the row max),
     followed by hospital 1 (2.0 preference value) and hospital 2 (1.0 preference value).
    
     Hospitals.mtx:
     2.0,1.0,0.0
     0.0,1.0,2.0
     1.0,2.0,0.0
    
     Since it is an UNORDERED matrix this means that Hospital 1 (row 1) likes Resident 1 the most (since the value at [1,1] is the row max).
    
     capacity.mtx
     1.0
     1.0
     1.0
    
     residencyMatch.mtx
     2.0,0.0,0.0
     1.0,0.0,0.0
     0.0,2.0,0.0
    
     hospitalMatch.mtx
     0.0,1.0,0.0
     0.0,0.0,2.0
     1.0,0.0,0.0
    
     Resident 1 has matched with Hospital 3 (since [1,3] is non-zero) at a preference level of 2.0.
     Resident 2 has matched with Hospital 1 (since [2,1] is non-zero) at a preference level of 1.0.
     Resident 3 has matched with Hospital 2 (since [3,2] is non-zero) at a preference level of 2.0.
    
    
    
    :param R: Residents matrix R.
        It must be an ORDERED  matrix.
    :param H: Hospitals matrix H.
        It must be an UNORDRED matrix.
    :param capacity: capacity of Hospitals matrix C.
        It must be a [n*1] matrix with non zero values.
        i.e. the leftmost value in a row is the most preferred partner's index.
        i.e. the leftmost value in a row in P is the preference value for the acceptor
        with index 1 and vice-versa (higher is better).
    :param verbose: If the operation is verbose
    :return: Result Matrix
        If cell [i,j] is non-zero, it means that Resident i has matched with Hospital j.
        Further, if cell [i,j] is non-zero, it holds the preference value that led to the match.
    :return: Result Matrix
        If cell [i,j] is non-zero, it means that Resident i has matched with Hospital j.
        Further, if cell [i,j] is non-zero, it holds the preference value that led to the match.
    """

    params_dict = {'R': R, 'H': H, 'capacity': capacity}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(R.sds_context, '')
    vX_1 = Matrix(R.sds_context, '')
    output_nodes = [vX_0, vX_1, ]

    op = MultiReturn(R.sds_context, 'hospitalResidencyMatch', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]

    return op
