/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import java.io.Serializable;

public final class InstructionTypeCounter
implements Serializable {
    private static final long serialVersionUID = 115L;
    protected int total = 0;
    protected int scans = 0;
    protected int decompressions = 0;
    protected int overlappingDecompressions = 0;
    protected int leftMultiplications = 0;
    protected int rightMultiplications = 0;
    protected int compressedMultiplications = 0;
    protected int dictionaryOps = 0;
    protected int indexing = 0;
    protected boolean isDensifying = false;

    public InstructionTypeCounter() {
    }

    public InstructionTypeCounter(int scans, int decompressions, int overlappingDecompressions, int leftMultiplications, int rightMultiplications, int compressedMultiplications, int dictionaryOps, int indexing, int total, boolean isDensifying) {
        this.scans = scans;
        this.decompressions = decompressions;
        this.overlappingDecompressions = overlappingDecompressions;
        this.leftMultiplications = leftMultiplications;
        this.rightMultiplications = rightMultiplications;
        this.compressedMultiplications = compressedMultiplications;
        this.dictionaryOps = dictionaryOps;
        this.indexing = indexing;
        this.isDensifying = isDensifying;
        this.total = total;
    }

    public int getScans() {
        return this.scans;
    }

    public void incScans() {
        ++this.scans;
        ++this.total;
    }

    public int getDecompressions() {
        return this.decompressions;
    }

    public void incDecompressions() {
        ++this.decompressions;
        ++this.total;
    }

    public int getOverlappingDecompressions() {
        return this.overlappingDecompressions;
    }

    public void incOverlappingDecompressions() {
        ++this.overlappingDecompressions;
        ++this.total;
    }

    public int getLeftMultiplications() {
        return this.leftMultiplications;
    }

    public void incLMM() {
        ++this.leftMultiplications;
        ++this.total;
    }

    public void incLMM(int c) {
        this.leftMultiplications += c;
        ++this.total;
    }

    public int getRightMultiplications() {
        return this.rightMultiplications;
    }

    public void incRMM() {
        ++this.rightMultiplications;
        ++this.total;
    }

    public void incRMM(int c) {
        this.rightMultiplications += c;
        ++this.total;
    }

    public int getCompressedMultiplications() {
        return this.compressedMultiplications;
    }

    public void incCMM() {
        ++this.compressedMultiplications;
        ++this.total;
    }

    public int getDictionaryOps() {
        return this.dictionaryOps;
    }

    public void incDictOps() {
        ++this.dictionaryOps;
        ++this.total;
    }

    public int getIndexing() {
        return this.indexing;
    }

    public void incIndexOp() {
        ++this.indexing;
        ++this.total;
    }

    public static InstructionTypeCounter MMR(int nCols, int calls) {
        return new InstructionTypeCounter(0, 0, 0, 0, nCols, 0, 0, 0, calls, false);
    }

    public static InstructionTypeCounter MML(int nRows, int calls) {
        return new InstructionTypeCounter(0, 0, 0, nRows, 0, 0, 0, 0, calls, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.total > 1) {
            sb.append(String.format("Tot:%d;", this.total));
            if (this.scans > 0) {
                sb.append(String.format("Sca:%d;", this.scans));
            }
            if (this.decompressions > 0) {
                sb.append(String.format("DeC:%d;", this.decompressions));
            }
            if (this.overlappingDecompressions > 0) {
                sb.append(String.format("OvD:%d;", this.overlappingDecompressions));
            }
            if (this.leftMultiplications > 0) {
                sb.append(String.format("LMM:%d;", this.leftMultiplications));
            }
            if (this.rightMultiplications > 0) {
                sb.append(String.format("RMM:%d;", this.rightMultiplications));
            }
            if (this.compressedMultiplications > 0) {
                sb.append(String.format("CMM:%d;", this.compressedMultiplications));
            }
            if (this.dictionaryOps > 0) {
                sb.append(String.format("dic:%d;", this.dictionaryOps));
            }
            if (this.indexing > 0) {
                sb.append(String.format("ind:%d;", this.indexing));
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 1);
            }
        } else {
            sb.append("Empty");
        }
        return sb.toString();
    }
}

