/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.BitmapEncoder;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.InsertionSorterFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DCounts;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class ColGroupFactory {
    static final Log LOG = LogFactory.getLog((String)ColGroupFactory.class.getName());
    private final MatrixBlock in;
    private final CompressedSizeInfo csi;
    private final CompressionSettings cs;
    private final ACostEstimate ce;
    private final int k;
    private final int nRow;
    private final int nCol;
    private final ExecutorService pool;

    private ColGroupFactory(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings cs, ACostEstimate ce, int k) {
        this.in = in;
        this.csi = csi;
        this.cs = cs;
        this.k = k;
        this.ce = ce;
        this.nRow = cs.transposed ? in.getNumColumns() : in.getNumRows();
        this.nCol = cs.transposed ? in.getNumRows() : in.getNumColumns();
        this.pool = k > 1 ? CommonThreadPool.get(k) : null;
    }

    public static List<AColGroup> compressColGroups(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings cs, int k) {
        return new ColGroupFactory(in, csi, cs, null, k).compress();
    }

    public static List<AColGroup> compressColGroups(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings cs, ACostEstimate ce, int k) {
        return new ColGroupFactory(in, csi, cs, ce, k).compress();
    }

    private List<AColGroup> compress() {
        try {
            List<AColGroup> ret = this.compressExecute();
            if (this.pool != null) {
                this.pool.shutdown();
            }
            return ret;
        }
        catch (Exception e) {
            if (this.pool != null) {
                this.pool.shutdown();
            }
            throw new DMLCompressionException("Compression Failed", e);
        }
    }

    private List<AColGroup> compressExecute() {
        for (CompressedSizeInfoColGroup g : this.csi.getInfo()) {
            g.clearMap();
        }
        if (this.in.isEmpty()) {
            ColGroupEmpty empty = ColGroupEmpty.create(this.cs.transposed ? this.in.getNumRows() : this.in.getNumColumns());
            return Collections.singletonList(empty);
        }
        if (this.k <= 1) {
            return this.compressColGroupsSingleThreaded();
        }
        return this.compressColGroupsParallel();
    }

    private List<AColGroup> compressColGroupsSingleThreaded() {
        ArrayList<AColGroup> ret = new ArrayList<AColGroup>(this.csi.getNumberColGroups());
        List<CompressedSizeInfoColGroup> groups = this.csi.getInfo();
        for (CompressedSizeInfoColGroup g : groups) {
            ret.add(this.compressColGroup(g));
        }
        return ret;
    }

    private List<AColGroup> compressColGroupsParallel() {
        try {
            List<CompressedSizeInfoColGroup> groups = this.csi.getInfo();
            int nGroups = groups.size();
            int skip = Math.min(this.k * 10, nGroups);
            ArrayList<CompressTask> tasks = new ArrayList<CompressTask>(skip);
            Collections.sort(groups, Comparator.comparing(g -> -g.getNumVals()));
            AColGroup[] ret = new AColGroup[nGroups];
            for (int i = 0; i < skip; ++i) {
                tasks.add(new CompressTask(groups, ret, i, skip));
            }
            for (Future t : this.pool.invokeAll(tasks)) {
                t.get();
            }
            return Arrays.asList(ret);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DMLRuntimeException("Failed compression ", e);
        }
    }

    protected AColGroup compressColGroup(CompressedSizeInfoColGroup cg) {
        if (LOG.isDebugEnabled() && this.nCol < 1000 && this.ce != null) {
            Timing time = new Timing(true);
            AColGroup ret = this.compressColGroupAllSteps(cg);
            this.logEstVsActual(time.stop(), ret, cg);
            return ret;
        }
        return this.compressColGroupAllSteps(cg);
    }

    private void logEstVsActual(double time, AColGroup act, CompressedSizeInfoColGroup est) {
        double estC = this.ce.getCost(est);
        double actC = this.ce.getCost(act, this.nRow);
        String retType = act.getClass().getSimpleName().toString();
        String cols = Arrays.toString(est.getColumns());
        String wanted = est.getBestCompressionType().toString();
        if (estC < actC * 0.75) {
            StringBuilder sb = new StringBuilder();
            sb.append("The estimate cost is significantly off : distinct: ");
            sb.append(est.getNumVals());
            sb.append(" ");
            sb.append(act.getNumValues());
            sb.append(" estimate offsets:");
            sb.append(est.getNumOffs());
            if (act instanceof ColGroupSDCZeros) {
                sb.append("  act:" + ((ColGroupSDCZeros)act).getIndexesSize());
            }
            String warning = sb.toString();
            LOG.debug((Object)String.format("time[ms]: %10.2f %25s est %10.0f -- act %10.0f cols:%s wanted:%s\n%s", time, retType, estC, actC, cols, wanted, warning));
        } else {
            LOG.debug((Object)String.format("time[ms]: %10.2f %25s est %10.0f -- act %10.0f cols:%s wanted:%s", time, retType, estC, actC, cols, wanted));
        }
    }

    private AColGroup compressColGroupAllSteps(CompressedSizeInfoColGroup cg) {
        AColGroup g = this.compressColGroupInitial(cg);
        int nCol = g.getColIndices().length;
        if (this.ce != null && this.ce.shouldSparsify() && nCol >= 4 && this.isSparsifyingColGroup(g)) {
            int i;
            double[] constV = null;
            if (g instanceof ColGroupSDC) {
                constV = ((ColGroupSDC)g)._defaultTuple;
                g = ((ColGroupSDC)g).subtractDefaultTuple();
            }
            AColGroupValue clg = (AColGroupValue)g;
            int nVal = g.getNumValues();
            MatrixBlockDictionary mbd = clg._dict.getMBDict(nCol);
            MatrixBlock mb = mbd.getMatrixBlock();
            if (mb == null || mb.isEmpty()) {
                return g;
            }
            int[] nnz = LibMatrixReorg.countNnzPerColumn(mb);
            double[] ref = new double[nCol];
            boolean contains = false;
            for (i = 0; i < nCol; ++i) {
                if (nnz[i] <= nVal / 2) continue;
                contains = true;
                ref[i] = 1.0;
            }
            if (contains) {
                this.getMostCommonValues(mb, ref, nnz);
            }
            contains = false;
            for (i = 0; i < nCol; ++i) {
                if (ref[i] == 0.0) continue;
                contains = true;
                break;
            }
            if (contains) {
                MatrixBlockDictionary mDict = mbd.binOpRight(new BinaryOperator(Minus.getMinusFnObject()), ref);
                if (constV != null) {
                    for (int i2 = 0; i2 < nCol; ++i2) {
                        int n = i2;
                        ref[n] = ref[n] + constV[i2];
                    }
                }
                LOG.debug((Object)String.format("Sparsifying colgroup before %1.4f now %1.4f", mb.getSparsity(), mDict.getSparsity()));
                if (g instanceof ColGroupDDC) {
                    g = ColGroupDDCFOR.create(g.getColIndices(), this.nRow, mDict, ((ColGroupDDC)clg)._data, clg.getCachedCounts(), ref);
                } else if (g instanceof ColGroupSDCZeros) {
                    g = ColGroupSDCFOR.create(g.getColIndices(), this.nRow, mDict, ((ColGroupSDCZeros)clg)._indexes, ((ColGroupSDCZeros)clg)._data, clg.getCachedCounts(), ref);
                }
            } else if (g instanceof ColGroupSDCZeros) {
                g = ColGroupSDCFOR.create(g.getColIndices(), this.nRow, mbd, ((ColGroupSDCZeros)clg)._indexes, ((ColGroupSDCZeros)clg)._data, clg.getCachedCounts(), ref);
            }
        }
        return g;
    }

    private void getMostCommonValues(MatrixBlock mb, double[] ref, int[] nnzCols) {
        DoubleCountHashMap[] counters = new DoubleCountHashMap[ref.length];
        if (mb.isInSparseFormat()) {
            for (int i = 0; i < ref.length; ++i) {
                if (ref[i] == 0.0) continue;
                counters[i] = new DoubleCountHashMap(8);
                counters[i].increment(0.0, nnzCols[i]);
            }
            SparseBlock sb = mb.getSparseBlock();
            for (int r = 0; r < mb.getNumRows(); ++r) {
                if (sb.isEmpty(r)) continue;
                int apos = sb.pos(r);
                int alen = sb.size(r) + apos;
                int[] aix = sb.indexes(r);
                double[] aval = sb.values(r);
                for (int j = apos; j < alen; ++j) {
                    if (ref[aix[j]] == 0.0) continue;
                    counters[aix[j]].increment(aval[j]);
                }
            }
        } else {
            for (int i = 0; i < ref.length; ++i) {
                if (ref[i] == 0.0) continue;
                counters[i] = new DoubleCountHashMap(8);
            }
            double[] dv = mb.getDenseBlockValues();
            int nCol = ref.length;
            for (int r = 0; r < mb.getNumRows(); ++r) {
                int rOff = r * nCol;
                for (int c = 0; c < nCol; ++c) {
                    if (ref[c] == 0.0) continue;
                    counters[c].increment(dv[rOff + c]);
                }
            }
        }
        for (int i = 0; i < ref.length; ++i) {
            if (ref[i] == 0.0) continue;
            ref[i] = counters[i].getMostFrequent();
        }
    }

    private boolean isSparsifyingColGroup(AColGroup g) {
        return g instanceof ColGroupDDC || g instanceof ColGroupSDC;
    }

    private AColGroup compressColGroupInitial(CompressedSizeInfoColGroup cg) {
        int[] colIndexes = cg.getColumns();
        int nrUniqueEstimate = cg.getNumVals();
        AColGroup.CompressionType ct = cg.getBestCompressionType();
        if (ct == AColGroup.CompressionType.EMPTY && !this.cs.transposed) {
            return new ColGroupEmpty(colIndexes);
        }
        if (ct == AColGroup.CompressionType.UNCOMPRESSED) {
            return ColGroupUncompressed.create(colIndexes, this.in, this.cs.transposed);
        }
        if ((ct == AColGroup.CompressionType.SDC || ct == AColGroup.CompressionType.CONST) && this.in.isInSparseFormat() && this.cs.transposed && (colIndexes.length > 1 && (double)cg.getNumOffs() < 0.3 * (double)this.nRow || colIndexes.length == 1)) {
            return this.compressSDCFromSparseTransposedBlock(colIndexes, nrUniqueEstimate, cg.getTupleSparsity());
        }
        if (ct == AColGroup.CompressionType.DDC) {
            return this.directCompressDDC(colIndexes, cg);
        }
        LOG.debug((Object)("Default slow path: " + ct + "  " + this.cs.transposed + " " + Arrays.toString(colIndexes)));
        int numRows = this.cs.transposed ? this.in.getNumColumns() : this.in.getNumRows();
        ABitmap ubm = BitmapEncoder.extractBitmap(colIndexes, this.in, this.cs.transposed, nrUniqueEstimate, this.cs.sortTuplesByFrequency);
        return ColGroupFactory.compress(colIndexes, numRows, ubm, ct, this.cs, cg.getTupleSparsity());
    }

    private static AColGroup compress(int[] colIndexes, int rlen, ABitmap ubm, AColGroup.CompressionType compType, CompressionSettings cs, double tupleSparsity) {
        if (ubm == null) {
            return new ColGroupEmpty(colIndexes);
        }
        IntArrayList[] of = ubm.getOffsetList();
        if (of.length == 1 && of[0].size() == rlen) {
            return ColGroupConst.create(colIndexes, DictionaryFactory.create(ubm));
        }
        tupleSparsity = colIndexes.length > 4 ? tupleSparsity : 1.0;
        switch (compType) {
            case DDC: {
                return ColGroupFactory.compressDDC(colIndexes, rlen, ubm, cs, tupleSparsity);
            }
            case RLE: {
                return ColGroupFactory.compressRLE(colIndexes, rlen, ubm, cs, tupleSparsity);
            }
            case OLE: {
                return ColGroupFactory.compressOLE(colIndexes, rlen, ubm, cs, tupleSparsity);
            }
            case CONST: {
                LOG.warn((Object)"Requested const on non constant column, fallback to SDC");
            }
            case EMPTY: 
            case SDC: {
                return ColGroupFactory.compressSDC(colIndexes, rlen, ubm, cs, tupleSparsity);
            }
        }
        throw new DMLCompressionException("Not implemented compression of " + compType + " in factory.");
    }

    private AColGroup directCompressDDC(int[] colIndexes, CompressedSizeInfoColGroup cg) {
        if (colIndexes.length > 1) {
            return this.directCompressDDCMultiCol(colIndexes, cg);
        }
        return this.directCompressDDCSingleCol(colIndexes, cg);
    }

    private AColGroup directCompressDDCSingleCol(int[] colIndexes, CompressedSizeInfoColGroup cg) {
        int col = colIndexes[0];
        AMapToData d = MapToFactory.create(this.nRow, Math.max(Math.min(cg.getNumOffs() + 1, this.nRow), 126));
        DoubleCountHashMap map = new DoubleCountHashMap(cg.getNumVals());
        if (this.cs.transposed) {
            this.readToMapDDCTransposed(col, map, d);
        } else {
            this.readToMapDDC(col, map, d);
        }
        ADictionary dict = DictionaryFactory.create(map);
        int nUnique = map.size();
        AMapToData resData = MapToFactory.resize(d, nUnique);
        return ColGroupDDC.create(colIndexes, this.nRow, dict, resData, null);
    }

    private AColGroup directCompressDDCMultiCol(int[] colIndexes, CompressedSizeInfoColGroup cg) {
        AMapToData d = MapToFactory.create(this.nRow, Math.max(Math.min(cg.getNumOffs() + 1, this.nRow), 126));
        int fill = d.getUpperBoundValue();
        d.fill(fill);
        DblArrayCountHashMap map = new DblArrayCountHashMap(cg.getNumVals(), colIndexes.length);
        boolean extra = this.nRow < CompressionSettings.PAR_DDC_THRESHOLD || this.k == 1 ? this.readToMapDDC(colIndexes, map, d, 0, this.nRow, fill) : this.parallelReadToMapDDC(colIndexes, map, d, this.nRow, fill, this.k);
        if (map.size() == 0) {
            return new ColGroupEmpty(colIndexes);
        }
        ADictionary dict = DictionaryFactory.create(map, colIndexes.length, extra, cg.getTupleSparsity());
        if (dict == null) {
            return new ColGroupEmpty(colIndexes);
        }
        try {
            if (extra) {
                d.replace(fill, map.size());
            }
            int nUnique = map.size() + (extra ? 1 : 0);
            AMapToData resData = MapToFactory.resize(d, nUnique);
            return ColGroupDDC.create(colIndexes, this.nRow, dict, resData, null);
        }
        catch (Exception e) {
            ReaderColumnSelection reader = ReaderColumnSelection.createReader(this.in, colIndexes, this.cs.transposed, 0, this.nRow);
            throw new DMLCompressionException("direct compress DDC Multi col failed extra:" + extra + " with reader type:" + reader.getClass().getSimpleName(), e);
        }
    }

    private boolean readToMapDDC(int[] colIndexes, DblArrayCountHashMap map, AMapToData data, int rl, int ru, int fill) {
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(this.in, colIndexes, this.cs.transposed, rl, ru);
        DblArray cellVals = reader.nextRow();
        boolean extra = false;
        int r = rl;
        while (r < ru && cellVals != null) {
            int row = reader.getCurrentRowIndex();
            if (row == r) {
                int id = map.increment(cellVals);
                data.set(row, id);
                cellVals = reader.nextRow();
                ++r;
                continue;
            }
            r = row;
            extra = true;
        }
        if (r < ru) {
            extra = true;
        }
        return extra;
    }

    private void readToMapDDC(int col, DoubleCountHashMap map, AMapToData data) {
        if (this.in.isInSparseFormat()) {
            SparseBlock sb = this.in.getSparseBlock();
            for (int r = 0; r < this.nRow; ++r) {
                if (sb.isEmpty(r)) {
                    data.set(r, map.increment(0.0));
                    continue;
                }
                int apos = sb.pos(r);
                int alen = sb.size(r) + apos;
                int[] aix = sb.indexes(r);
                int idx = Arrays.binarySearch(aix, apos, alen, col);
                if (idx < 0) {
                    data.set(r, map.increment(0.0));
                    continue;
                }
                data.set(r, map.increment(sb.values(r)[idx]));
            }
        } else if (this.in.getDenseBlock().isContiguous()) {
            double[] dv = this.in.getDenseBlockValues();
            int off = col;
            int r = 0;
            while (r < this.nRow) {
                int id = map.increment(dv[off]);
                data.set(r, id);
                ++r;
                off += this.nCol;
            }
        } else {
            throw new NotImplementedException("");
        }
    }

    private void readToMapDDCTransposed(int col, DoubleCountHashMap map, AMapToData data) {
        if (this.in.isInSparseFormat()) {
            SparseBlock sb = this.in.getSparseBlock();
            if (sb.isEmpty(col)) {
                return;
            }
            int apos = sb.pos(col);
            int alen = sb.size(col) + apos;
            int[] aix = sb.indexes(col);
            double[] aval = sb.values(col);
            map.increment(0.0, this.nRow - apos - alen);
            for (int j = apos; j < alen; ++j) {
                int id = map.increment(aval[j]);
                data.set(aix[j], id);
            }
        } else if (this.in.getDenseBlock().isContiguous()) {
            double[] dv = this.in.getDenseBlockValues();
            int off = col * this.nRow;
            int r = 0;
            while (r < this.nRow) {
                int id = map.increment(dv[off]);
                data.set(r, id);
                ++r;
                ++off;
            }
        } else {
            throw new NotImplementedException("");
        }
    }

    private boolean parallelReadToMapDDC(int[] colIndexes, DblArrayCountHashMap map, AMapToData data, int rlen, int fill, int k) {
        try {
            int blk = Math.max(rlen / colIndexes.length / k, 64000 / colIndexes.length);
            ArrayList<readToMapDDCTask> tasks = new ArrayList<readToMapDDCTask>();
            for (int i = 0; i < rlen; i += blk) {
                int end = Math.min(rlen, i + blk);
                tasks.add(new readToMapDDCTask(colIndexes, map, data, i, end, fill));
            }
            boolean extra = false;
            for (Future t : this.pool.invokeAll(tasks)) {
                extra |= ((Boolean)t.get()).booleanValue();
            }
            return extra;
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed to parallelize DDC compression");
        }
    }

    private static AColGroup compressSDC(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        int numZeros = ubm.getNumZeros();
        IntArrayList[] offs = ubm.getOffsetList();
        int largestOffset = offs[0].size();
        int largestIndex = 0;
        if (!cs.sortTuplesByFrequency) {
            int index = 0;
            for (IntArrayList a : ubm.getOffsetList()) {
                if (a.size() > largestOffset) {
                    largestOffset = a.size();
                    largestIndex = index;
                }
                ++index;
            }
        }
        if (ubm.getNumValues() == 1 && numZeros >= largestOffset) {
            ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
            AOffset off = OffsetFactory.createOffset(ubm.getOffsetList()[0].extractValues(true));
            return ColGroupSDCSingleZeros.create(colIndexes, rlen, dict, off, null);
        }
        if (ubm.getNumValues() == 2 && numZeros == 0 || ubm.getNumValues() == 1 && numZeros < largestOffset) {
            double[] defaultTuple = new double[colIndexes.length];
            ADictionary dict = DictionaryFactory.create(ubm, largestIndex, defaultTuple, tupleSparsity, numZeros > 0);
            return ColGroupFactory.compressSDCSingle(colIndexes, rlen, ubm, dict, defaultTuple);
        }
        if (numZeros >= largestOffset) {
            ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
            return ColGroupFactory.compressSDCZero(colIndexes, rlen, ubm, dict, cs);
        }
        return ColGroupFactory.compressSDCNormal(colIndexes, numZeros, rlen, ubm, largestIndex, tupleSparsity, cs);
    }

    private static AColGroup compressSDCZero(int[] colIndexes, int rlen, ABitmap ubm, ADictionary dict, CompressionSettings cs) {
        IntArrayList[] offsets = ubm.getOffsetList();
        AInsertionSorter s = InsertionSorterFactory.create(rlen, offsets, cs.sdcSortType);
        AOffset indexes = OffsetFactory.createOffset(s.getIndexes());
        AMapToData data = s.getData();
        data = MapToFactory.resize(data, dict.getNumberOfValues(colIndexes.length));
        return ColGroupSDCZeros.create(colIndexes, rlen, dict, indexes, data, null);
    }

    private static AColGroup compressSDCNormal(int[] colIndexes, int numZeros, int rlen, ABitmap ubm, int largestIndex, double tupleSparsity, CompressionSettings cs) {
        double[] defaultTuple = new double[colIndexes.length];
        ADictionary dict = DictionaryFactory.create(ubm, largestIndex, defaultTuple, tupleSparsity, numZeros > 0);
        AInsertionSorter s = InsertionSorterFactory.createNegative(rlen, ubm.getOffsetList(), largestIndex, cs.sdcSortType);
        AOffset indexes = OffsetFactory.createOffset(s.getIndexes());
        AMapToData _data = s.getData();
        _data = MapToFactory.resize(_data, dict.getNumberOfValues(colIndexes.length));
        return ColGroupSDC.create(colIndexes, rlen, dict, defaultTuple, indexes, _data, null);
    }

    private static AColGroup compressSDCSingle(int[] colIndexes, int rlen, ABitmap ubm, ADictionary dict, double[] defaultTuple) {
        IntArrayList inv = ubm.getOffsetsList(0);
        int[] indexes = new int[rlen - inv.size()];
        int p = 0;
        int v = 0;
        for (int i = 0; i < inv.size(); ++i) {
            int j = inv.get(i);
            while (v < j) {
                indexes[p++] = v++;
            }
            if (v != j) continue;
            ++v;
        }
        while (v < rlen) {
            indexes[p++] = v++;
        }
        AOffset off = OffsetFactory.createOffset(indexes);
        return ColGroupSDCSingle.create(colIndexes, rlen, dict, defaultTuple, off, null);
    }

    private static AColGroup compressDDC(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        boolean zeros = ubm.getNumOffsets() < (long)rlen;
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity, zeros);
        AMapToData data = MapToFactory.create(rlen, zeros, ubm.getOffsetList());
        return ColGroupDDC.create(colIndexes, rlen, dict, data, null);
    }

    private static AColGroup compressOLE(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        ColGroupOLE ole = new ColGroupOLE(rlen);
        int numVals = ubm.getNumValues();
        char[][] lBitMaps = new char[numVals][];
        int totalLen = 0;
        for (int i = 0; i < numVals; ++i) {
            lBitMaps[i] = ColGroupOLE.genOffsetBitmap(ubm.getOffsetsList(i).extractValues(), ubm.getNumOffsets(i));
            totalLen += lBitMaps[i].length;
        }
        ole.createCompressedBitmaps(numVals, totalLen, lBitMaps);
        ole._dict = dict;
        ole._zeros = ubm.getNumOffsets() < (long)rlen;
        ole._colIndexes = colIndexes;
        return ole;
    }

    private static AColGroup compressRLE(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        ColGroupRLE rle = new ColGroupRLE(rlen);
        int numVals = ubm.getNumValues();
        char[][] lBitMaps = new char[numVals][];
        int totalLen = 0;
        for (int k = 0; k < numVals; ++k) {
            lBitMaps[k] = ColGroupRLE.genRLEBitmap(ubm.getOffsetsList(k).extractValues(), ubm.getNumOffsets(k));
            totalLen += lBitMaps[k].length;
        }
        rle.createCompressedBitmaps(numVals, totalLen, lBitMaps);
        rle._dict = dict;
        rle._zeros = ubm.getNumOffsets() < (long)rlen;
        rle._colIndexes = colIndexes;
        return rle;
    }

    private AColGroup compressSDCFromSparseTransposedBlock(int[] cols, int nrUniqueEstimate, double tupleSparsity) {
        if (cols.length > 1) {
            return this.compressMultiColSDCFromSparseTransposedBlock(cols, nrUniqueEstimate, tupleSparsity);
        }
        return this.compressSingleColSDCFromSparseTransposedBlock(cols, nrUniqueEstimate);
    }

    private AColGroup compressMultiColSDCFromSparseTransposedBlock(int[] cols, int nrUniqueEstimate, double tupleSparsity) {
        HashSet<Integer> offsetsSet = new HashSet<Integer>();
        SparseBlock sb = this.in.getSparseBlock();
        for (int i = 0; i < cols.length; ++i) {
            if (sb.isEmpty(cols[i])) {
                throw new DMLCompressionException("Empty columns should not be entering here");
            }
            int apos = sb.pos(cols[i]);
            int alen = sb.size(cols[i]) + apos;
            int[] aix = sb.indexes(cols[i]);
            for (int j = apos; j < alen; ++j) {
                offsetsSet.add(aix[j]);
            }
        }
        int[] offsetsInt = offsetsSet.stream().mapToInt(Number::intValue).toArray();
        Arrays.sort(offsetsInt);
        MatrixBlock sub = new MatrixBlock(offsetsInt.length, cols.length, false);
        sub.allocateDenseBlock();
        sub.setNonZeros(offsetsInt.length * cols.length);
        double[] subV = sub.getDenseBlockValues();
        for (int i = 0; i < cols.length; ++i) {
            int apos = sb.pos(cols[i]);
            int alen = sb.size(cols[i]) + apos;
            int[] aix = sb.indexes(cols[i]);
            double[] aval = sb.values(cols[i]);
            int offsetsPos = 0;
            for (int j = apos; j < alen; ++j) {
                while (offsetsInt[offsetsPos] < aix[j]) {
                    ++offsetsPos;
                }
                if (offsetsInt[offsetsPos] != aix[j]) continue;
                subV[offsetsPos * cols.length + i] = aval[j];
            }
        }
        int[] subCols = new int[cols.length];
        for (int i = 1; i < cols.length; ++i) {
            subCols[i] = i;
        }
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(sub, subCols, false);
        int mapStartSize = Math.min(nrUniqueEstimate, offsetsInt.length / 2);
        DblArrayCountHashMap map = new DblArrayCountHashMap(mapStartSize, subCols.length);
        DblArray cellVals = null;
        AMapToData data = MapToFactory.create(offsetsInt.length, 257);
        while ((cellVals = reader.nextRow()) != null) {
            int row = reader.getCurrentRowIndex();
            data.set(row, map.increment(cellVals));
        }
        ADictionary dict = DictionaryFactory.create(map, cols.length, false, tupleSparsity);
        data = MapToFactory.resize(data, map.size());
        AOffset offs = OffsetFactory.createOffset(offsetsInt);
        return ColGroupSDCZeros.create(cols, this.in.getNumColumns(), dict, offs, data, null);
    }

    private AColGroup compressSingleColSDCFromSparseTransposedBlock(int[] cols, int nrUniqueEstimate) {
        SparseBlock sb = this.in.getSparseBlock();
        int sbRow = cols[0];
        int apos = sb.pos(sbRow);
        int alen = sb.size(sbRow) + apos;
        double[] vals = sb.values(sbRow);
        DoubleCountHashMap map = new DoubleCountHashMap(nrUniqueEstimate);
        for (int j = apos; j < alen; ++j) {
            map.increment(vals[j]);
        }
        DCounts[] entries = map.extractValues();
        Arrays.sort(entries, Comparator.comparing(x -> -x.count));
        if (entries[0].count < this.nRow - sb.size(sbRow)) {
            int[] counts = new int[entries.length];
            double[] dict = new double[entries.length];
            int i = 0;
            while (i < entries.length) {
                DCounts x2 = entries[i];
                counts[i] = x2.count;
                dict[i] = x2.key;
                x2.count = i++;
            }
            AOffset offsets = OffsetFactory.createOffset(sb.indexes(sbRow), apos, alen);
            if (entries.length <= 1) {
                return ColGroupSDCSingleZeros.create(cols, this.nRow, new Dictionary(dict), offsets, counts);
            }
            AMapToData mapToData = MapToFactory.create(alen - apos, entries.length);
            for (int j = apos; j < alen; ++j) {
                mapToData.set(j - apos, map.get(vals[j]));
            }
            return ColGroupSDCZeros.create(cols, this.nRow, new Dictionary(dict), offsets, mapToData, counts);
        }
        if (entries.length == 1) {
            int r;
            int nonZeros = this.nRow - entries[0].count;
            double x3 = entries[0].key;
            double[] defaultTuple = new double[]{x3};
            Dictionary zeroDict = new Dictionary(new double[]{0.0});
            int[] counts = new int[]{nonZeros};
            int[] notZeroOffsets = new int[nonZeros];
            int[] aix = sb.indexes(sbRow);
            int i = 0;
            int j = apos;
            for (r = 0; r < aix[alen - 1]; ++r) {
                if (r == aix[j]) {
                    ++j;
                    continue;
                }
                notZeroOffsets[i++] = r;
            }
            ++r;
            while (r < this.nRow) {
                notZeroOffsets[i] = r++;
                ++i;
            }
            AOffset offsets = OffsetFactory.createOffset(notZeroOffsets);
            return ColGroupSDCSingle.create(cols, this.nRow, zeroDict, defaultTuple, offsets, counts);
        }
        ABitmap ubm = BitmapEncoder.extractBitmap(cols, this.in, true, entries.length, true);
        return ColGroupFactory.compressSDC(cols, this.nRow, ubm, this.cs, 1.0);
    }

    private class readToMapDDCTask
    implements Callable<Boolean> {
        private final int[] _colIndexes;
        private final DblArrayCountHashMap _map;
        private final AMapToData _data;
        private final int _rl;
        private final int _ru;
        private final int _fill;

        protected readToMapDDCTask(int[] colIndexes, DblArrayCountHashMap map, AMapToData data, int rl, int ru, int fill) {
            this._colIndexes = colIndexes;
            this._map = map;
            this._data = data;
            this._rl = rl;
            this._ru = ru;
            this._fill = fill;
        }

        @Override
        public Boolean call() {
            return ColGroupFactory.this.readToMapDDC(this._colIndexes, this._map, this._data, this._rl, this._ru, this._fill);
        }
    }

    private class CompressTask
    implements Callable<Object> {
        private final List<CompressedSizeInfoColGroup> _groups;
        private final AColGroup[] _ret;
        private final int _off;
        private final int _step;

        protected CompressTask(List<CompressedSizeInfoColGroup> groups, AColGroup[] ret, int off, int step) {
            this._groups = groups;
            this._ret = ret;
            this._off = off;
            this._step = step;
        }

        @Override
        public Object call() {
            try {
                for (int i = this._off; i < this._groups.size(); i += this._step) {
                    this._ret[i] = ColGroupFactory.this.compressColGroup(this._groups.get(i));
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

