/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.instructions.CPInstructionParser;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.ComputationFEDInstruction;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;
import org.apache.sysds.runtime.lineage.LineageCacheEviction;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageEstimator;
import org.apache.sysds.runtime.lineage.LineageGPUCacheEviction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageRewriteReuse;
import org.apache.sysds.runtime.lineage.LineageTraceable;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.MetaDataFormat;

public class LineageCache {
    private static final Map<LineageItem, LineageCacheEntry> _cache = new HashMap<LineageItem, LineageCacheEntry>();
    protected static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reuse(Instruction inst, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return false;
        }
        boolean reuse = false;
        if (LineageCacheConfig.isReusable(inst, ec)) {
            Object opcode;
            GPUInstruction gpuinst;
            ComputationCPInstruction cinst = inst instanceof ComputationCPInstruction ? (ComputationCPInstruction)inst : null;
            ComputationFEDInstruction cfinst = inst instanceof ComputationFEDInstruction ? (ComputationFEDInstruction)inst : null;
            GPUInstruction gPUInstruction = gpuinst = inst instanceof GPUInstruction ? (GPUInstruction)inst : null;
            LineageItem instLI = cinst != null ? (LineageItem)cinst.getLineageItem(ec).getValue() : (cfinst != null ? (LineageItem)cfinst.getLineageItem(ec).getValue() : (LineageItem)gpuinst.getLineageItem(ec).getValue());
            List<Object> liList = null;
            if (inst instanceof MultiReturnBuiltinCPInstruction) {
                liList = new ArrayList();
                MultiReturnBuiltinCPInstruction mrInst = (MultiReturnBuiltinCPInstruction)inst;
                for (int i = 0; i < mrInst.getNumOutputs(); ++i) {
                    opcode = instLI.getOpcode() + String.valueOf(i);
                    liList.add(MutablePair.of((Object)new LineageItem((String)opcode, instLI.getInputs()), null));
                }
            } else {
                liList = Arrays.asList(MutablePair.of((Object)instLI, null));
            }
            LineageCacheEntry e = null;
            boolean reuseAll = true;
            opcode = _cache;
            synchronized (opcode) {
                for (MutablePair mutablePair : liList) {
                    if (LineageCacheConfig.getCacheType().isFullReuse()) {
                        LineageCacheEntry lineageCacheEntry = e = LineageCache.probe((LineageItem)mutablePair.getKey()) ? LineageCache.getIntern((LineageItem)mutablePair.getKey()) : null;
                    }
                    if (e == null && LineageCacheConfig.getCacheType().isPartialReuse() && LineageRewriteReuse.executeRewrites(inst, ec)) {
                        e = LineageCache.getIntern((LineageItem)mutablePair.getKey());
                    }
                    reuseAll &= e != null;
                    mutablePair.setValue((Object)e);
                    if (e != null || !LineageCache.isMarkedForCaching(inst, ec)) continue;
                    if (cinst != null) {
                        LineageCache.putIntern((LineageItem)mutablePair.getKey(), cinst.output.getDataType(), null, null, 0L);
                        continue;
                    }
                    if (cfinst != null) {
                        LineageCache.putIntern((LineageItem)mutablePair.getKey(), cfinst.output.getDataType(), null, null, 0L);
                        continue;
                    }
                    if (gpuinst == null) continue;
                    LineageCache.putIntern((LineageItem)mutablePair.getKey(), gpuinst._output.getDataType(), null, null, 0L);
                }
            }
            reuse = reuseAll;
            if (reuse) {
                boolean gpuReuse = false;
                for (MutablePair mutablePair : liList) {
                    e = (LineageCacheEntry)mutablePair.getValue();
                    String outName = null;
                    if (inst instanceof MultiReturnBuiltinCPInstruction) {
                        outName = ((MultiReturnBuiltinCPInstruction)inst).getOutput(((LineageItem)mutablePair.getKey()).getOpcode().charAt(((LineageItem)mutablePair.getKey()).getOpcode().length() - 1) - 48).getName();
                    } else if (inst instanceof ComputationCPInstruction) {
                        outName = cinst.output.getName();
                    } else if (inst instanceof ComputationFEDInstruction) {
                        outName = cfinst.output.getName();
                    } else if (inst instanceof GPUInstruction) {
                        outName = gpuinst._output.getName();
                    }
                    if (e.isMatrixValue() && e._gpuObject == null) {
                        MatrixBlock mb = e.getMBValue();
                        if (mb == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                            return false;
                        }
                        ec.setMatrixOutput(outName, mb);
                    } else if (e.isScalarValue()) {
                        ScalarObject so = e.getSOValue();
                        if (so == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                            return false;
                        }
                        ec.setScalarOutput(outName, so);
                    } else {
                        ec.getMatrixObject(outName).setGPUObject(ec.getGPUContext(0), ec.getGPUContext(0).shallowCopyGPUObject(e._gpuObject, ec.getMatrixObject(outName)));
                        ec.getMatrixObject(outName).getGPUObject(ec.getGPUContext(0)).setDirty(true);
                        gpuReuse = true;
                    }
                    reuse = true;
                    if (!DMLScript.STATISTICS) continue;
                    LineageCacheStatistics.incrementSavedComputeTime(e._computeTime);
                }
                if (DMLScript.STATISTICS) {
                    if (gpuReuse) {
                        LineageCacheStatistics.incrementGpuHits();
                    } else {
                        LineageCacheStatistics.incrementInstHits();
                    }
                }
            }
        }
        return reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reuse(List<String> outNames, List<DataIdentifier> outParams, int numOutputs, LineageItem[] liInputs, String name, ExecutionContext ec) {
        if (DMLScript.LINEAGE_ESTIMATE && !name.startsWith("SB")) {
            LineageEstimator.stopEstimator(outParams, liInputs, name);
        }
        if (!LineageCacheConfig.isMultiLevelReuse()) {
            return false;
        }
        boolean reuse = outParams.size() != 0;
        long savedComputeTime = 0L;
        HashMap<String, Data> funcOutputs = new HashMap<String, Data>();
        HashMap<String, LineageItem> funcLIs = new HashMap<String, LineageItem>();
        for (int i = 0; i < numOutputs; ++i) {
            String opcode = name + String.valueOf(i + 1);
            LineageItem li2 = new LineageItem(opcode, liInputs);
            li2.setHeight(1L);
            LineageCacheEntry e = null;
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                if (LineageCache.probe(li2)) {
                    e = LineageCache.getIntern(li2);
                } else {
                    LineageCache.putIntern(li2, outParams.get(i).getDataType(), null, null, 0L);
                }
            }
            if (e != null) {
                String boundVarName = outNames.get(i);
                Data boundValue = null;
                if (e.isMatrixValue()) {
                    MatrixBlock mb = e.getMBValue();
                    if (mb == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                        return false;
                    }
                    MetaDataFormat md = new MetaDataFormat(e.getMBValue().getDataCharacteristics(), Types.FileFormat.BINARY);
                    boundValue = new MatrixObject(Types.ValueType.FP64, boundVarName, md);
                    ((MatrixObject)boundValue).acquireModify(e.getMBValue());
                    ((MatrixObject)boundValue).release();
                } else {
                    boundValue = e.getSOValue();
                    if (boundValue == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                        return false;
                    }
                }
                funcOutputs.put(boundVarName, boundValue);
                LineageItem orig = e._origItem;
                funcLIs.put(boundVarName, orig);
                savedComputeTime = e._computeTime;
                continue;
            }
            reuse = false;
        }
        if (reuse) {
            funcOutputs.forEach((var, val) -> {
                Data exdata = ec.removeVariable((String)var);
                if (exdata != val) {
                    ec.cleanupDataObject(exdata);
                }
                ec.setVariable((String)var, (Data)val);
            });
            funcLIs.forEach((var, li) -> ec.getLineage().set((String)var, (LineageItem)li));
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementSavedComputeTime(savedComputeTime);
            }
        }
        return reuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FederatedResponse reuse(FederatedUDF udf, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone() || udf.getOutputIds() == null) {
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
        }
        boolean reuse = false;
        List<Long> outIds = udf.getOutputIds();
        HashMap<String, ScalarObject> udfOutputs = new HashMap<String, ScalarObject>();
        long savedComputeTime = 0L;
        if (udf.getLineageItem(ec) == null) {
            return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
        }
        LineageItem li = (LineageItem)udf.getLineageItem(ec).getValue();
        li.setHeight(1L);
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (LineageCache.probe(li)) {
                e = LineageCache.getIntern(li);
            } else {
                LineageCache.putIntern(li, Types.DataType.MATRIX, null, null, 0L);
            }
        }
        if (e != null) {
            String outName = String.valueOf(outIds.get(0));
            Data outValue = null;
            if (e.isMatrixValue()) {
                MatrixBlock mb = e.getMBValue();
                if (mb == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                    return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
                }
                MetaDataFormat md = new MetaDataFormat(e.getMBValue().getDataCharacteristics(), Types.FileFormat.BINARY);
                outValue = new MatrixObject(Types.ValueType.FP64, outName, md);
                ((MatrixObject)outValue).acquireModify(e.getMBValue());
                ((MatrixObject)outValue).release();
            } else {
                outValue = e.getSOValue();
                if (outValue == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                    return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
                }
            }
            udfOutputs.put(outName, (ScalarObject)outValue);
            savedComputeTime = e._computeTime;
            reuse = true;
        } else {
            reuse = false;
        }
        if (reuse) {
            FederatedResponse res = null;
            for (Map.Entry entry : udfOutputs.entrySet()) {
                String var = (String)entry.getKey();
                Data val = (Data)entry.getValue();
                Data exdata = ec.removeVariable(var);
                if (exdata != val) {
                    ec.cleanupDataObject(exdata);
                }
                ec.setVariable(var, val);
                res = LineageItemUtils.setUDFResponse(udf, (MatrixObject)val);
            }
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementInstHits();
                LineageCacheStatistics.incrementSavedComputeTime(savedComputeTime);
            }
            return res;
        }
        return new FederatedResponse(FederatedResponse.ResponseType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reuseFedRead(String outName, Types.DataType dataType, LineageItem li, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone() || dataType != Types.DataType.MATRIX) {
            return false;
        }
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (!LineageCache.probe(li)) {
                LineageCache.putIntern(li, dataType, null, null, 0L);
                return false;
            }
            e = LineageCache.getIntern(li);
        }
        if (e != null && e.isMatrixValue()) {
            MatrixBlock mb = e.getMBValue();
            if (mb == null || e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                return false;
            }
            ec.setMatrixOutput(outName, e.getMBValue());
            if (DMLScript.STATISTICS) {
                FederatedStatistics.incFedReuseReadHitCount();
                FederatedStatistics.incFedReuseReadBytesCount(mb);
                LineageCacheStatistics.incrementSavedComputeTime(e._computeTime);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] reuseSerialization(LineageItem objLI) {
        if (LineageCacheConfig.ReuseCacheType.isNone() || objLI == null) {
            return null;
        }
        LineageItem li = LineageItemUtils.getSerializedFedResponseLineageItem(objLI);
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (!LineageCache.probe(li)) {
                LineageCache.putIntern(li, Types.DataType.UNKNOWN, null, null, 0L);
                return null;
            }
            e = LineageCache.getIntern(li);
        }
        if (e != null && e.isSerializedBytes()) {
            byte[] sBytes = e.getSerializedBytes();
            if (sBytes == null && e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.NOTCACHED) {
                return null;
            }
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementSavedComputeTime(e._computeTime);
                FederatedStatistics.aggFedSerializationReuse(sBytes.length);
            }
            return sBytes;
        }
        return null;
    }

    public static boolean probe(LineageItem key) {
        boolean p = _cache.containsKey(key);
        if (!p && DMLScript.STATISTICS && LineageCacheEviction._removelist.containsKey(key)) {
            LineageCacheStatistics.incrementDelHits();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEntry(LineageItem key) {
        boolean p = _cache.containsKey(key);
        if (!p) {
            return;
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCacheEntry e = LineageCache.getEntry(key);
            long size = e.getSize();
            if (e._origItem == null) {
                _cache.remove(e._key);
            } else {
                LineageCacheEntry h = _cache.get(e._origItem);
                while (h != null) {
                    LineageCacheEntry tmp = h;
                    h = h._nextEntry;
                    _cache.remove(tmp._key);
                }
            }
            LineageCacheEviction.updateSize(size, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatrixBlock getMatrix(LineageItem key) {
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            e = LineageCache.getIntern(key);
        }
        return e.getMBValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineageCacheEntry getEntry(LineageItem key) {
        LineageCacheEntry e = null;
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            e = LineageCache.getIntern(key);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putMatrix(Instruction inst, ExecutionContext ec, long computetime) {
        if (LineageCacheConfig.isReusable(inst, ec)) {
            LineageItem item = (LineageItem)((LineageTraceable)((Object)inst)).getLineageItem(ec).getValue();
            MatrixObject mo = inst instanceof ComputationCPInstruction ? ec.getMatrixObject(((ComputationCPInstruction)inst).output) : ec.getMatrixObject(((ComputationFEDInstruction)inst).output);
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                LineageCache.putIntern(item, Types.DataType.MATRIX, (MatrixBlock)mo.acquireReadAndRelease(), null, computetime);
            }
        }
    }

    public static void putValue(Instruction inst, ExecutionContext ec, long starttime) {
        if (DMLScript.LINEAGE_ESTIMATE) {
            LineageEstimator.processSingleInst(inst, ec, starttime);
        }
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        long computetime = System.nanoTime() - starttime;
        if (LineageCacheConfig.isReusable(inst, ec)) {
            List<Object> liData = null;
            GPUObject liGpuObj = null;
            LineageItem instLI = (LineageItem)((LineageTraceable)((Object)inst)).getLineageItem(ec).getValue();
            if (inst instanceof MultiReturnBuiltinCPInstruction) {
                liData = new ArrayList<Pair<LineageItem, Data>>();
                MultiReturnBuiltinCPInstruction mrInst = (MultiReturnBuiltinCPInstruction)inst;
                for (int i = 0; i < mrInst.getNumOutputs(); ++i) {
                    String opcode = instLI.getOpcode() + String.valueOf(i);
                    LineageItem li = new LineageItem(opcode, instLI.getInputs());
                    Data value = ec.getVariable(mrInst.getOutput(i));
                    liData.add((Pair<LineageItem, Data>)Pair.of((Object)li, (Object)value));
                }
            } else if (inst instanceof GPUInstruction) {
                Data gpudata = ec.getVariable(((GPUInstruction)inst)._output);
                GPUObject gPUObject = liGpuObj = gpudata instanceof MatrixObject ? ec.getMatrixObject(((GPUInstruction)inst)._output).getGPUObject(ec.getGPUContext(0)) : null;
                if (liGpuObj == null) {
                    liData = Arrays.asList(Pair.of((Object)instLI, (Object)ec.getVariable(((GPUInstruction)inst)._output)));
                }
            } else {
                List<Object> list = liData = inst instanceof ComputationCPInstruction ? Arrays.asList(Pair.of((Object)instLI, (Object)ec.getVariable(((ComputationCPInstruction)inst).output))) : Arrays.asList(Pair.of((Object)instLI, (Object)ec.getVariable(((ComputationFEDInstruction)inst).output)));
            }
            if (liGpuObj == null) {
                LineageCache.putValueCPU(inst, liData, computetime);
            } else {
                LineageCache.putValueGPU(liGpuObj, instLI, computetime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putValueCPU(Instruction inst, List<Pair<LineageItem, Data>> liData, long computetime) {
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            for (Pair<LineageItem, Data> entry : liData) {
                long size;
                LineageItem item = (LineageItem)entry.getKey();
                Data data = (Data)entry.getValue();
                if (!LineageCache.probe(item)) continue;
                LineageCacheEntry centry = _cache.get(item);
                if (!(data instanceof MatrixObject) && !(data instanceof ScalarObject)) {
                    LineageCache.removePlaceholder(item);
                    continue;
                }
                if (LineageCacheConfig.isOutputFederated(inst, data)) {
                    LineageCache.removePlaceholder(item);
                    continue;
                }
                MatrixBlock mb = data instanceof MatrixObject ? (MatrixBlock)((MatrixObject)data).acquireReadAndRelease() : null;
                long l = size = mb != null ? mb.getInMemorySize() : (long)((ScalarObject)data).getSize();
                if (size > LineageCacheEviction.getCacheLimit()) {
                    LineageCache.removePlaceholder(item);
                    continue;
                }
                if (!LineageCacheEviction.isBelowThreshold(size)) {
                    LineageCacheEviction.makeSpace(_cache, size);
                }
                LineageCacheEviction.updateSize(size, true);
                if (data instanceof MatrixObject) {
                    centry.setValue(mb, computetime);
                } else if (data instanceof ScalarObject) {
                    centry.setValue((ScalarObject)data, computetime);
                }
                if (DMLScript.STATISTICS && LineageCacheEviction._removelist.containsKey(centry._key)) {
                    LineageCacheStatistics.incrementMissedComputeTime(centry._computeTime);
                }
                LineageCacheEviction.addEntry(centry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putValueGPU(GPUObject gpuObj, LineageItem instLI, long computetime) {
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCacheEntry centry = _cache.get(instLI);
            LineageGPUCacheEviction.updateSize(gpuObj.getSizeOnDevice(), true);
            centry.setGPUValue(gpuObj, computetime);
            LineageGPUCacheEviction.addEntry(centry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValue(List<DataIdentifier> outputs, LineageItem[] liInputs, String name, ExecutionContext ec, long computetime) {
        if (LineageCacheConfig.isEstimator()) {
            LineageEstimator.processFunc(outputs, liInputs, name, ec, computetime);
        }
        if (!LineageCacheConfig.isMultiLevelReuse()) {
            return;
        }
        HashMap<LineageItem, LineageItem> FuncLIMap = new HashMap<LineageItem, LineageItem>();
        boolean AllOutputsCacheable = true;
        for (int i = 0; i < outputs.size(); ++i) {
            String opcode = name + String.valueOf(i + 1);
            LineageItem li = new LineageItem(opcode, liInputs);
            String boundVarName = outputs.get(i).getName();
            LineageItem boundLI2 = ec.getLineage().get(boundVarName);
            if (boundLI2 != null) {
                boundLI2.resetVisitStatusNR();
            }
            if (boundLI2 == null || !LineageCache.probe(li) || !LineageCache.probe(boundLI2)) {
                AllOutputsCacheable = false;
            }
            FuncLIMap.put(li, boundLI2);
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            if (AllOutputsCacheable) {
                FuncLIMap.forEach((Li, boundLI) -> LineageCache.mvIntern(Li, boundLI, computetime));
            } else {
                FuncLIMap.forEach((Li, boundLI) -> LineageCache.removePlaceholder(Li));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValue(FederatedUDF udf, ExecutionContext ec, long computetime) {
        if (LineageCacheConfig.ReuseCacheType.isNone() || udf.getOutputIds() == null) {
            return;
        }
        List<Long> outIds = udf.getOutputIds();
        if (udf.getLineageItem(ec) == null) {
            return;
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            long size;
            LineageItem item = (LineageItem)udf.getLineageItem(ec).getValue();
            if (!LineageCache.probe(item)) {
                return;
            }
            LineageCacheEntry entry = _cache.get(item);
            Data data = ec.getVariable(String.valueOf(outIds.get(0)));
            if (!(data instanceof MatrixObject) && !(data instanceof ScalarObject)) {
                LineageCache.removePlaceholder(item);
                return;
            }
            MatrixBlock mb = data instanceof MatrixObject ? (MatrixBlock)((MatrixObject)data).acquireReadAndRelease() : null;
            long l = size = mb != null ? mb.getInMemorySize() : (long)((ScalarObject)data).getSize();
            if (size > LineageCacheEviction.getCacheLimit()) {
                LineageCache.removePlaceholder(item);
                return;
            }
            if (!LineageCacheEviction.isBelowThreshold(size)) {
                LineageCacheEviction.makeSpace(_cache, size);
            }
            LineageCacheEviction.updateSize(size, true);
            if (data instanceof MatrixObject) {
                entry.setValue(mb, computetime);
            } else if (data instanceof ScalarObject) {
                entry.setValue((ScalarObject)data, computetime);
            }
            LineageCacheEviction.addEntry(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putFedReadObject(Data data, LineageItem li, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        LineageCacheEntry entry = _cache.get(li);
        if (entry != null && data instanceof MatrixObject) {
            long t0 = System.nanoTime();
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data).acquireRead();
            long t1 = System.nanoTime();
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                long size;
                long l = size = mb != null ? mb.getInMemorySize() : 0L;
                if (size > LineageCacheEviction.getCacheLimit()) {
                    LineageCache.removePlaceholder(li);
                }
                if (!LineageCacheEviction.isBelowThreshold(size)) {
                    LineageCacheEviction.makeSpace(_cache, size);
                }
                LineageCacheEviction.updateSize(size, true);
                entry.setValue(mb, t1 - t0);
            }
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCache.removePlaceholder(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putSerializedObject(byte[] serialBytes, LineageItem objLI, long computetime) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        LineageItem li = LineageItemUtils.getSerializedFedResponseLineageItem(objLI);
        LineageCacheEntry entry = LineageCache.getIntern(li);
        if (entry != null && serialBytes != null) {
            Map<LineageItem, LineageCacheEntry> map = _cache;
            synchronized (map) {
                long size = serialBytes.length;
                if (size > LineageCacheEviction.getCacheLimit()) {
                    LineageCache.removePlaceholder(li);
                }
                if (!LineageCacheEviction.isBelowThreshold(size)) {
                    LineageCacheEviction.makeSpace(_cache, size);
                }
                LineageCacheEviction.updateSize(size, true);
                entry.setValue(serialBytes, computetime);
            }
        }
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            LineageCache.removePlaceholder(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        Map<LineageItem, LineageCacheEntry> map = _cache;
        synchronized (map) {
            _cache.clear();
            LineageCacheEviction.resetEviction();
            LineageGPUCacheEviction.resetEviction();
        }
    }

    public static Map<LineageItem, LineageCacheEntry> getLineageCache() {
        return _cache;
    }

    private static void putIntern(LineageItem key, Types.DataType dt, MatrixBlock Mval, ScalarObject Sval, long computetime) {
        if (_cache.containsKey(key)) {
            return;
        }
        LineageCacheEntry newItem = new LineageCacheEntry(key, dt, Mval, Sval, computetime);
        if (Mval != null || Sval != null) {
            long size = newItem.getSize();
            if (size > LineageCacheEviction.getCacheLimit()) {
                return;
            }
            if (!LineageCacheEviction.isBelowThreshold(size)) {
                LineageCacheEviction.makeSpace(_cache, size);
            }
            LineageCacheEviction.updateSize(size, true);
        }
        LineageCacheEviction.addEntry(newItem);
        _cache.put(key, newItem);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementMemWrites();
        }
    }

    private static LineageCacheEntry getIntern(LineageItem key) {
        LineageCacheEntry e = _cache.get(key);
        if (e != null && e.getCacheStatus() != LineageCacheConfig.LineageCacheStatus.SPILLED) {
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementMemHits();
            }
            LineageCacheEviction.getEntry(e);
            return e;
        }
        return LineageCacheEviction.readFromLocalFS(_cache, key);
    }

    private static void mvIntern(LineageItem item, LineageItem probeItem, long computetime) {
        if (LineageCacheConfig.ReuseCacheType.isNone()) {
            return;
        }
        if (LineageCache.probe(probeItem)) {
            boolean exists;
            LineageCacheEntry oe = LineageCache.getIntern(probeItem);
            LineageCacheEntry e = _cache.get(item);
            boolean bl = exists = !e.isNullVal();
            if (oe.isMatrixValue()) {
                e.setValue(oe.getMBValue(), computetime);
            } else {
                e.setValue(oe.getSOValue(), computetime);
            }
            e._origItem = probeItem;
            oe._origItem = probeItem;
            if (!exists) {
                e._nextEntry = oe._nextEntry;
                oe._nextEntry = e;
            }
            if (DMLScript.STATISTICS && LineageCacheEviction._removelist.containsKey(e._key)) {
                LineageCacheStatistics.incrementMissedComputeTime(e._computeTime);
            }
            LineageCacheEviction.addEntry(e);
        } else {
            LineageCache.removePlaceholder(item);
        }
    }

    private static void removePlaceholder(LineageItem item) {
        if (!_cache.containsKey(item)) {
            return;
        }
        LineageCacheEntry centry = _cache.get(item);
        centry.removeAndNotify();
        _cache.remove(item);
    }

    private static boolean isMarkedForCaching(Instruction inst, ExecutionContext ec) {
        CPOperand output;
        if (!LineageCacheConfig.getCompAssRW()) {
            return true;
        }
        CPOperand cPOperand = inst instanceof ComputationCPInstruction ? ((ComputationCPInstruction)inst).output : (output = inst instanceof ComputationFEDInstruction ? ((ComputationFEDInstruction)inst).output : ((GPUInstruction)inst)._output);
        if (output.isMatrix()) {
            MatrixObject mo = inst instanceof ComputationCPInstruction ? ec.getMatrixObject(((ComputationCPInstruction)inst).output) : (inst instanceof ComputationFEDInstruction ? ec.getMatrixObject(((ComputationFEDInstruction)inst).output) : ec.getMatrixObject(((GPUInstruction)inst)._output));
            return LineageCacheConfig.getCacheType() != LineageCacheConfig.ReuseCacheType.REUSE_FULL || mo.isMarked();
        }
        return true;
    }

    @Deprecated
    private static double getRecomputeEstimate(Instruction inst, ExecutionContext ec) {
        if (!((ComputationCPInstruction)inst).output.isMatrix() || ((ComputationCPInstruction)inst).input1 != null && !((ComputationCPInstruction)inst).input1.isMatrix()) {
            return 0.0;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        double nflops = 0.0;
        String instop = inst.getOpcode().contains("spoof") ? "spoof" : inst.getOpcode();
        CPInstruction.CPType cptype = CPInstructionParser.String2CPInstructionType.get(instop);
        switch (cptype) {
            case MMTSJ: {
                MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r = mo.getNumRows();
                long c = mo.getNumColumns();
                long nnz = mo.getNnz();
                double s = OptimizerUtils.getSparsity(r, c, nnz);
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(r, c, nnz);
                MMTSJ.MMTSJType type = ((MMTSJCPInstruction)inst).getMMTSJType();
                if (type.isLeft()) {
                    nflops = !sparse ? (double)(r * c) * s * (double)c / 2.0 : (double)(r * c) * s * (double)c * s / 2.0;
                    break;
                }
                nflops = !sparse ? (double)r * (double)c * (double)r / 2.0 : (double)(r * c) * s + (double)(r * c) * s * (double)c * s / 2.0;
                break;
            }
            case AggregateBinary: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                MatrixObject mo2 = ec.getMatrixObject(((ComputationCPInstruction)inst).input2);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                long r2 = mo2.getNumRows();
                long c2 = mo2.getNumColumns();
                long nnz2 = mo2.getNnz();
                double s2 = OptimizerUtils.getSparsity(r2, c2, nnz2);
                boolean rsparse = MatrixBlock.evalSparseFormatInMemory(r2, c2, nnz2);
                if (!lsparse && !rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * (c2 > 1L ? s1 : 1.0) * (double)c2) / 2.0;
                    break;
                }
                if (!lsparse && rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2 * s2) / 2.0;
                    break;
                }
                if (lsparse && !rsparse) {
                    nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2) / 2.0;
                    break;
                }
                nflops = 2.0 * ((double)(r1 * c1) * s1 * (double)c2 * s2) / 2.0;
                break;
            }
            case Binary: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                if (inst.getOpcode().equalsIgnoreCase("*") || inst.getOpcode().equalsIgnoreCase("/")) {
                    nflops = r1 * c1;
                    break;
                }
                if (!inst.getOpcode().equalsIgnoreCase("solve")) break;
                nflops = r1 * c1 * c1;
                break;
            }
            case MatrixIndexing: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                nflops = 1.0 * (lsparse ? (double)(r1 * c1) * s1 : (double)(r1 * c1));
                break;
            }
            case ParameterizedBuiltin: {
                String opcode = ((ParameterizedBuiltinCPInstruction)inst).getOpcode();
                HashMap<String, String> params = ((ParameterizedBuiltinCPInstruction)inst).getParameterMap();
                long r1 = ec.getMatrixObject(params.get("target")).getNumRows();
                String fn = params.get("fn");
                double xga = 0.0;
                if (opcode.equalsIgnoreCase("groupedagg")) {
                    if (fn.equalsIgnoreCase("sum")) {
                        xga = 4.0;
                    } else if (fn.equalsIgnoreCase("count")) {
                        xga = 1.0;
                    }
                }
                nflops = (double)(2L * r1) + xga * (double)r1;
                break;
            }
            case Reorg: {
                MatrixObject mo = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                long r = mo.getNumRows();
                long c = mo.getNumColumns();
                long nnz = mo.getNnz();
                double s = OptimizerUtils.getSparsity(r, c, nnz);
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(r, c, nnz);
                nflops = sparse ? (double)(r * c) * s : (double)(r * c);
                break;
            }
            case Append: {
                MatrixObject mo1 = ec.getMatrixObject(((ComputationCPInstruction)inst).input1);
                MatrixObject mo2 = ec.getMatrixObject(((ComputationCPInstruction)inst).input2);
                long r1 = mo1.getNumRows();
                long c1 = mo1.getNumColumns();
                long nnz1 = mo1.getNnz();
                double s1 = OptimizerUtils.getSparsity(r1, c1, nnz1);
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(r1, c1, nnz1);
                long r2 = mo2.getNumRows();
                long c2 = mo2.getNumColumns();
                long nnz2 = mo2.getNnz();
                double s2 = OptimizerUtils.getSparsity(r2, c2, nnz2);
                boolean rsparse = MatrixBlock.evalSparseFormatInMemory(r2, c2, nnz2);
                nflops = 1.0 * ((lsparse ? (double)(r1 * c1) * s1 : (double)(r1 * c1)) + (rsparse ? (double)(r2 * c2) * s2 : (double)(r2 * c2)));
                break;
            }
            case SpoofFused: {
                nflops = 0.0;
                break;
            }
            default: {
                throw new DMLRuntimeException("Lineage Cache: unsupported instruction: " + inst.getOpcode());
            }
        }
        return nflops / 2.147483648E9;
    }

    static {
        LineageCacheEviction.setCacheLimit(0.05);
        LineageCacheEviction.setStartTimestamp();
        LineageGPUCacheEviction.setStartTimestamp();
    }
}

