/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
public class ReencryptionStatusIterator
extends BatchedRemoteIterator<Long, ZoneReencryptionStatus> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public ReencryptionStatusIterator(ClientProtocol namenode, Tracer tracer) {
        super((Object)0L);
        this.namenode = namenode;
        this.tracer = tracer;
    }

    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> makeRequest(Long prevId) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listReencryptionStatus");){
            BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> batchedEntries = this.namenode.listReencryptionStatus(prevId);
            return batchedEntries;
        }
    }

    public Long elementToPrevKey(ZoneReencryptionStatus entry) {
        return entry.getId();
    }
}

