/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysds.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public class RewriteRemoveForLoopEmptySequence
extends StatementBlockRewriteRule {
    @Override
    public boolean createsSplitDag() {
        return false;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlock(StatementBlock sb, ProgramRewriteStatus state) {
        ArrayList<StatementBlock> ret = new ArrayList<StatementBlock>();
        boolean apply = false;
        if (sb instanceof ForStatementBlock) {
            LiteralOp incr;
            ForStatementBlock fsb = (ForStatementBlock)sb;
            Hop from = fsb.getFromHops().getInput().get(0);
            Hop to = fsb.getToHops().getInput().get(0);
            Hop hop = incr = fsb.getIncrementHops() != null ? fsb.getIncrementHops().getInput().get(0) : new LiteralOp(1L);
            if (from instanceof LiteralOp && to instanceof LiteralOp && incr instanceof LiteralOp) {
                double dfrom = HopRewriteUtils.getDoubleValue((LiteralOp)from);
                double dto = HopRewriteUtils.getDoubleValue((LiteralOp)to);
                double dincr = HopRewriteUtils.getDoubleValue(incr);
                if (dfrom > dto && dincr == 1.0) {
                    dincr = -1.0;
                }
                boolean bl = apply = UtilFunctions.getSeqLength(dfrom, dto, dincr, false) <= 0L;
            }
        }
        if (apply) {
            LOG.debug((Object)("Applied removeForLoopEmptySequence (lines " + sb.getBeginLine() + "-" + sb.getEndLine() + ")."));
        } else {
            ret.add(sb);
        }
        return ret;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlocks(List<StatementBlock> sbs, ProgramRewriteStatus state) {
        return sbs;
    }
}

