/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.Alias;
import com.google.api.services.directory.model.Aliases;
import com.google.api.services.directory.model.Group;
import com.google.api.services.directory.model.Groups;
import com.google.common.base.CharMatcher;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.googleapps.GoogleApiExecutor;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import net.tirasa.connid.bundles.googleapps.MembersHandler;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaUtil;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.NotFilter;
import org.identityconnectors.framework.common.objects.filter.OrFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class GroupHandler
implements FilterVisitor<StringBuilder, Directory.Groups.List> {
    private static final Log LOG = Log.getLog(GroupHandler.class);
    private static final Escaper STRING_ESCAPER = Escapers.builder().addEscape('\'', "\\'").build();

    public StringBuilder visitAndFilter(Directory.Groups.List list, AndFilter andFilter) {
        throw this.getException();
    }

    public StringBuilder visitContainsFilter(Directory.Groups.List list, ContainsFilter containsFilter) {
        if (!containsFilter.getAttribute().is("__MEMBERS__")) {
            throw this.getException();
        }
        list.setUserKey(containsFilter.getValue());
        return null;
    }

    protected StringBuilder getStringBuilder(Attribute attribute, char operator, Character postfix, String filedName) {
        StringBuilder builder = new StringBuilder();
        builder.append(filedName).append(operator);
        String stringValue = AttributeUtil.getAsStringValue((Attribute)attribute);
        if (StringUtil.isNotBlank((String)stringValue)) {
            stringValue = STRING_ESCAPER.escape(stringValue);
            if (CharMatcher.whitespace().matchesAnyOf((CharSequence)stringValue)) {
                builder.append('\'').append(stringValue);
                if (null != postfix) {
                    builder.append(postfix);
                }
                builder.append('\'');
            } else {
                builder.append(stringValue);
                if (null != postfix) {
                    builder.append(postfix);
                }
            }
        }
        return builder;
    }

    public StringBuilder visitContainsAllValuesFilter(Directory.Groups.List list, ContainsAllValuesFilter containsAllValuesFilter) {
        throw this.getException();
    }

    protected RuntimeException getException() {
        return new UnsupportedOperationException("Only EqualsFilter(['domain','customer','userKey']) and ContainsFilter('members') are supported");
    }

    public StringBuilder visitEqualsFilter(Directory.Groups.List list, EqualsFilter equalsFilter) {
        if (equalsFilter.getAttribute().is("customer")) {
            if (null != list.getDomain() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("domain")) {
            if (null != list.getCustomer() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("userKey")) {
            if (null != list.getDomain() || null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setUserKey(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            String filedName = equalsFilter.getName();
            if (null != filedName) {
                return this.getStringBuilder(equalsFilter.getAttribute(), '=', null, filedName);
            }
            throw new InvalidAttributeValueException("");
        }
        return null;
    }

    public StringBuilder visitEqualsIgnoreCaseFilter(Directory.Groups.List list, EqualsIgnoreCaseFilter equalsFilter) {
        if (equalsFilter.getAttribute().is("customer")) {
            if (null != list.getDomain() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("domain")) {
            if (null != list.getCustomer() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("userKey")) {
            if (null != list.getDomain() || null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setUserKey(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            String filedName = equalsFilter.getName();
            if (null != filedName) {
                return this.getStringBuilder(equalsFilter.getAttribute(), '=', null, filedName);
            }
            throw new InvalidAttributeValueException("");
        }
        return null;
    }

    public StringBuilder visitExtendedFilter(Directory.Groups.List list, Filter filter) {
        throw this.getException();
    }

    public StringBuilder visitGreaterThanFilter(Directory.Groups.List list, GreaterThanFilter greaterThanFilter) {
        throw this.getException();
    }

    public StringBuilder visitGreaterThanOrEqualFilter(Directory.Groups.List list, GreaterThanOrEqualFilter greaterThanOrEqualFilter) {
        throw this.getException();
    }

    public StringBuilder visitLessThanFilter(Directory.Groups.List list, LessThanFilter lessThanFilter) {
        throw this.getException();
    }

    public StringBuilder visitLessThanOrEqualFilter(Directory.Groups.List list, LessThanOrEqualFilter lessThanOrEqualFilter) {
        throw this.getException();
    }

    public StringBuilder visitNotFilter(Directory.Groups.List list, NotFilter notFilter) {
        throw this.getException();
    }

    public StringBuilder visitOrFilter(Directory.Groups.List list, OrFilter orFilter) {
        throw this.getException();
    }

    public StringBuilder visitStartsWithFilter(Directory.Groups.List list, StartsWithFilter startsWithFilter) {
        throw this.getException();
    }

    public StringBuilder visitEndsWithFilter(Directory.Groups.List list, EndsWithFilter endsWithFilter) {
        throw this.getException();
    }

    public static ObjectClassInfo getObjectClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(ObjectClass.GROUP_NAME);
        builder.addAttributeInfo(Name.INFO);
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"id"));
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"name"));
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"description"));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"adminCreated", Boolean.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"aliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"nonEditableAliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"directMembersCount", Long.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"__MEMBERS__").setMultiValued(true).setReturnedByDefault(false).build());
        return builder.build();
    }

    public static Directory.Groups.Insert create(Directory.Groups service, AttributesAccessor attributes) {
        Group group = new Group();
        group.setEmail(GoogleAppsUtil.getName(attributes.getName()));
        group.setDescription(attributes.findString("description"));
        group.setName(attributes.findString("name"));
        try {
            return service.insert(group).setFields("id,email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Set<String> listAliases(Directory.Groups.Aliases service, final String groupKey) {
        try {
            return GoogleApiExecutor.execute(service.list(groupKey), new RequestResultHandler<Directory.Groups.Aliases.List, Aliases, Set<String>>(){

                @Override
                public Set<String> handleResult(Directory.Groups.Aliases.List request, Aliases value) {
                    return Optional.ofNullable(value.getAliases()).map(aliases -> aliases.stream().map(map -> (String)((Map)map).get("alias")).filter(Objects::nonNull).collect(Collectors.toSet())).orElse(Collections.emptySet());
                }

                @Override
                public Set<String> handleError(Throwable e) {
                    LOG.error(e, "While getting aliases for {0}", new Object[]{groupKey});
                    return Collections.emptySet();
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#list", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Groups.Aliases.Insert createGroupAlias(Directory.Groups.Aliases service, String groupKey, String alias) {
        Alias content = new Alias();
        content.setAlias(alias);
        try {
            return service.insert(groupKey, content).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Groups.Aliases.Delete deleteGroupAlias(Directory.Groups.Aliases service, String groupKey, String alias) {
        try {
            return service.delete(groupKey, alias);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private static void set(AtomicReference<Group> content, Consumer<Group> consumer) {
        if (content.get() == null) {
            content.set(new Group());
        }
        consumer.accept(content.get());
    }

    public static Directory.Groups.Patch update(Directory.Groups service, String groupKey, AttributesAccessor attributes) {
        AtomicReference content = new AtomicReference();
        Optional.ofNullable(attributes.getName()).filter(email -> !StringUtil.isBlank((String)email.getNameValue())).ifPresent(email -> GroupHandler.set(content, g -> g.setEmail(email.getNameValue())));
        Optional.ofNullable(attributes.find("name")).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> GroupHandler.set(content, g -> g.setName(stringValue)));
        Optional.ofNullable(attributes.find("description")).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> GroupHandler.set(content, g -> g.setDescription(stringValue)));
        if (null == content.get()) {
            return null;
        }
        try {
            return service.patch(groupKey, (Group)content.get()).setFields("id,email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Patch", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Groups.Update update(Directory.Groups service, String groupKey, Set<AttributeDelta> modifications) {
        if (AttributeDeltaUtil.getUidAttributeDelta(modifications) != null || AttributeDeltaUtil.getAttributeDeltaForName(modifications) != null) {
            throw new IllegalArgumentException("Do not perform rename via updateDelta, use standard update");
        }
        AtomicReference content = new AtomicReference();
        Optional.ofNullable(AttributeDeltaUtil.find((String)"name", modifications)).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> GroupHandler.set(content, g -> g.setName(stringValue)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"description", modifications)).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> GroupHandler.set(content, g -> g.setDescription(stringValue)));
        if (null == content.get()) {
            return null;
        }
        try {
            return service.update(groupKey, (Group)content.get()).setFields("id,email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#update", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Set<String> listGroups(Directory.Groups service, String userKey, String domain) {
        final SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        try {
            String nextPageToken;
            Directory.Groups.List request = service.list().setUserKey(userKey).setFields("groups/id").setDomain(domain);
            while (StringUtil.isNotBlank((String)(nextPageToken = GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Groups.List, Groups, String>(){

                @Override
                public String handleResult(Directory.Groups.List request, Groups value) {
                    if (null != value.getGroups()) {
                        value.getGroups().stream().map(Group::getId).forEach(result::add);
                    }
                    return value.getNextPageToken();
                }
            })))) {
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        return result;
    }

    public static ConnectorObject fromGroup(Group group, Set<String> attributesToGet, Directory.Members service) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        if (null != group.getEtag()) {
            builder.setUid(new Uid(group.getId(), group.getEtag()));
        } else {
            builder.setUid(group.getId());
        }
        builder.setName(group.getEmail());
        if (null == attributesToGet || attributesToGet.contains("name")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"name", (Object[])new Object[]{group.getName()})});
        }
        if (null == attributesToGet || attributesToGet.contains("email")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"email", (Object[])new Object[]{group.getEmail()})});
        }
        if (null == attributesToGet || attributesToGet.contains("description")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"description", (Object[])new Object[]{group.getDescription()})});
        }
        if (null == attributesToGet || attributesToGet.contains("adminCreated")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"adminCreated", (Object[])new Object[]{group.getAdminCreated()})});
        }
        if (null == attributesToGet || attributesToGet.contains("aliases")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"aliases", (Collection)group.getAliases())});
        }
        if (null == attributesToGet || attributesToGet.contains("nonEditableAliases")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"nonEditableAliases", (Collection)group.getNonEditableAliases())});
        }
        if (null == attributesToGet || attributesToGet.contains("directMembersCount")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"directMembersCount", (Object[])new Object[]{group.getDirectMembersCount()})});
        }
        if (null != attributesToGet && attributesToGet.contains("__MEMBERS__")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"__MEMBERS__", MembersHandler.listMembers(service, group.getId(), null))});
        }
        return builder.build();
    }
}

