/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaElementType;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchingRuleDefinition
extends SchemaElement {
    private static final long serialVersionUID = 8214648655449007967L;
    private final boolean isObsolete;
    @NotNull
    private final Map<String, String[]> extensions;
    @Nullable
    private final String description;
    @NotNull
    private final String matchingRuleString;
    @NotNull
    private final String oid;
    @NotNull
    private final String syntaxOID;
    @NotNull
    private final String[] names;

    public MatchingRuleDefinition(@NotNull String s) throws LDAPException {
        LinkedHashMap<String, String[]> exts;
        String synOID;
        Boolean obsolete;
        String descr;
        ArrayList<String> nameList;
        block17: {
            String token;
            Validator.ensureNotNull(s);
            this.matchingRuleString = s.trim();
            int length = this.matchingRuleString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_EMPTY.get());
            }
            if (this.matchingRuleString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_NO_OPENING_PAREN.get(this.matchingRuleString));
            }
            int pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = MatchingRuleDefinition.readOID(this.matchingRuleString, pos, length, buffer);
            this.oid = buffer.toString();
            nameList = new ArrayList<String>(1);
            descr = null;
            obsolete = null;
            synOID = null;
            exts = new LinkedHashMap<String, String[]>(StaticUtils.computeMapCapacity(5));
            while (true) {
                String lowerToken;
                int tokenStartPos = pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                while (pos < length && this.matchingRuleString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.matchingRuleString.substring(tokenStartPos, pos);
                if (token.length() > 1 && token.endsWith(")")) {
                    token = token.substring(0, token.length() - 1);
                    --pos;
                }
                if ((lowerToken = StaticUtils.toLowerCase(token)).equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_CLOSE_NOT_AT_END.get(this.matchingRuleString));
                    }
                    break block17;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                        pos = MatchingRuleDefinition.readQDStrings(this.matchingRuleString, pos, length, token, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                        buffer = new StringBuilder();
                        pos = MatchingRuleDefinition.readQDString(this.matchingRuleString, pos, length, token, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "OBSOLETE"));
                }
                if (lowerToken.equals("syntax")) {
                    if (synOID == null) {
                        pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                        buffer = new StringBuilder();
                        pos = MatchingRuleDefinition.readOID(this.matchingRuleString, pos, length, buffer);
                        synOID = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "SYNTAX"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>(5);
                pos = MatchingRuleDefinition.readQDStrings(this.matchingRuleString, pos, length, token, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_DUP_EXT.get(this.matchingRuleString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_UNEXPECTED_TOKEN.get(this.matchingRuleString, token));
        }
        this.description = descr;
        this.syntaxOID = synOID;
        if (this.syntaxOID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_NO_SYNTAX.get(this.matchingRuleString));
        }
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        this.isObsolete = obsolete != null;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public MatchingRuleDefinition(@NotNull String oid, @Nullable String name, @Nullable String description, @NotNull String syntaxOID, @Nullable Map<String, String[]> extensions) {
        String[] stringArray;
        if (name == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        this(oid, stringArray, description, false, syntaxOID, extensions);
    }

    public MatchingRuleDefinition(@NotNull String oid, @Nullable String[] names, @Nullable String description, boolean isObsolete, @NotNull String syntaxOID, @Nullable Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid, syntaxOID);
        this.oid = oid;
        this.description = description;
        this.isObsolete = isObsolete;
        this.syntaxOID = syntaxOID;
        this.names = names == null ? StaticUtils.NO_STRINGS : names;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.matchingRuleString = buffer.toString();
    }

    private void createDefinitionString(@NotNull StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            MatchingRuleDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" SYNTAX ");
        buffer.append(this.syntaxOID);
        for (Map.Entry<String, String[]> e : this.extensions.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                MatchingRuleDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                MatchingRuleDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    @NotNull
    public String getOID() {
        return this.oid;
    }

    @NotNull
    public String[] getNames() {
        return this.names;
    }

    @NotNull
    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(@NotNull String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(this.oid);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @NotNull
    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    @NotNull
    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    @NotNull
    public SchemaElementType getSchemaElementType() {
        return SchemaElementType.MATCHING_RULE;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchingRuleDefinition)) {
            return false;
        }
        MatchingRuleDefinition d = (MatchingRuleDefinition)o;
        return this.oid.equals(d.oid) && this.syntaxOID.equals(d.syntaxOID) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, d.names) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, d.description) && this.isObsolete == d.isObsolete && MatchingRuleDefinition.extensionsEqual(this.extensions, d.extensions);
    }

    @Override
    @NotNull
    public String toString() {
        return this.matchingRuleString;
    }
}

