/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.scope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public abstract class AbstractWebFlowScope
implements Scope {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public Object get(String name, ObjectFactory<?> objectFactory) {
        MutableAttributeMap<Object> scope = this.getScope();
        Object scopedObject = scope.get(name);
        if (scopedObject == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No scoped instance '" + name + "' found; creating new instance"));
            }
            scopedObject = objectFactory.getObject();
            scope.put(name, scopedObject);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning scoped instance '" + name + "'"));
        }
        return scopedObject;
    }

    public Object remove(String name) {
        return this.getScope().remove(name);
    }

    protected abstract MutableAttributeMap<Object> getScope() throws IllegalStateException;

    public String getConversationId() {
        return null;
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.logger.warn((Object)("Destruction callback for '" + name + "' was not registered. Spring Web Flow does not support destruction of scoped beans."));
    }

    protected RequestContext getRequiredRequestContext() {
        RequestContext context = RequestContextHolder.getRequestContext();
        if (context == null) {
            throw new IllegalStateException("No request context bound to this thread; to access flow-scoped beans you must be running in a flow execution request");
        }
        return context;
    }
}

