/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.wa.MfaTrustedDevice;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;

public class MfaTrusStorageLogic
extends AbstractAuthProfileLogic {
    protected final EntityFactory entityFactory;

    public MfaTrusStorageLogic(EntityFactory entityFactory, AuthProfileDAO authProfileDAO, AuthProfileDataBinder binder) {
        super(authProfileDAO, binder);
        this.entityFactory = entityFactory;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public Pair<Integer, List<MfaTrustedDevice>> search(Integer page, Integer itemsPerPage, String principal, Long id, OffsetDateTime recordDate, List<OrderByClause> orderByClauses) {
        List comparatorList = orderByClauses.stream().map(orderByClause -> {
            Comparator comparator = null;
            if (orderByClause.getField().equals("id")) {
                comparator = (o1, o2) -> new CompareToBuilder().append(o1.getId(), o2.getId()).toComparison();
            }
            if (orderByClause.getField().equals("expirationDate")) {
                comparator = (o1, o2) -> new CompareToBuilder().append((Object)o1.getExpirationDate(), (Object)o2.getExpirationDate()).toComparison();
            }
            if (orderByClause.getField().equals("recordDate")) {
                comparator = (o1, o2) -> new CompareToBuilder().append((Object)o1.getRecordDate(), (Object)o2.getRecordDate()).toComparison();
            }
            if (comparator != null) {
                if (orderByClause.getDirection() == OrderByClause.Direction.DESC) {
                    return comparator.reversed();
                }
                return comparator;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List devices = (principal == null ? this.authProfileDAO.findAll(-1, -1).stream().map(AuthProfile::getMfaTrustedDevices).filter(Objects::nonNull).flatMap(Collection::stream) : this.authProfileDAO.findByOwner(principal).map(AuthProfile::getMfaTrustedDevices).filter(Objects::nonNull).map(Collection::stream).orElse(Stream.empty())).filter(device -> {
            EqualsBuilder builder = new EqualsBuilder();
            builder.appendSuper(device.getExpirationDate().isAfter(ZonedDateTime.now()));
            if (id != null) {
                builder.append((Object)id, (Object)device.getId());
            }
            if (recordDate != null) {
                builder.appendSuper(device.getRecordDate().isAfter(recordDate.toZonedDateTime()));
            }
            return builder.build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List result = devices.stream().limit(itemsPerPage.intValue()).skip((long)itemsPerPage.intValue() * (page <= 0 ? 0L : page.longValue() - 1L)).sorted((o1, o2) -> {
            for (Comparator comparator : comparatorList) {
                int compare = comparator.compare(o1, o2);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }).collect(Collectors.toList());
        return Pair.of((Object)devices.size(), result);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void create(String owner, MfaTrustedDevice device) {
        AuthProfile profile = this.authProfileDAO.findByOwner(owner).orElseGet(() -> {
            AuthProfile authProfile = (AuthProfile)this.entityFactory.newEntity(AuthProfile.class);
            authProfile.setOwner(owner);
            return authProfile;
        });
        List devices = profile.getMfaTrustedDevices();
        devices.add(device);
        profile.setMfaTrustedDevices(devices);
        this.authProfileDAO.save(profile);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(OffsetDateTime expirationDate, String recordKey) {
        List profiles = this.authProfileDAO.findAll(-1, -1);
        profiles.forEach(profile -> {
            List<MfaTrustedDevice> devices = profile.getMfaTrustedDevices();
            if (devices != null) {
                if (recordKey != null) {
                    devices.removeIf(device -> recordKey.equals(device.getRecordKey()));
                } else if (expirationDate != null) {
                    devices.removeIf(device -> device.getExpirationDate().isBefore(expirationDate.toZonedDateTime()));
                } else {
                    devices = List.of();
                }
                profile.setMfaTrustedDevices(devices);
                this.authProfileDAO.save(profile);
            }
        });
    }
}

