/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.clustered.client.internal.config.ClusteredResourcePoolImpl;
import org.ehcache.clustered.client.internal.config.DedicatedClusteredResourcePoolImpl;
import org.ehcache.clustered.client.internal.config.SharedClusteredResourcePoolImpl;
import org.ehcache.clustered.client.internal.config.xml.ClusteredCacheConstants;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.xml.BaseConfigParser;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class ClusteredResourceConfigurationParser
extends BaseConfigParser<ResourcePool>
implements CacheResourceConfigurationParser {
    private static final String CLUSTERED_ELEMENT_NAME = "clustered";
    private static final String DEDICATED_ELEMENT_NAME = "clustered-dedicated";
    private static final String SHARED_ELEMENT_NAME = "clustered-shared";
    private static final String FROM_ELEMENT_NAME = "from";
    private static final String UNIT_ELEMENT_NAME = "unit";
    private static final String SHARING_ELEMENT_NAME = "sharing";

    public ClusteredResourceConfigurationParser() {
        super(ResourcePool.class);
    }

    public Source getXmlSchema() throws IOException {
        return new StreamSource(ClusteredCacheConstants.XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return ClusteredCacheConstants.NAMESPACE;
    }

    protected ResourcePool parseResourceConfig(Element fragment) {
        String elementName;
        switch (elementName = fragment.getLocalName()) {
            case "clustered-shared": {
                String sharing = fragment.getAttribute(SHARING_ELEMENT_NAME);
                return new SharedClusteredResourcePoolImpl(sharing);
            }
            case "clustered-dedicated": {
                long size;
                String sizeValue;
                MemoryUnit sizeUnits;
                Attr fromAttr = fragment.getAttributeNode(FROM_ELEMENT_NAME);
                String from = fromAttr == null ? null : fromAttr.getValue();
                String unitValue = fragment.getAttribute(UNIT_ELEMENT_NAME).toUpperCase();
                try {
                    sizeUnits = MemoryUnit.valueOf((String)unitValue);
                }
                catch (IllegalArgumentException e) {
                    throw new XmlConfigurationException(String.format("XML configuration element <%s> 'unit' attribute '%s' is not valid", elementName, unitValue), (Throwable)e);
                }
                try {
                    sizeValue = fragment.getFirstChild().getNodeValue();
                }
                catch (DOMException e) {
                    throw new XmlConfigurationException(String.format("XML configuration element <%s> value is not valid", elementName), (Throwable)e);
                }
                try {
                    size = Long.parseLong(sizeValue);
                }
                catch (NumberFormatException e) {
                    throw new XmlConfigurationException(String.format("XML configuration element <%s> value '%s' is not valid", elementName, sizeValue), (Throwable)e);
                }
                return new DedicatedClusteredResourcePoolImpl(from, size, sizeUnits);
            }
            case "clustered": {
                return new ClusteredResourcePoolImpl();
            }
        }
        return null;
    }

    public ResourcePool parseResourceConfiguration(Element fragment) {
        ResourcePool resourcePool = this.parseResourceConfig(fragment);
        if (resourcePool != null) {
            return resourcePool;
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Element unparseResourcePool(ResourcePool resourcePool) {
        return this.unparseConfig(resourcePool);
    }

    protected Element createRootElement(Document doc, ResourcePool resourcePool) {
        Element rootElement = null;
        if (ClusteredResourcePoolImpl.class == resourcePool.getClass()) {
            rootElement = doc.createElementNS(this.getNamespace().toString(), "tc:clustered");
        } else if (DedicatedClusteredResourcePoolImpl.class == resourcePool.getClass()) {
            DedicatedClusteredResourcePoolImpl dedicatedClusteredResourcePool = (DedicatedClusteredResourcePoolImpl)resourcePool;
            rootElement = doc.createElementNS(this.getNamespace().toString(), "tc:clustered-dedicated");
            if (dedicatedClusteredResourcePool.getFromResource() != null) {
                rootElement.setAttribute(FROM_ELEMENT_NAME, dedicatedClusteredResourcePool.getFromResource());
            }
            rootElement.setAttribute(UNIT_ELEMENT_NAME, dedicatedClusteredResourcePool.getUnit().toString());
            rootElement.setTextContent(String.valueOf(dedicatedClusteredResourcePool.getSize()));
        } else if (SharedClusteredResourcePoolImpl.class == resourcePool.getClass()) {
            SharedClusteredResourcePoolImpl sharedClusteredResourcePool = (SharedClusteredResourcePoolImpl)resourcePool;
            rootElement = doc.createElementNS(this.getNamespace().toString(), "tc:clustered-shared");
            rootElement.setAttribute(SHARING_ELEMENT_NAME, sharedClusteredResourcePool.getSharedResourcePool());
        }
        return rootElement;
    }

    public Set<Class<? extends ResourcePool>> getResourceTypes() {
        return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(ClusteredResourcePoolImpl.class, DedicatedClusteredResourcePoolImpl.class, SharedClusteredResourcePoolImpl.class)));
    }
}

