/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;

public class U2FInMemoryDeviceRepository
extends BaseU2FDeviceRepository {
    private final LoadingCache<String, List<U2FDeviceRegistration>> userStorage;

    public U2FInMemoryDeviceRepository(LoadingCache<String, List<U2FDeviceRegistration>> userStorage, LoadingCache<String, String> requestStorage, CipherExecutor<Serializable, String> cipherExecutor, CasConfigurationProperties casProperties) {
        super(casProperties, requestStorage, cipherExecutor);
        this.userStorage = userStorage;
    }

    @Override
    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices() {
        return this.userStorage.asMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<U2FDeviceRegistration> getRegisteredDevices(String username) {
        return (List)FunctionUtils.doUnchecked(() -> {
            List values = (List)this.userStorage.get((Object)username);
            if (values == null) {
                return new ArrayList(0);
            }
            return values;
        });
    }

    @Override
    public U2FDeviceRegistration registerDevice(U2FDeviceRegistration registration) {
        Collection values = this.getRegisteredDevices(registration.getUsername());
        values.add(registration);
        this.userStorage.put((Object)registration.getUsername(), new ArrayList(values));
        return registration;
    }

    @Override
    public boolean isDeviceRegisteredFor(String username) {
        List values = (List)this.userStorage.get((Object)username);
        return values != null && !values.isEmpty();
    }

    @Override
    public void deleteRegisteredDevice(U2FDeviceRegistration registration) {
        List values = (List)this.userStorage.get((Object)registration.getUsername());
        if (values != null) {
            values.removeIf(r -> r.getId() == registration.getId());
            this.userStorage.put((Object)registration.getUsername(), (Object)values);
        }
    }

    @Override
    public void clean() {
        this.userStorage.cleanUp();
    }

    @Override
    public void removeAll() {
        this.userStorage.invalidateAll();
    }
}

