/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.AbstractMultipleInputTransformation;

@Internal
public class KeyedMultipleInputTransformation<OUT>
extends AbstractMultipleInputTransformation<OUT> {
    private final List<KeySelector<?, ?>> stateKeySelectors = new ArrayList();
    protected final TypeInformation<?> stateKeyType;

    public KeyedMultipleInputTransformation(String name, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<OUT> outputType, int parallelism, TypeInformation<?> stateKeyType) {
        super(name, operatorFactory, outputType, parallelism);
        this.stateKeyType = stateKeyType;
        this.updateManagedMemoryStateBackendUseCase(true);
    }

    public KeyedMultipleInputTransformation<OUT> addInput(Transformation<?> input, KeySelector<?, ?> keySelector) {
        this.inputs.add(input);
        this.getStateKeySelectors().add(keySelector);
        return this;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    public List<KeySelector<?, ?>> getStateKeySelectors() {
        return this.stateKeySelectors;
    }
}

