/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SaslOutputStream
extends OutputStream {
    private final OutputStream outStream;
    private byte[] saslToken;
    private final SaslClient saslClient;
    private final SaslServer saslServer;
    private final byte[] ibuffer = new byte[1];
    private final boolean useWrap;

    public SaslOutputStream(OutputStream outStream, SaslServer saslServer) {
        this.saslServer = saslServer;
        this.saslClient = null;
        String qop = (String)saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        this.useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
        this.outStream = this.useWrap ? new BufferedOutputStream(outStream, 65536) : outStream;
    }

    public SaslOutputStream(OutputStream outStream, SaslClient saslClient) {
        this.saslServer = null;
        this.saslClient = saslClient;
        String qop = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        this.useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
        this.outStream = this.useWrap ? new BufferedOutputStream(outStream, 65536) : outStream;
    }

    private void disposeSasl() throws SaslException {
        if (this.saslClient != null) {
            this.saslClient.dispose();
        }
        if (this.saslServer != null) {
            this.saslServer.dispose();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.useWrap) {
            this.outStream.write(b);
            return;
        }
        this.ibuffer[0] = (byte)b;
        this.write(this.ibuffer, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] inBuf, int off, int len) throws IOException {
        if (!this.useWrap) {
            this.outStream.write(inBuf, off, len);
            return;
        }
        try {
            this.saslToken = this.saslServer != null ? this.saslServer.wrap(inBuf, off, len) : this.saslClient.wrap(inBuf, off, len);
        }
        catch (SaslException se) {
            try {
                this.disposeSasl();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
            throw se;
        }
        if (this.saslToken != null) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(byteOut);
            dout.writeInt(this.saslToken.length);
            this.outStream.write(byteOut.toByteArray());
            this.outStream.write(this.saslToken, 0, this.saslToken.length);
            this.saslToken = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.outStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.disposeSasl();
        this.outStream.close();
    }
}

