/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.ApiDetailException;

@TableName(value="t_flink_env")
public class FlinkEnv
implements Serializable {
    @TableId(type=IdType.AUTO)
    private Long id;
    private String flinkName;
    private String flinkHome;
    private String flinkConf;
    private String description;
    private String scalaVersion;
    private String version;
    private Boolean isDefault;
    private Date createTime;
    private transient FlinkVersion flinkVersion;
    private transient String streamParkScalaVersion = scala.util.Properties.versionNumberString();

    public void doSetFlinkConf() throws ApiDetailException {
        File yaml;
        float ver = Float.parseFloat(this.getVersionOfFirst().concat(".").concat(this.getVersionOfMiddle()));
        if (ver < 1.19f) {
            yaml = new File(this.flinkHome.concat("/conf/flink-conf.yaml"));
            if (!yaml.exists()) {
                throw new ApiAlertException("cannot find flink-conf.yaml in flink/conf ");
            }
        } else if (ver == 1.19f) {
            yaml = new File(this.flinkHome.concat("/conf/flink-conf.yaml"));
            if (!yaml.exists()) {
                yaml = new File(this.flinkHome.concat("/conf/config.yaml"));
            }
            if (!yaml.exists()) {
                throw new ApiAlertException("cannot find config.yaml|flink-conf.yaml in flink/conf ");
            }
        } else {
            yaml = new File(this.flinkHome.concat("/conf/config.yaml"));
            if (!yaml.exists()) {
                throw new ApiAlertException("cannot find config.yaml in flink/conf ");
            }
        }
        try {
            String flinkConf = FileUtils.readFileToString((File)yaml, (Charset)StandardCharsets.UTF_8);
            this.flinkConf = DeflaterUtils.zipString((String)flinkConf);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
    }

    public void doSetVersion() {
        this.setVersion(this.getFlinkVersion().version());
        this.setScalaVersion(this.getFlinkVersion().scalaVersion());
        if (!this.streamParkScalaVersion.startsWith(this.getFlinkVersion().scalaVersion())) {
            throw new UnsupportedOperationException(String.format("The current Scala version of StreamPark is %s, but the scala version of Flink to be added is %s, which does not match, Please check", this.streamParkScalaVersion, this.getFlinkVersion().scalaVersion()));
        }
    }

    public Map<String, String> convertFlinkYamlAsMap() {
        String flinkYamlString = DeflaterUtils.unzipString((String)this.flinkConf);
        return PropertiesUtils.loadFlinkConfYaml((String)flinkYamlString);
    }

    @JsonIgnore
    public Properties getFlinkConfig() {
        String flinkYamlString = DeflaterUtils.unzipString((String)this.flinkConf);
        Properties flinkConfig = new Properties();
        HashMap config = PropertiesUtils.loadFlinkConfYaml((String)flinkYamlString);
        flinkConfig.putAll((Map<?, ?>)config);
        return flinkConfig;
    }

    @JsonIgnore
    public FlinkVersion getFlinkVersion() {
        if (this.flinkVersion == null) {
            this.flinkVersion = new FlinkVersion(this.flinkHome);
        }
        return this.flinkVersion;
    }

    public void unzipFlinkConf() {
        this.flinkConf = DeflaterUtils.unzipString((String)this.flinkConf);
    }

    @JsonIgnore
    public String getLargeVersion() {
        return this.version.substring(0, this.version.lastIndexOf("."));
    }

    @JsonIgnore
    public String getVersionOfFirst() {
        return this.version.split("\\.")[0];
    }

    @JsonIgnore
    public String getVersionOfMiddle() {
        return this.version.split("\\.")[1];
    }

    @JsonIgnore
    public String getVersionOfLast() {
        return this.version.split("\\.")[2];
    }

    public Long getId() {
        return this.id;
    }

    public String getFlinkName() {
        return this.flinkName;
    }

    public String getFlinkHome() {
        return this.flinkHome;
    }

    public String getFlinkConf() {
        return this.flinkConf;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScalaVersion() {
        return this.scalaVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getStreamParkScalaVersion() {
        return this.streamParkScalaVersion;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFlinkName(String flinkName) {
        this.flinkName = flinkName;
    }

    public void setFlinkHome(String flinkHome) {
        this.flinkHome = flinkHome;
    }

    public void setFlinkConf(String flinkConf) {
        this.flinkConf = flinkConf;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScalaVersion(String scalaVersion) {
        this.scalaVersion = scalaVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setFlinkVersion(FlinkVersion flinkVersion) {
        this.flinkVersion = flinkVersion;
    }

    public void setStreamParkScalaVersion(String streamParkScalaVersion) {
        this.streamParkScalaVersion = streamParkScalaVersion;
    }
}

