/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.util.FileUtils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.bean.MavenPom;
import org.apache.streampark.flink.packer.maven.Artifact;
import org.apache.streampark.flink.packer.maven.MavenArtifact;

public class MavenDependency {
    private Set<MavenPom> pom = Collections.emptySet();
    private Set<String> jar = Collections.emptySet();

    public static MavenDependency of(String dependency) {
        if (StringUtils.isNotBlank((CharSequence)dependency)) {
            return JacksonUtils.read(dependency, MavenDependency.class);
        }
        return new MavenDependency();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        MavenDependency thatDep = (MavenDependency)that;
        if (this.pom.size() != thatDep.pom.size() || this.jar.size() != thatDep.jar.size() || !this.pom.containsAll(thatDep.pom)) {
            return false;
        }
        File localJar = WebUtils.getAppTempDir();
        File localUploads = new File(Workspace.local().APP_UPLOADS());
        for (String jarName : this.jar) {
            if (thatDep.jar.contains(jarName) && FileUtils.equals((File)new File(localJar, jarName), (File)new File(localUploads, jarName))) continue;
            return false;
        }
        return true;
    }

    public MavenArtifact toMavenArtifact() {
        List mvnArts = this.pom.stream().map(pom -> new Artifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), pom.getClassifier(), pom.toExclusionString())).collect(Collectors.toList());
        List extJars = this.jar.stream().map(jar -> Workspace.local().APP_UPLOADS() + "/" + jar).collect(Collectors.toList());
        return new MavenArtifact(mvnArts, extJars);
    }

    public Set<MavenPom> getPom() {
        return this.pom;
    }

    public Set<String> getJar() {
        return this.jar;
    }

    public void setPom(Set<MavenPom> pom) {
        this.pom = pom;
    }

    public void setJar(Set<String> jar) {
        this.jar = jar;
    }
}

