/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.ingress;

import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.Serializable;
import java.util.Map;
import org.apache.flink.client.program.ClusterClient;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.kubernetes.ingress.IngressStrategy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E!1Q\n\u0001Q\u0005\n9CQa\u0018\u0001\u0005B\u0001\u0014\u0011#\u00138he\u0016\u001c8o\u0015;sCR,w-\u001f,2\u0015\t9\u0001\"A\u0004j]\u001e\u0014Xm]:\u000b\u0005%Q\u0011AC6vE\u0016\u0014h.\u001a;fg*\u00111\u0002D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001b9\t!b\u001d;sK\u0006l\u0007/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tYB$D\u0001\u0007\u0013\tibAA\bJ]\u001e\u0014Xm]:TiJ\fG/Z4z\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\u001c\u0001\u0005iq-\u001a;J]\u001e\u0014Xm]:Ve2$2aI%L)\t!s\u0006\u0005\u0002&Y9\u0011aE\u000b\t\u0003OYi\u0011\u0001\u000b\u0006\u0003SI\ta\u0001\u0010:p_Rt\u0014BA\u0016\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-2\u0002B\u0002\u0019\u0003\t\u0003\u0007\u0011'A\u0007dYV\u001cH/\u001a:DY&,g\u000e\u001e\t\u0004+I\"\u0014BA\u001a\u0017\u0005!a$-\u001f8b[\u0016t\u0004GA\u001bA!\r1DHP\u0007\u0002o)\u0011\u0001(O\u0001\baJ|wM]1n\u0015\tQ4(\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u00179I!!P\u001c\u0003\u001b\rcWo\u001d;fe\u000ec\u0017.\u001a8u!\ty\u0004\t\u0004\u0001\u0005\u0013\u0005{\u0013\u0011!A\u0001\u0006\u0003\u0011%aA0%cE\u00111I\u0012\t\u0003+\u0011K!!\u0012\f\u0003\u000f9{G\u000f[5oOB\u0011QcR\u0005\u0003\u0011Z\u00111!\u00118z\u0011\u0015Q%\u00011\u0001%\u0003%q\u0017-\\3Ta\u0006\u001cW\rC\u0003M\u0005\u0001\u0007A%A\u0005dYV\u001cH/\u001a:JI\u0006YBo\\;dQ&swM]3tg\n\u000b7m[3oIJ+7\u000f\u001e)peR$Ba\u0014*^=B\u0011Q\u0003U\u0005\u0003#Z\u00111!\u00138u\u0011\u0015Q4\u00011\u0001T!\t!6,D\u0001V\u0015\tQdK\u0003\u0002\n/*\u0011\u0001,W\u0001\bM\u0006\u0014'/[29\u0015\u0005Q\u0016AA5p\u0013\taVKA\fEK\u001a\fW\u000f\u001c;Lk\n,'O\\3uKN\u001cE.[3oi\")Aj\u0001a\u0001I!)!j\u0001a\u0001I\u0005\u00012m\u001c8gS\u001e,(/Z%oOJ,7o\u001d\u000b\u0005C\u00124w\r\u0005\u0002\u0016E&\u00111M\u0006\u0002\u0005+:LG\u000fC\u0003f\t\u0001\u0007A%\u0001\u0006e_6\f\u0017N\u001c(b[\u0016DQ\u0001\u0014\u0003A\u0002\u0011BQA\u0013\u0003A\u0002\u0011\u0002")
public class IngressStrategyV1
implements IngressStrategy {
    private final String REST_SERVICE_IDENTIFICATION;
    private String ingressClass;
    private volatile boolean bitmap$0;

    @Override
    public String prepareIngressTemplateFiles(String buildWorkspace, String ingressTemplates) {
        return IngressStrategy.prepareIngressTemplateFiles$(this, buildWorkspace, ingressTemplates);
    }

    @Override
    public scala.collection.immutable.Map<String, String> buildIngressAnnotations(String clusterId, String namespace) {
        return IngressStrategy.buildIngressAnnotations$(this, clusterId, namespace);
    }

    @Override
    public scala.collection.immutable.Map<String, String> buildIngressLabels(String clusterId) {
        return IngressStrategy.buildIngressLabels$(this, clusterId);
    }

    @Override
    public OwnerReference getOwnerReference(String nameSpace, String clusterId, DefaultKubernetesClient client) {
        return IngressStrategy.getOwnerReference$(this, nameSpace, clusterId, client);
    }

    @Override
    public String REST_SERVICE_IDENTIFICATION() {
        return this.REST_SERVICE_IDENTIFICATION;
    }

    private String ingressClass$lzycompute() {
        IngressStrategyV1 ingressStrategyV1 = this;
        synchronized (ingressStrategyV1) {
            if (!this.bitmap$0) {
                this.ingressClass = IngressStrategy.ingressClass$(this);
                this.bitmap$0 = true;
            }
        }
        return this.ingressClass;
    }

    @Override
    public String ingressClass() {
        return !this.bitmap$0 ? this.ingressClass$lzycompute() : this.ingressClass;
    }

    @Override
    public void org$apache$streampark$flink$kubernetes$ingress$IngressStrategy$_setter_$REST_SERVICE_IDENTIFICATION_$eq(String x$1) {
        this.REST_SERVICE_IDENTIFICATION = x$1;
    }

    @Override
    public String getIngressUrl(String nameSpace, String clusterId, Function0<ClusterClient<?>> clusterClient) {
        DefaultKubernetesClient x$7 = new DefaultKubernetesClient();
        Function1 & Serializable & scala.Serializable x$8 = (Function1 & Serializable & scala.Serializable)client -> {
            String value;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string;
                Ingress ingress2 = (Ingress)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Ingress)((Gettable)((Nameable)client.network().v1().ingresses().inNamespace(nameSpace)).withName(clusterId)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
                if (ingress2 == null) {
                    ClusterClient x$1 = (ClusterClient)clusterClient.apply();
                    Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> client.getWebInterfaceURL();
                    Null$ x$3 = Utils$.MODULE$.using$default$3((AutoCloseable)x$1, (Function1)x$2);
                    string = (String)Utils$.MODULE$.using((AutoCloseable)x$1, (Function1)x$2, null);
                } else {
                    string = (String)Option$.MODULE$.apply((Object)ingress2).map((Function1 & Serializable & scala.Serializable)ingress -> (IngressRule)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(ingress.getSpec().getRules()).head()).map((Function1 & Serializable & scala.Serializable)rule -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rule.getHost()), (Object)((HTTPIngressPath)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rule.getHttp().getPaths()).head()).getPath())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String host = (String)tuple2._1();
                        String path = (String)tuple2._2();
                        String string = new StringBuilder(7).append("http://").append(host).append(path).toString();
                        return string;
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        ClusterClient x$4 = (ClusterClient)clusterClient.apply();
                        Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)client -> client.getWebInterfaceURL();
                        Null$ x$6 = Utils$.MODULE$.using$default$3((AutoCloseable)x$4, (Function1)x$5);
                        return (String)Utils$.MODULE$.using((AutoCloseable)x$4, (Function1)x$5, null);
                    });
                }
                return string;
            });
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new RuntimeException(new StringBuilder(42).append("[StreamPark] get ingressUrlAddress error: ").append(e).toString());
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            String string = value = (String)success.value();
            return string;
        };
        Null$ x$9 = Utils$.MODULE$.using$default$3((AutoCloseable)x$7, (Function1)x$8);
        return (String)Utils$.MODULE$.using((AutoCloseable)x$7, (Function1)x$8, null);
    }

    private int touchIngressBackendRestPort(DefaultKubernetesClient client, String clusterId, String nameSpace) {
        Buffer ports = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((Service)((Gettable)((Nameable)client.services().inNamespace(nameSpace)).withName(new StringBuilder(1).append(clusterId).append("-").append(this.REST_SERVICE_IDENTIFICATION()).toString())).get()).getSpec().getPorts()).asScala();
        ports = (Buffer)ports.filter((Function1 & Serializable & scala.Serializable)servicePort -> BoxesRunTime.boxToBoolean((boolean)IngressStrategyV1.$anonfun$touchIngressBackendRestPort$1(this, servicePort)));
        return Predef$.MODULE$.Integer2int((Integer)((IterableLike)ports.map((Function1 & Serializable & scala.Serializable)servicePort -> servicePort.getTargetPort().getIntVal(), Buffer$.MODULE$.canBuildFrom())).head());
    }

    @Override
    public void configureIngress(String domainName, String clusterId, String nameSpace) {
        DefaultKubernetesClient x$1 = new DefaultKubernetesClient();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> {
            OwnerReference ownerReference = this.getOwnerReference(nameSpace, clusterId, (DefaultKubernetesClient)client);
            int ingressBackendRestServicePort = this.touchIngressBackendRestPort((DefaultKubernetesClient)client, clusterId, nameSpace);
            Ingress ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((HTTPIngressRuleValueFluent)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressFluentImpl)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(clusterId).addToAnnotations((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.buildIngressAnnotations(clusterId, nameSpace)).asJava()).addToLabels((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.buildIngressLabels(clusterId)).asJava()).addToOwnerReferences(new OwnerReference[]{ownerReference})).endMetadata()).withNewSpec().withIngressClassName(this.ingressClass()).addNewRule().withHost(domainName).withNewHttp().addNewPath().withPath(new StringBuilder(3).append("/").append(nameSpace).append("/").append(clusterId).append("/").toString()).withPathType("ImplementationSpecific").withNewBackend().withNewService().withName(new StringBuilder(1).append(clusterId).append("-").append(this.REST_SERVICE_IDENTIFICATION()).toString()).withNewPort().withNumber(Predef$.MODULE$.int2Integer(ingressBackendRestServicePort))).endPort()).endService()).endBackend()).endPath()).addNewPath().withPath(new StringBuilder(11).append("/").append(nameSpace).append("/").append(clusterId).append("(/|$)(.*)").toString()).withPathType("ImplementationSpecific").withNewBackend().withNewService().withName(new StringBuilder(1).append(clusterId).append("-").append(this.REST_SERVICE_IDENTIFICATION()).toString()).withNewPort().withNumber(Predef$.MODULE$.int2Integer(ingressBackendRestServicePort))).endPort()).endService()).endBackend()).endPath()).endHttp()).endRule()).endSpec()).build();
            return (Ingress)((InOutCreateable)client.network().v1().ingresses().inNamespace(nameSpace)).create((Object)ingress);
        };
        Null$ x$3 = Utils$.MODULE$.using$default$3((AutoCloseable)x$1, (Function1)x$2);
        Utils$.MODULE$.using((AutoCloseable)x$1, (Function1)x$2, null);
    }

    public static final /* synthetic */ boolean $anonfun$touchIngressBackendRestPort$1(IngressStrategyV1 $this, ServicePort servicePort) {
        return servicePort.getName().equalsIgnoreCase($this.REST_SERVICE_IDENTIFICATION());
    }

    public IngressStrategyV1() {
        IngressStrategy.$init$(this);
    }
}

