/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.TypeComparable;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public class ReduceOperatorBase<T, FT extends ReduceFunction<T>>
extends SingleInputOperator<T, T, FT> {
    private CombineHint hint;
    private Partitioner<?> customPartitioner;

    public ReduceOperatorBase(UserCodeWrapper<FT> udf, UnaryOperatorInformation<T, T> operatorInfo, int[] keyPositions, String name) {
        super(udf, operatorInfo, keyPositions, name);
    }

    public ReduceOperatorBase(FT udf, UnaryOperatorInformation<T, T> operatorInfo, int[] keyPositions, String name) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, keyPositions, name);
    }

    public ReduceOperatorBase(Class<? extends FT> udf, UnaryOperatorInformation<T, T> operatorInfo, int[] keyPositions, String name) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, keyPositions, name);
    }

    public ReduceOperatorBase(UserCodeWrapper<FT> udf, UnaryOperatorInformation<T, T> operatorInfo, String name) {
        super(udf, operatorInfo, name);
    }

    public ReduceOperatorBase(FT udf, UnaryOperatorInformation<T, T> operatorInfo, String name) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, name);
    }

    public ReduceOperatorBase(Class<? extends FT> udf, UnaryOperatorInformation<T, T> operatorInfo, String name) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, name);
    }

    public void setCustomPartitioner(Partitioner<?> customPartitioner) {
        if (customPartitioner != null) {
            int[] keys = this.getKeyColumns(0);
            if (keys == null || keys.length == 0) {
                throw new IllegalArgumentException("Cannot use custom partitioner for a non-grouped GroupReduce (AllGroupReduce)");
            }
            if (keys.length > 1) {
                throw new IllegalArgumentException("Cannot use the key partitioner for composite keys (more than one key field)");
            }
        }
        this.customPartitioner = customPartitioner;
    }

    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    @Override
    protected List<T> executeOnCollections(List<T> inputData, RuntimeContext ctx, ExecutionConfig executionConfig) throws Exception {
        if (inputData.isEmpty()) {
            return Collections.emptyList();
        }
        ReduceFunction function = (ReduceFunction)this.userFunction.getUserCodeObject();
        OperatorInformation operatorInfo = this.getOperatorInfo();
        TypeInformation inputType = ((UnaryOperatorInformation)operatorInfo).getInputType();
        int[] inputColumns = this.getKeyColumns(0);
        if (!(inputType instanceof CompositeType) && inputColumns.length > 1) {
            throw new InvalidProgramException("Grouping is only possible on composite types.");
        }
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        FunctionUtils.openFunction(function, this.parameters);
        TypeSerializer serializer = ((UnaryOperatorInformation)this.getOperatorInfo()).getInputType().createSerializer(executionConfig);
        if (inputColumns.length > 0) {
            boolean[] inputOrderings = new boolean[inputColumns.length];
            TypeComparator inputComparator = inputType instanceof AtomicType ? ((AtomicType)((Object)inputType)).createComparator(false, executionConfig) : ((CompositeType)inputType).createComparator(inputColumns, inputOrderings, 0, executionConfig);
            HashMap<TypeComparable<T>, T> aggregateMap = new HashMap<TypeComparable<T>, T>(inputData.size() / 10);
            for (T next : inputData) {
                TypeComparable<T> wrapper = new TypeComparable<T>(next, inputComparator);
                Object existing = aggregateMap.get(wrapper);
                Object result = existing != null ? function.reduce(existing, serializer.copy(next)) : next;
                result = serializer.copy(result);
                aggregateMap.put(wrapper, result);
            }
            FunctionUtils.closeFunction(function);
            return new ArrayList(aggregateMap.values());
        }
        Object aggregate = inputData.get(0);
        aggregate = serializer.copy(aggregate);
        for (int i = 1; i < inputData.size(); ++i) {
            T next = function.reduce(aggregate, serializer.copy(inputData.get(i)));
            aggregate = serializer.copy(next);
        }
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        return Collections.singletonList(aggregate);
    }

    public void setCombineHint(CombineHint hint) {
        if (hint == null) {
            throw new IllegalArgumentException("Reduce Hint must not be null.");
        }
        this.hint = hint;
    }

    public CombineHint getCombineHint() {
        return this.hint;
    }

    public static enum CombineHint {
        OPTIMIZER_CHOOSES,
        SORT,
        HASH,
        NONE;

    }
}

