/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.handler;

import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.streampark.console.base.domain.ResponseCode;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.AbstractApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=-2147483648)
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={UnauthenticatedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public RestResponse handelUnauthenticatedException(UnauthenticatedException e) {
        log.info("Unauthenticated: {}", (Object)e.getMessage());
        return RestResponse.fail("Unauthenticated.", ResponseCode.CODE_UNAUTHORIZED);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public RestResponse handelUnauthenticatedException(AuthenticationException e) {
        log.info("Permission denied: {}", (Object)e.getMessage());
        return RestResponse.fail("Permission denied.", ResponseCode.CODE_UNAUTHORIZED);
    }

    @ExceptionHandler(value={AbstractApiException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResponse handleException(AbstractApiException e) {
        log.info("api exception\uff1a{}", (Object)e.getMessage());
        return RestResponse.fail(e.getMessage(), e.getResponseCode());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @Order(value=-2147483648)
    public RestResponse handleException(Exception e) {
        return RestResponse.fail("internal server error: " + e.getMessage(), ResponseCode.CODE_FAIL);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public RestResponse validExceptionHandler(BindException e) {
        StringBuilder message = new StringBuilder();
        List fieldErrors = e.getBindingResult().getFieldErrors();
        for (FieldError error : fieldErrors) {
            message.append(error.getField()).append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return RestResponse.fail(message.toString(), ResponseCode.CODE_FAIL);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public RestResponse handleConstraintViolationException(ConstraintViolationException e) {
        StringBuilder message = new StringBuilder();
        Set violations = e.getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            Path path = violation.getPropertyPath();
            String[] pathArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)path.toString(), (String)".");
            message.append(pathArr[1]).append(violation.getMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return RestResponse.fail(message.toString(), ResponseCode.CODE_FAIL);
    }
}

