/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.operators.util.OperatorValidationUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.streaming.api.transformations.SourceTransformation;

@Public
public class DataStreamSource<T>
extends SingleOutputStreamOperator<T> {
    private final boolean isParallel;

    public DataStreamSource(StreamExecutionEnvironment environment, TypeInformation<T> outTypeInfo, StreamSource<T, ?> operator, boolean isParallel, String sourceName) {
        this(environment, outTypeInfo, operator, isParallel, sourceName, Boundedness.CONTINUOUS_UNBOUNDED);
    }

    public DataStreamSource(StreamExecutionEnvironment environment, TypeInformation<T> outTypeInfo, StreamSource<T, ?> operator, boolean isParallel, String sourceName, Boundedness boundedness) {
        super(environment, new LegacySourceTransformation<T>(sourceName, operator, outTypeInfo, environment.getParallelism(), boundedness));
        this.isParallel = isParallel;
        if (!isParallel) {
            this.setParallelism(1);
        }
    }

    public DataStreamSource(SingleOutputStreamOperator<T> operator) {
        super(operator.environment, operator.getTransformation());
        this.isParallel = true;
    }

    public DataStreamSource(StreamExecutionEnvironment environment, Source<T, ?, ?> source, WatermarkStrategy<T> watermarkStrategy, TypeInformation<T> outTypeInfo, String sourceName) {
        super(environment, new SourceTransformation(sourceName, source, watermarkStrategy, outTypeInfo, environment.getParallelism()));
        this.isParallel = true;
    }

    @VisibleForTesting
    boolean isParallel() {
        return this.isParallel;
    }

    @Override
    public DataStreamSource<T> setParallelism(int parallelism) {
        OperatorValidationUtils.validateParallelism((int)parallelism, (boolean)this.isParallel);
        super.setParallelism(parallelism);
        return this;
    }
}

