/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.streampark.console.core.entity.Setting;

public class SettingDockerConfigParams {
    private Setting username;
    private Setting password;
    private Setting address;
    private Setting namespace;
    private static final String USER_NAME_REGEXP = "^[a-zA-Z][a-zA-Z0-9_]{4,15}$";
    private static final String PASSWORD_REGEXP = "^[a-zA-Z][a-zA-Z0-9_]{4,15}$";
    private static final String IPV4_ADDRESS_REGEX = "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private static final String IPV6_ADDRESS_REGEX = "^([0-9a-fA-F]{1,4}:){7}([0-9a-fA-F]{1,4}|:)$";
    private static final String DOMAIN_NAME_REGEX = "^((http://)|(https://))?([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}(\\/)";
    private static final String NAMESPACE_REGEX = "^(?!-)[a-zA-Z0-9-]{1,253}(?<!-)$";

    public static boolean verifyParams(SettingDockerConfigParams params) {
        return params.verifyUserName() && params.verifyPassWord() && params.verifyAddress() && params.verifyNameSpace();
    }

    private boolean verifyUserName() {
        if (Objects.isNull(this.getUsername()) || Objects.isNull(this.getUsername().getSettingValue())) {
            return false;
        }
        return Pattern.matches("^[a-zA-Z][a-zA-Z0-9_]{4,15}$", this.getUsername().getSettingValue());
    }

    private boolean verifyPassWord() {
        if (Objects.isNull(this.getPassword()) || Objects.isNull(this.getPassword().getSettingValue())) {
            return false;
        }
        return Pattern.matches("^[a-zA-Z][a-zA-Z0-9_]{4,15}$", this.getPassword().getSettingValue());
    }

    private boolean verifyAddress() {
        if (Objects.isNull(this.getAddress()) || Objects.isNull(this.getAddress().getSettingValue())) {
            return false;
        }
        return Pattern.matches(IPV4_ADDRESS_REGEX, this.getAddress().getSettingValue()) || Pattern.matches(IPV6_ADDRESS_REGEX, this.getAddress().getSettingValue()) || Pattern.matches(DOMAIN_NAME_REGEX, this.getAddress().getSettingValue());
    }

    private boolean verifyNameSpace() {
        if (Objects.isNull(this.getNamespace()) || Objects.isNull(this.getNamespace().getSettingValue())) {
            return false;
        }
        return Pattern.matches(NAMESPACE_REGEX, this.getNamespace().getSettingValue());
    }

    public Setting getUsername() {
        return this.username;
    }

    public Setting getPassword() {
        return this.password;
    }

    public Setting getAddress() {
        return this.address;
    }

    public Setting getNamespace() {
        return this.namespace;
    }

    public void setUsername(Setting username) {
        this.username = username;
    }

    public void setPassword(Setting password) {
        this.password = password;
    }

    public void setAddress(Setting address) {
        this.address = address;
    }

    public void setNamespace(Setting namespace) {
        this.namespace = namespace;
    }
}

