/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.util;

import java.io.File;
import java.time.Duration;
import java.util.Map;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.util.TimeUtils;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class FlinkUtils$ {
    public static FlinkUtils$ MODULE$;

    static {
        new FlinkUtils$();
    }

    public <R> ListState<R> getUnionListState(FunctionInitializationContext context, String descriptorName, TypeInformation<R> evidence$1) {
        return context.getOperatorStateStore().getUnionListState(new ListStateDescriptor(descriptorName, ((TypeInformation)Predef$.MODULE$.implicitly(evidence$1)).getTypeClass()));
    }

    public String getFlinkDistJar(String flinkHome) {
        String[] stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(new StringBuilder(4).append(flinkHome).append("/lib").toString()).list())).filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matches("flink-dist.*\\.jar")));
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            throw new IllegalArgumentException(new StringBuilder(48).append("[StreamPark] can no found flink-dist jar in ").append(flinkHome).append("/lib").toString());
        }
        if (stringArray.length != 1) {
            throw new IllegalArgumentException(new StringBuilder(53).append("[StreamPark] found multiple flink-dist jar in ").append(flinkHome).append("/lib,[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).mkString(",")).append("]").toString());
        }
        String string = new StringBuilder(5).append(flinkHome).append("/lib/").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).head()).toString();
        return string;
    }

    public boolean isCheckpointEnabled(Map<String, String> map) {
        Duration checkpointInterval = TimeUtils.parseDuration((String)map.getOrDefault(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL.key(), "0ms"));
        return checkpointInterval.toMillis() > 0L;
    }

    private FlinkUtils$() {
        MODULE$ = this;
    }
}

