/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.handler;

import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.streampark.console.base.domain.ResponseCode;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.AbstractApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=-2147483648)
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResponse handleException(Exception e) {
        log.info("Internal server error\uff1a", (Throwable)e);
        return RestResponse.fail("internal server error: " + e.getMessage(), ResponseCode.CODE_FAIL);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResponse handleException(HttpRequestMethodNotSupportedException e) {
        log.info("not supported request method\uff0cexception\uff1a{}", (Object)e.getMessage());
        return RestResponse.fail("not supported request method\uff0cexception\uff1a" + e.getMessage(), ResponseCode.CODE_FAIL);
    }

    @ExceptionHandler(value={AbstractApiException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResponse handleException(AbstractApiException e) {
        log.info("api exception\uff1a{}", (Object)e.getMessage());
        return RestResponse.fail(e.getMessage(), e.getResponseCode());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public RestResponse validExceptionHandler(BindException e) {
        StringBuilder message = new StringBuilder();
        List fieldErrors = e.getBindingResult().getFieldErrors();
        for (FieldError error : fieldErrors) {
            message.append(error.getField()).append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return RestResponse.fail(message.toString(), ResponseCode.CODE_FAIL);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public RestResponse handleConstraintViolationException(ConstraintViolationException e) {
        StringBuilder message = new StringBuilder();
        Set violations = e.getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            Path path = violation.getPropertyPath();
            String[] pathArr = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)path.toString(), (String)".");
            message.append(pathArr[1]).append(violation.getMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return RestResponse.fail(message.toString(), ResponseCode.CODE_FAIL);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public void handleUnauthorizedException(Exception e) {
        log.info("Permission denied\uff0c{}", (Object)e.getMessage());
    }
}

