/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Logger$class;
import org.apache.streampark.common.util.Utils$;
import org.yaml.snakeyaml.Yaml;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PropertiesUtils$
implements Logger {
    public static final PropertiesUtils$ MODULE$;
    private Pattern org$apache$streampark$common$util$PropertiesUtils$$PROPERTY_PATTERN;
    private String MULTI_PROPERTY_REGEXP;
    private Pattern MULTI_PROPERTY_PATTERN;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new PropertiesUtils$();
    }

    private Pattern org$apache$streampark$common$util$PropertiesUtils$$PROPERTY_PATTERN$lzycompute() {
        PropertiesUtils$ propertiesUtils$ = this;
        synchronized (propertiesUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$streampark$common$util$PropertiesUtils$$PROPERTY_PATTERN = Pattern.compile("(.*?)=(.*?)");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$apache$streampark$common$util$PropertiesUtils$$PROPERTY_PATTERN;
        }
    }

    private String MULTI_PROPERTY_REGEXP$lzycompute() {
        PropertiesUtils$ propertiesUtils$ = this;
        synchronized (propertiesUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.MULTI_PROPERTY_REGEXP = "-D(.*?)\\s*=\\s*[\\\"|'](.*)[\\\"|']";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.MULTI_PROPERTY_REGEXP;
        }
    }

    private Pattern MULTI_PROPERTY_PATTERN$lzycompute() {
        PropertiesUtils$ propertiesUtils$ = this;
        synchronized (propertiesUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.MULTI_PROPERTY_PATTERN = Pattern.compile(this.MULTI_PROPERTY_REGEXP());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.MULTI_PROPERTY_PATTERN;
        }
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger$class.isTraceEnabled(this);
    }

    public Pattern org$apache$streampark$common$util$PropertiesUtils$$PROPERTY_PATTERN() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$apache$streampark$common$util$PropertiesUtils$$PROPERTY_PATTERN$lzycompute() : this.org$apache$streampark$common$util$PropertiesUtils$$PROPERTY_PATTERN;
    }

    private String MULTI_PROPERTY_REGEXP() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.MULTI_PROPERTY_REGEXP$lzycompute() : this.MULTI_PROPERTY_REGEXP;
    }

    private Pattern MULTI_PROPERTY_PATTERN() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.MULTI_PROPERTY_PATTERN$lzycompute() : this.MULTI_PROPERTY_PATTERN;
    }

    public String readFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] readFile: file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] readFile: file ", " is not a normal file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        Scanner scanner = new Scanner(file);
        StringBuilder buffer = new StringBuilder();
        while (scanner.hasNextLine()) {
            buffer.append(scanner.nextLine()).append("\r\n");
        }
        scanner.close();
        return buffer.toString();
    }

    public scala.collection.immutable.Map<String, String> org$apache$streampark$common$util$PropertiesUtils$$eachAppendYamlItem(String prefix, String k, Object v, scala.collection.mutable.Map<String, String> proper) {
        scala.collection.immutable.Map map;
        Object object = v;
        if (object instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            map = ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap((Map)linkedHashMap).flatMap((Function1)new Serializable(prefix, k, proper){
                public static final long serialVersionUID = 0L;
                private final String prefix$1;
                private final String k$1;
                private final scala.collection.mutable.Map proper$1;

                public final scala.collection.immutable.Map<String, String> apply(Tuple2<String, Object> x) {
                    String string = this.prefix$1;
                    scala.collection.immutable.Map<String, String> map = "".equals(string) ? PropertiesUtils$.MODULE$.org$apache$streampark$common$util$PropertiesUtils$$eachAppendYamlItem(this.k$1, (String)x._1(), x._2(), (scala.collection.mutable.Map<String, String>)this.proper$1) : PropertiesUtils$.MODULE$.org$apache$streampark$common$util$PropertiesUtils$$eachAppendYamlItem(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, this.k$1})), (String)x._1(), x._2(), (scala.collection.mutable.Map<String, String>)this.proper$1);
                    return map;
                }
                {
                    this.prefix$1 = prefix$1;
                    this.k$1 = k$1;
                    this.proper$1 = proper$1;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            Object object2 = object;
            String string = object2 == null ? "" : object2.toString();
            String value = string;
            String string2 = prefix;
            scala.collection.mutable.Map map2 = "".equals(string2) ? (scala.collection.mutable.Map)proper.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)value)) : (scala.collection.mutable.Map)proper.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2, k}))), (Object)value));
            map = proper.toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public scala.collection.immutable.Map<String, String> fromYamlText(String text) {
        try {
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            return ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap((Map)new Yaml().load(text)).flatMap((Function1)new Serializable(map){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Map map$1;

                public final scala.collection.immutable.Map<String, String> apply(Tuple2<String, scala.collection.immutable.Map<String, Object>> x) {
                    return PropertiesUtils$.MODULE$.org$apache$streampark$common$util$PropertiesUtils$$eachAppendYamlItem("", (String)x._1(), x._2(), (scala.collection.mutable.Map<String, String>)this.map$1);
                }
                {
                    this.map$1 = map$1;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading conf error:"})).s((Seq)Nil$.MODULE$), iOException);
        }
    }

    public scala.collection.immutable.Map<String, String> fromHoconText(String conf) {
        Predef$.MODULE$.require(conf != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromHoconText: Hocon content must not be null"})).s((Seq)Nil$.MODULE$);
            }
        });
        try {
            return this.parseHoconByReader(new StringReader(conf));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading Hocon "})).s((Seq)Nil$.MODULE$), iOException);
        }
    }

    public scala.collection.immutable.Map<String, String> fromPropertiesText(String conf) {
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(conf));
            return ((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(properties.stringPropertyNames()).map((Function1)new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final Properties properties$1;

                public final Tuple2<String, String> apply(String k) {
                    return new Tuple2((Object)k, (Object)this.properties$1.getProperty(k).trim());
                }
                {
                    this.properties$1 = properties$1;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading properties "})).s((Seq)Nil$.MODULE$), iOException);
        }
    }

    public scala.collection.immutable.Map<String, String> fromYamlFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromYamlFile: Yaml file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
            }
            {
                this.file$2 = file$2;
            }
        });
        Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromYamlFile: Yaml file ", " is not a normal file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
            }
            {
                this.file$2 = file$2;
            }
        });
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromYamlFile(inputStream);
    }

    public scala.collection.immutable.Map<String, String> fromHoconFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromHoconFile: file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3}));
            }
            {
                this.file$3 = file$3;
            }
        });
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromHoconFile(inputStream);
    }

    public scala.collection.immutable.Map<String, String> fromPropertiesFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromPropertiesFile: Properties file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$4}));
            }
            {
                this.file$4 = file$4;
            }
        });
        Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromPropertiesFile: Properties file ", " is not a normal file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$4}));
            }
            {
                this.file$4 = file$4;
            }
        });
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromPropertiesFile(inputStream);
    }

    public scala.collection.immutable.Map<String, String> fromYamlFile(InputStream inputStream) {
        Predef$.MODULE$.require(inputStream != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromYamlFile: Properties inputStream  must not be null"})).s((Seq)Nil$.MODULE$);
            }
        });
        try {
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            return ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap((Map)new Yaml().load(inputStream)).flatMap((Function1)new Serializable(map){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Map map$2;

                public final scala.collection.immutable.Map<String, String> apply(Tuple2<String, scala.collection.immutable.Map<String, Object>> x) {
                    return PropertiesUtils$.MODULE$.org$apache$streampark$common$util$PropertiesUtils$$eachAppendYamlItem("", (String)x._1(), x._2(), (scala.collection.mutable.Map<String, String>)this.map$2);
                }
                {
                    this.map$2 = map$2;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading yaml from inputStream"})).s((Seq)Nil$.MODULE$), iOException);
        }
        finally {
            inputStream.close();
        }
    }

    public scala.collection.immutable.Map<String, String> fromHoconFile(InputStream inputStream) {
        Predef$.MODULE$.require(inputStream != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromHoconFile: Hocon inputStream  must not be null"})).s((Seq)Nil$.MODULE$);
            }
        });
        try {
            return this.parseHoconByReader(new InputStreamReader(inputStream));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading Hocon "})).s((Seq)Nil$.MODULE$), iOException);
        }
    }

    private scala.collection.immutable.Map<String, String> parseHoconByReader(Reader reader) {
        try {
            return ((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(ConfigFactory.parseReader((Reader)reader).entrySet()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Map.Entry<String, ConfigValue> x) {
                    String k = x.getKey().trim().replaceAll("\"", "");
                    String v = x.getValue().unwrapped().toString().trim();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading Hocon "})).s((Seq)Nil$.MODULE$), iOException);
        }
    }

    public scala.collection.immutable.Map<String, String> fromPropertiesFile(InputStream inputStream) {
        Predef$.MODULE$.require(inputStream != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] fromPropertiesFile: Properties inputStream  must not be null"})).s((Seq)Nil$.MODULE$);
            }
        });
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            return ((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(properties.stringPropertyNames()).map((Function1)new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final Properties properties$2;

                public final Tuple2<String, String> apply(String k) {
                    return new Tuple2((Object)k, (Object)this.properties$2.getProperty(k).trim());
                }
                {
                    this.properties$2 = properties$2;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] Failed when loading properties from inputStream"})).s((Seq)Nil$.MODULE$), iOException);
        }
    }

    public HashMap<String, String> fromYamlTextAsJava(String text) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlText(text)).asJava());
    }

    public HashMap<String, String> fromHoconTextAsJava(String text) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconText(text)).asJava());
    }

    public HashMap<String, String> fromPropertiesTextAsJava(String text) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesText(text)).asJava());
    }

    public HashMap<String, String> fromYamlFileAsJava(String filename) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlFile(filename)).asJava());
    }

    public HashMap<String, String> fromHoconFileAsJava(String filename) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconFile(filename)).asJava());
    }

    public HashMap<String, String> fromPropertiesFileAsJava(String filename) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesFile(filename)).asJava());
    }

    public HashMap<String, String> fromYamlFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlFile(inputStream)).asJava());
    }

    public HashMap<String, String> fromHoconFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconFile(inputStream)).asJava());
    }

    public HashMap<String, String> fromPropertiesFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesFile(inputStream)).asJava());
    }

    public HashMap<String, String> loadFlinkConfYaml(File file) {
        Predef$.MODULE$.require(file != null && file.exists() && file.isFile(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "[StreamPark] loadFlinkConfYaml: file must not be null";
            }
        });
        return this.loadFlinkConfYaml(FileUtils.readFileToString((File)file));
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, String> loadFlinkConfYaml(String yaml) {
        void var2_2;
        Predef$.MODULE$.require(yaml != null && new StringOps(Predef$.MODULE$.augmentString(yaml)).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "[StreamPark] loadFlinkConfYaml: yaml must not be null";
            }
        });
        HashMap flinkConf = new HashMap();
        Scanner scanner = new Scanner(yaml);
        AtomicInteger lineNo = new AtomicInteger(0);
        while (scanner.hasNextLine()) {
            BoxedUnit boxedUnit;
            String line = scanner.nextLine();
            lineNo.incrementAndGet();
            String[] comments = line.split("^#|\\s+#", 2);
            String conf = comments[0].trim();
            if (new StringOps(Predef$.MODULE$.augmentString(conf)).nonEmpty()) {
                String[] kv = conf.split(": ", 2);
                if (kv.length == 2) {
                    String key = kv[0].trim();
                    String value = kv[1].trim();
                    if (new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(value)).nonEmpty()) {
                        boxedUnit = JavaConversions$.MODULE$.mapAsScalaMap(flinkConf).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
                        continue;
                    }
                    this.logWarn((Function0<String>)new Serializable(lineNo, line){
                        public static final long serialVersionUID = 0L;
                        private final AtomicInteger lineNo$1;
                        private final String line$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error after splitting key and value in configuration ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lineNo$1.get()), this.line$1}));
                        }
                        {
                            this.lineNo$1 = lineNo$1;
                            this.line$1 = line$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                this.logWarn((Function0<String>)new Serializable(lineNo, line){
                    public static final long serialVersionUID = 0L;
                    private final AtomicInteger lineNo$1;
                    private final String line$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while trying to split key and value in configuration. ", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lineNo$1, this.line$1}));
                    }
                    {
                        this.lineNo$1 = lineNo$1;
                        this.line$1 = line$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    @Nonnull
    public scala.collection.immutable.Map<String, String> extractDynamicProperties(String properties) {
        scala.collection.immutable.Map map;
        if (StringUtils.isEmpty((CharSequence)properties)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            BoxedUnit boxedUnit;
            scala.collection.mutable.Map map2 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            String simple = properties.replaceAll(this.MULTI_PROPERTY_REGEXP(), "");
            String[] stringArray = simple.split("\\s?-D");
            if (Utils$.MODULE$.notEmpty(stringArray)) {
                Predef$.MODULE$.refArrayOps((Object[])stringArray).foreach((Function1)new Serializable(map2){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Map map$3;

                    public final Object apply(String x) {
                        Matcher p;
                        return new StringOps(Predef$.MODULE$.augmentString(x)).nonEmpty() ? ((p = PropertiesUtils$.MODULE$.org$apache$streampark$common$util$PropertiesUtils$$PROPERTY_PATTERN().matcher(x.trim())).matches() ? this.map$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.group(1).trim()), (Object)p.group(2).trim())) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
                    }
                    {
                        this.map$3 = map$3;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Matcher matcher = this.MULTI_PROPERTY_PATTERN().matcher(properties);
            while (matcher.find()) {
                String opts = matcher.group();
                int index = opts.indexOf("=");
                String key = opts.substring(2, index).trim();
                String value = opts.substring(index + 1).trim().replaceAll("(^[\"|']|[\"|']$)", "");
                map2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
            }
            map = map2.toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    @Nonnull
    public HashMap<String, String> extractDynamicPropertiesAsJava(String properties) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.extractDynamicProperties(properties)).asJava());
    }

    private PropertiesUtils$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

