/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.ingress;

import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.flink.kubernetes.ingress.IngressStrategy;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class IngressStrategy$class {
    public static String prepareIngressTemplateFiles(IngressStrategy $this, String buildWorkspace, String ingressTemplates) {
        String string;
        File workspaceDir = new File(buildWorkspace);
        Object object = workspaceDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)workspaceDir.mkdir());
        if (ingressTemplates.isEmpty()) {
            string = null;
        } else {
            String outputPath = new StringBuilder().append((Object)buildWorkspace).append((Object)"/ingress.yaml").toString();
            File outputFile = new File(outputPath);
            FileUtils.write((File)outputFile, (CharSequence)ingressTemplates, (String)"UTF-8");
            string = outputPath;
        }
        return string;
    }

    public static Map buildIngressAnnotations(IngressStrategy $this, String clusterId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/rewrite-target"), (Object)"/$2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/proxy-body-size"), (Object)"1024m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/configuration-snippet"), (Object)new StringBuilder().append((Object)"rewrite ^(/").append((Object)clusterId).append((Object)")$ $1/ permanent;").toString())}));
    }

    public static Map buildIngressLabels(IngressStrategy $this, String clusterId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)clusterId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"flink-native-kubernetes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"ingress")}));
    }

    public static OwnerReference getOwnerReference(IngressStrategy $this, String nameSpace, String clusterId, DefaultKubernetesClient client) {
        Deployment deployment = (Deployment)((Gettable)((Nameable)client.apps().deployments().inNamespace(nameSpace)).withName(clusterId)).get();
        Predef$.MODULE$.require(deployment != null, (Function0)new Serializable($this, nameSpace, clusterId){
            public static final long serialVersionUID = 0L;
            private final String nameSpace$1;
            private final String clusterId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deployment with name ", " not found in namespace ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterId$1, this.nameSpace$1}));
            }
            {
                this.nameSpace$1 = nameSpace$1;
                this.clusterId$1 = clusterId$1;
            }
        });
        return ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withUid(deployment.getMetadata().getUid())).withApiVersion("apps/v1")).withKind("Deployment")).withName(clusterId)).withController(Predef$.MODULE$.boolean2Boolean(true))).withBlockOwnerDeletion(Predef$.MODULE$.boolean2Boolean(true))).build();
    }

    public static void $init$(IngressStrategy $this) {
    }
}

