/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class IntMaximum
implements SimpleAccumulator<Integer> {
    private static final long serialVersionUID = 1L;
    private int max = Integer.MIN_VALUE;

    public IntMaximum() {
    }

    public IntMaximum(int value) {
        this.max = value;
    }

    @Override
    public void add(Integer value) {
        this.max = Math.max(this.max, value);
    }

    @Override
    public Integer getLocalValue() {
        return this.max;
    }

    @Override
    public void merge(Accumulator<Integer, Integer> other) {
        this.max = Math.max(this.max, other.getLocalValue());
    }

    @Override
    public void resetLocal() {
        this.max = Integer.MIN_VALUE;
    }

    public IntMaximum clone() {
        IntMaximum clone = new IntMaximum();
        clone.max = this.max;
        return clone;
    }

    @Override
    public void add(int value) {
        this.max = Math.max(this.max, value);
    }

    public int getLocalValuePrimitive() {
        return this.max;
    }

    public String toString() {
        return "IntMaximum " + this.max;
    }
}

