/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.storm.Config;
import org.apache.storm.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopLoginUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopLoginUtil.class);
    private static Subject loginSubject = null;
    private static boolean firstTimeLogin = true;
    private static final String HADOOP_USER_GROUP_INFORMATION_CLASS = "org.apache.hadoop.security.UserGroupInformation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subject loginHadoop(Map<String, Object> conf) {
        if (firstTimeLogin) {
            Class<HadoopLoginUtil> clazz = HadoopLoginUtil.class;
            synchronized (HadoopLoginUtil.class) {
                if (firstTimeLogin) {
                    String principal;
                    try {
                        principal = Config.getHdfsPrincipal(conf);
                    }
                    catch (UnknownHostException e) {
                        throw new IllegalArgumentException("Failed to get principal", e);
                    }
                    String keyTab = Config.getHdfsKeytab(conf);
                    if (principal != null && keyTab != null) {
                        HadoopLoginUtil.loginFromKeytab(principal, keyTab);
                    } else {
                        if (principal == null && keyTab != null) {
                            throw new IllegalArgumentException("HDFS principal is null while keytab is present");
                        }
                        if (principal != null && keyTab == null) {
                            throw new IllegalArgumentException("HDFS keytab is null while principal is present");
                        }
                    }
                    loginSubject = HadoopLoginUtil.getHadoopUser();
                    firstTimeLogin = false;
                } else {
                    LOG.debug("Already logged in to Hadoop");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        LOG.debug("Already logged in to Hadoop");
        {
            LOG.debug("The subject is: {}", (Object)loginSubject);
            return loginSubject;
        }
    }

    private static void loginFromKeytab(String principal, String keyTab) {
        Class<?> ugi;
        Preconditions.checkNotNull((Object)principal);
        Preconditions.checkNotNull((Object)keyTab);
        try {
            ugi = Class.forName(HADOOP_USER_GROUP_INFORMATION_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Hadoop is not in the classpath", e);
        }
        try {
            Method login = ugi.getMethod("loginUserFromKeytab", String.class, String.class);
            login.invoke(null, principal, keyTab);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to login hadoop user from Keytab!", e);
        }
        LOG.info("Successfully login to Hadoop using keytab as {}", (Object)principal);
    }

    private static Subject getHadoopUser() {
        Class<?> ugiClass;
        try {
            ugiClass = Class.forName(HADOOP_USER_GROUP_INFORMATION_CLASS);
        }
        catch (ClassNotFoundException e) {
            LOG.info("Hadoop was not found on the class path", (Throwable)e);
            return null;
        }
        try {
            Method currentUserMethod = ugiClass.getMethod("getCurrentUser", new Class[0]);
            Method doAsMethod = ugiClass.getMethod("doAs", PrivilegedAction.class);
            Object ugi = currentUserMethod.invoke(null, new Object[0]);
            return (Subject)doAsMethod.invoke(ugi, () -> Subject.getSubject(AccessController.getContext()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting hadoop user!", e);
        }
    }
}

