/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import org.apache.spark.QueryContext;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkNumberFormatException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.util.QuotingUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class DataTypeErrors$
implements DataTypeErrorsBase {
    public static final DataTypeErrors$ MODULE$ = new DataTypeErrors$();

    static {
        DataTypeErrorsBase.$init$(MODULE$);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$(this, elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$(this, context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$(this, option);
    }

    public SparkUnsupportedOperationException unsupportedOperationExceptionError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2225");
    }

    public SparkArithmeticException decimalPrecisionExceedsMaxPrecisionError(int precision, int maxPrecision) {
        return new SparkArithmeticException("DECIMAL_PRECISION_EXCEEDS_MAX_PRECISION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)Integer.toString(precision)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxPrecision"), (Object)Integer.toString(maxPrecision))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkException unsupportedRoundingMode(Enumeration.Value roundMode) {
        return SparkException$.MODULE$.internalError("Not supported rounding mode: " + roundMode.toString() + ".");
    }

    public SparkArithmeticException outOfDecimalTypeRangeError(UTF8String str) {
        return new SparkArithmeticException("NUMERIC_OUT_OF_SUPPORTED_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)str.toString())})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkRuntimeException unsupportedJavaTypeError(Class<?> clazz) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2121", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)clazz.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException nullLiteralsCannotBeCastedError(String name) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2226", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)})));
    }

    public Throwable notUserDefinedTypeError(String name, String userClass) {
        return new SparkException("_LEGACY_ERROR_TEMP_2227", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"userClass"), (Object)userClass)})), null);
    }

    public Throwable cannotLoadUserDefinedTypeError(String name, String userClass) {
        return new SparkException("_LEGACY_ERROR_TEMP_2228", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"userClass"), (Object)userClass)})), null);
    }

    public SparkRuntimeException unsupportedArrayTypeError(Class<?> clazz) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2120", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)clazz.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable schemaFailToParseError(String schema, Throwable e) {
        return new AnalysisException("INVALID_SCHEMA.PARSE_ERROR", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSchema"), (Object)QuotingUtils$.MODULE$.toSQLSchema(schema)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)e.getMessage())}))), (Option<Throwable>)new Some((Object)e));
    }

    public Throwable invalidDayTimeIntervalType(String startFieldName, String endFieldName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1224", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startFieldName"), (Object)startFieldName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endFieldName"), (Object)endFieldName)}))));
    }

    public Throwable invalidDayTimeField(byte field, Seq<String> supportedIds) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1223", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)Byte.toString(field)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"supportedIds"), (Object)supportedIds.mkString(", "))}))));
    }

    public Throwable invalidYearMonthField(byte field, Seq<String> supportedIds) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1225", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)Byte.toString(field)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"supportedIds"), (Object)supportedIds.mkString(", "))}))));
    }

    public Throwable decimalCannotGreaterThanPrecisionError(int scale, int precision) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1228", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)Integer.toString(scale)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)Integer.toString(precision))}))));
    }

    public Throwable negativeScaleNotAllowedError(int scale) {
        String sqlConf = QuotingUtils$.MODULE$.toSQLConf("spark.sql.legacy.allowNegativeScaleOfDecimal");
        return new AnalysisException("NEGATIVE_SCALE_DISALLOWED", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)this.toSQLValue(scale)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlConf"), (Object)sqlConf)}))));
    }

    public Throwable attributeNameSyntaxError(String name) {
        return new AnalysisException("INVALID_ATTRIBUTE_NAME_SYNTAX", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)}))));
    }

    public Throwable cannotMergeIncompatibleDataTypesError(DataType left, DataType right) {
        return new SparkException("CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)this.toSQLType(left)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)this.toSQLType(right))})), null);
    }

    public Throwable cannotMergeDecimalTypesWithIncompatibleScaleError(int leftScale, int rightScale) {
        return new SparkException("_LEGACY_ERROR_TEMP_2124", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftScale"), (Object)Integer.toString(leftScale)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightScale"), (Object)Integer.toString(rightScale))})), null);
    }

    public Throwable dataTypeUnsupportedError(String dataType, String failure) {
        return new SparkIllegalArgumentException("UNSUPPORTED_DATATYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)(dataType + failure))})));
    }

    public Throwable invalidFieldName(Seq<String> fieldName, Seq<String> path, Origin context) {
        return new AnalysisException("INVALID_FIELD_NAME", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)this.toSQLId(fieldName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.toSQLId(path))}))), context);
    }

    public ArithmeticException unscaledValueTooLargeForPrecisionError(Decimal value, int decimalPrecision, int decimalScale, QueryContext context) {
        return this.numericValueOutOfRange(value, decimalPrecision, decimalScale, context);
    }

    public QueryContext unscaledValueTooLargeForPrecisionError$default$4() {
        return null;
    }

    public ArithmeticException cannotChangeDecimalPrecisionError(Decimal value, int decimalPrecision, int decimalScale, QueryContext context) {
        return this.numericValueOutOfRange(value, decimalPrecision, decimalScale, context);
    }

    public QueryContext cannotChangeDecimalPrecisionError$default$4() {
        return null;
    }

    private ArithmeticException numericValueOutOfRange(Decimal value, int decimalPrecision, int decimalScale, QueryContext context) {
        return new SparkArithmeticException("NUMERIC_VALUE_OUT_OF_RANGE.WITH_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value.toPlainString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)Integer.toString(decimalPrecision)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)Integer.toString(decimalScale)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf("spark.sql.ansi.enabled"))})), this.getQueryContext(context), this.getSummary(context));
    }

    public SparkNumberFormatException invalidInputInCastToNumberError(DataType to, UTF8String s, QueryContext context) {
        String convertedValueStr = "'" + s.toString().replace("\\", "\\\\").replace("'", "\\'") + "'";
        return new SparkNumberFormatException("CAST_INVALID_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)convertedValueStr), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)this.toSQLType(StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(to)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf("spark.sql.ansi.enabled"))})), this.getQueryContext(context), this.getSummary(context));
    }

    public Throwable ambiguousColumnOrFieldError(Seq<String> name, int numMatches, Origin context) {
        return new AnalysisException("AMBIGUOUS_COLUMN_OR_FIELD", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)Integer.toString(numMatches))}))), context);
    }

    public ArithmeticException castingCauseOverflowError(String t, DataType from, DataType to) {
        return new SparkArithmeticException("CAST_OVERFLOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)t), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)this.toSQLType(from)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(to)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf("spark.sql.ansi.enabled"))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkRuntimeException failedParsingStructTypeError(String raw) {
        return new SparkRuntimeException("FAILED_PARSE_STRUCT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"raw"), (Object)("'" + raw + "'"))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException fieldIndexOnRowWithoutSchemaError(String fieldName) {
        return new SparkUnsupportedOperationException("UNSUPPORTED_CALL.FIELD_INDEX", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"methodName"), (Object)"fieldIndex"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)"Row"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)this.toSQLId(fieldName))})));
    }

    public Throwable valueIsNullError(int index) {
        return new SparkRuntimeException("ROW_VALUE_IS_NULL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)Integer.toString(index))})), null, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable charOrVarcharTypeAsStringUnsupportedError() {
        return new AnalysisException("UNSUPPORTED_CHAR_OR_VARCHAR_AS_STRING", (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Throwable userSpecifiedSchemaUnsupportedError(String operation) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1189", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation)}))));
    }

    private DataTypeErrors$() {
    }
}

