/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.io.Serializable;
import java.util.Date;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetrics;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class AppStatusUtils$ {
    public static final AppStatusUtils$ MODULE$ = new AppStatusUtils$();
    private static final Set<String> TASK_FINISHED_STATES = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED", "KILLED", "SUCCESS"}));

    private Set<String> TASK_FINISHED_STATES() {
        return TASK_FINISHED_STATES;
    }

    private boolean isTaskFinished(TaskData task) {
        return this.TASK_FINISHED_STATES().contains((Object)task.status());
    }

    public long schedulerDelay(TaskData task) {
        if (this.isTaskFinished(task) && task.taskMetrics().isDefined() && task.duration().isDefined()) {
            TaskMetrics m = (TaskMetrics)task.taskMetrics().get();
            return this.schedulerDelay(task.launchTime().getTime(), this.fetchStart(task), BoxesRunTime.unboxToLong((Object)task.duration().get()), m.executorDeserializeTime(), m.resultSerializationTime(), m.executorRunTime());
        }
        return 0L;
    }

    public long gettingResultTime(TaskData task) {
        return this.gettingResultTime(task.launchTime().getTime(), this.fetchStart(task), BoxesRunTime.unboxToLong((Object)task.duration().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    public long schedulerDelay(long launchTime, long fetchStart, long duration, long deserializeTime, long serializeTime, long runTime) {
        return package$.MODULE$.max(0L, duration - runTime - deserializeTime - serializeTime - this.gettingResultTime(launchTime, fetchStart, duration));
    }

    public long gettingResultTime(long launchTime, long fetchStart, long duration) {
        if (fetchStart > 0L) {
            if (duration > 0L) {
                return launchTime + duration - fetchStart;
            }
            return System.currentTimeMillis() - fetchStart;
        }
        return 0L;
    }

    private long fetchStart(TaskData task) {
        if (task.resultFetchStart().isDefined()) {
            return ((Date)task.resultFetchStart().get()).getTime();
        }
        return -1L;
    }

    public IndexedSeq<Object> getQuantilesValue(IndexedSeq<Object> values, double[] quantiles) {
        int count = values.size();
        if (count > 0) {
            long[] indices = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(quantiles), (Function1)(JFunction1.mcJD.sp & Serializable)q -> package$.MODULE$.min((long)(q * (double)count), (long)(count - 1)), (ClassTag)ClassTag$.MODULE$.Long());
            return ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(indices), (Function1)(JFunction1.mcDJ.sp & Serializable)i -> BoxesRunTime.unboxToDouble((Object)values.apply((int)i)), (ClassTag)ClassTag$.MODULE$.Double())));
        }
        return (IndexedSeq)scala.package$.MODULE$.IndexedSeq().fill(quantiles.length, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0);
    }

    private AppStatusUtils$() {
    }
}

