/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.history.ApplicationHistoryProvider;
import org.apache.spark.deploy.history.HistoryServer;
import org.apache.spark.deploy.history.HistoryServerArguments;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.History$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class HistoryServer$
implements Logging {
    public static final HistoryServer$ MODULE$ = new HistoryServer$();
    private static SparkConf conf;
    private static final String UI_PATH_PREFIX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        UI_PATH_PREFIX = "/history";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkConf conf$lzycompute() {
        HistoryServer$ historyServer$ = this;
        synchronized (historyServer$) {
            if (!bitmap$0) {
                conf = new SparkConf();
                bitmap$0 = true;
            }
        }
        return conf;
    }

    private SparkConf conf() {
        if (!bitmap$0) {
            return this.conf$lzycompute();
        }
        return conf;
    }

    public String UI_PATH_PREFIX() {
        return UI_PATH_PREFIX;
    }

    public void main(String[] argStrings) {
        Utils$.MODULE$.resetStructuredLogging();
        Utils$.MODULE$.initDaemon(this.log());
        new HistoryServerArguments(this.conf(), argStrings);
        this.initSecurity();
        SecurityManager securityManager = this.createSecurityManager(this.conf());
        String providerName = this.conf().get(History$.MODULE$.PROVIDER());
        ApplicationHistoryProvider provider = (ApplicationHistoryProvider)Utils$.MODULE$.classForName(providerName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(SparkConf.class).newInstance(this.conf());
        int port = BoxesRunTime.unboxToInt((Object)this.conf().get(History$.MODULE$.HISTORY_SERVER_UI_PORT()));
        HistoryServer server = new HistoryServer(this.conf(), provider, securityManager, port);
        server.bind();
        provider.start();
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> server.stop());
        while (true) {
            Thread.sleep(Integer.MAX_VALUE);
        }
    }

    public SecurityManager createSecurityManager(SparkConf config) {
        if (config.getBoolean(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), false)) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Clearing " + SecurityManager$.MODULE$.SPARK_AUTH_CONF());
            v0 = config.set(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), "false");
        } else {
            v0 = BoxedUnit.UNIT;
        }
        if (BoxesRunTime.unboxToBoolean((Object)config.get(UI$.MODULE$.ACLS_ENABLE()))) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is configured, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.KEY$.MODULE$, (Object)UI$.MODULE$.ACLS_ENABLE().key())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"clearing it and only using ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.KEY2$.MODULE$, (Object)History$.MODULE$.HISTORY_SERVER_UI_ACLS_ENABLE().key())})))));
            v1 = config.set(UI$.MODULE$.ACLS_ENABLE(), BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            v1 = BoxedUnit.UNIT;
        }
        return new SecurityManager(config, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
    }

    public void initSecurity() {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(History$.MODULE$.KERBEROS_ENABLED()))) {
            String principalName = (String)((Option)this.conf().get(History$.MODULE$.KERBEROS_PRINCIPAL())).getOrElse((Function0 & Serializable)() -> {
                throw new NoSuchElementException(History$.MODULE$.KERBEROS_PRINCIPAL().key());
            });
            String keytabFilename = (String)((Option)this.conf().get(History$.MODULE$.KERBEROS_KEYTAB())).getOrElse((Function0 & Serializable)() -> {
                throw new NoSuchElementException(History$.MODULE$.KERBEROS_KEYTAB().key());
            });
            SparkHadoopUtil$.MODULE$.get().loginUserFromKeytab(principalName, keytabFilename);
            return;
        }
    }

    public String getAttemptURI(String appId, Option<String> attemptId) {
        String attemptSuffix = (String)attemptId.map((Function1 & Serializable)id -> "/" + id).getOrElse((Function0 & Serializable)() -> "");
        return this.UI_PATH_PREFIX() + "/" + appId + attemptSuffix;
    }

    private HistoryServer$() {
    }
}

