/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.Completer;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import org.apache.hive.beeline.CommandHandler;

class BeeLineCommandCompleter
extends AggregateCompleter {
    public BeeLineCommandCompleter(Iterable<CommandHandler> handlers) {
        super(BeeLineCommandCompleter.getCompleters(handlers));
    }

    public static List<Completer> getCompleters(Iterable<CommandHandler> handlers) {
        LinkedList<Completer> completers = new LinkedList<Completer>();
        for (CommandHandler handler : handlers) {
            String[] commandNames = handler.getNames();
            if (commandNames == null) continue;
            for (String commandName : commandNames) {
                LinkedList<Object> compl = new LinkedList<Object>();
                compl.add(new StringsCompleter(new String[]{"!" + commandName}));
                compl.addAll(Arrays.asList(handler.getParameterCompleters()));
                compl.add(new NullCompleter());
                completers.add((Completer)new AggregateCompleter(compl.toArray(new Completer[compl.size()])));
            }
        }
        return completers;
    }
}

