/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.Uniform$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.UpCastRule$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(min, max[, seed]) - Returns a random value with independent and identically\n      distributed (i.i.d.) values with the specified range of numbers. The random seed is optional.\n      The provided numbers specifying the minimum and maximum values of the range must be constant.\n      If both of these numbers are integers, then the result will also be an integer. Otherwise if\n      one or both of these are floating-point numbers, then the result will also be a floating-point\n      number.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(10, 20, 0) > 0 AS result;\n      true\n  ", since="4.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\tmd\u0001B\u0017/\u0001nB\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\tG\u0002\u0011\t\u0012)A\u0005y!AA\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005f\u0001\tE\t\u0015!\u0003=\u0011!1\u0007A!f\u0001\n\u0003\u0011\u0007\u0002C4\u0001\u0005#\u0005\u000b\u0011\u0002\u001f\t\u0011!\u0004!Q3A\u0005\u0002%D\u0001\"\u001c\u0001\u0003\u0012\u0003\u0006IA\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\u0006]\u0002!\t!\u001e\u0005\u0006]\u0002!\t\u0001\u001f\u0005\ty\u0002A)\u0019!C#S\"9Q\u0010\u0001b\u0001\n\u0003r\bbBA\u0016\u0001\u0001\u0006Ia \u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Baa\r\u0001\u0005B\u0005%\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\u0007\u0003W\u0002A\u0011\t2\t\r\u00055\u0004\u0001\"\u0011c\u0011\u0019\ty\u0007\u0001C!E\"9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\u0007\u0003\u001f\u0003A\u0011\t2\t\u0013\u0005E\u0005!!A\u0005\u0002\u0005M\u0005\"CAO\u0001E\u0005I\u0011AAP\u0011%\t)\fAI\u0001\n\u0003\ty\nC\u0005\u00028\u0002\t\n\u0011\"\u0001\u0002 \"I\u0011\u0011\u0018\u0001\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u007f\u0003\u0011\u0011!C!\u0003\u0003D\u0011\"!5\u0001\u0003\u0003%\t!a5\t\u0013\u0005m\u0007!!A\u0005\u0002\u0005u\u0007\"CAu\u0001\u0005\u0005I\u0011IAv\u0011%\tI\u0010AA\u0001\n\u0003\tY\u0010C\u0005\u0002\u0000\u0002\t\t\u0011\"\u0011\u0003\u0002!I!Q\u0001\u0001\u0002\u0002\u0013\u0005#qA\u0004\b\u0005Wq\u0003\u0012\u0001B\u0017\r\u0019ic\u0006#\u0001\u00030!1aN\nC\u0001\u0005\u0003BqAa\u0011'\t\u0003\u0011)\u0005C\u0004\u0003D\u0019\"\tAa\u0013\t\u0013\t\rc%!A\u0005\u0002\nM\u0003\"\u0003B/M\u0005\u0005I\u0011\u0011B0\u0011%\u0011\tHJA\u0001\n\u0013\u0011\u0019HA\u0004V]&4wN]7\u000b\u0005=\u0002\u0014aC3yaJ,7o]5p]NT!!\r\u001a\u0002\u0011\r\fG/\u00197zgRT!a\r\u001b\u0002\u0007M\fHN\u0003\u00026m\u0005)1\u000f]1sW*\u0011q\u0007O\u0001\u0007CB\f7\r[3\u000b\u0003e\n1a\u001c:h\u0007\u0001\u0019\u0002\u0002\u0001\u001fA\u0007&cu*\u0016\t\u0003{yj\u0011AL\u0005\u0003\u007f9\u0012!\"\u0012=qe\u0016\u001c8/[8o!\ti\u0014)\u0003\u0002C]\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\r!u\tP\u0007\u0002\u000b*\u0011a\tM\u0001\u0006iJ,Wm]\u0005\u0003\u0011\u0016\u00131\u0002V3s]\u0006\u0014\u0018\u0010T5lKB\u0011QHS\u0005\u0003\u0017:\u00121A\u0015#H!\tiT*\u0003\u0002O]\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\u000fA\u0013x\u000eZ;diB\u0011aK\u0018\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017\u001e\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0016BA/R\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005u\u000b\u0016aA7j]V\tA(\u0001\u0003nS:\u0004\u0013aA7bq\u0006!Q.\u0019=!\u00039\u0019X-\u001a3FqB\u0014Xm]:j_:\fqb]3fI\u0016C\bO]3tg&|g\u000eI\u0001\tQ&$WmU3fIV\t!\u000e\u0005\u0002QW&\u0011A.\u0015\u0002\b\u0005>|G.Z1o\u0003%A\u0017\u000eZ3TK\u0016$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006aF\u00148\u000f\u001e\t\u0003{\u0001AQ!Y\u0005A\u0002qBQ\u0001Z\u0005A\u0002qBQAZ\u0005A\u0002qBQ\u0001[\u0005A\u0002)$2\u0001\u001d<x\u0011\u0015\t'\u00021\u0001=\u0011\u0015!'\u00021\u0001=)\u0011\u0001\u0018P_>\t\u000b\u0005\\\u0001\u0019\u0001\u001f\t\u000b\u0011\\\u0001\u0019\u0001\u001f\t\u000b\u0019\\\u0001\u0019\u0001\u001f\u0002\u001b\u0011,G/\u001a:nS:L7\u000f^5d\u00031qw\u000eZ3QCR$XM\u001d8t+\u0005y\b#\u0002,\u0002\u0002\u0005\u0015\u0011bAA\u0002A\n\u00191+Z9\u0011\t\u0005\u001d\u0011Q\u0005\b\u0005\u0003\u0013\t\tC\u0004\u0003\u0002\f\u0005}a\u0002BA\u0007\u0003;qA!a\u0004\u0002\u001c9!\u0011\u0011CA\r\u001d\u0011\t\u0019\"a\u0006\u000f\u0007a\u000b)\"C\u0001:\u0013\t9\u0004(\u0003\u00026m%\u00111\u0007N\u0005\u0003cIJ!A\u0012\u0019\n\u0007\u0005\rR)A\u0006Ue\u0016,\u0007+\u0019;uKJt\u0017\u0002BA\u0014\u0003S\u00111\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u00111E#\u0002\u001b9|G-\u001a)biR,'O\\:!\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003c\u0001RAVA\u0001\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s\u0011\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\u001f\u0003o\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0011\u0011\t\u0005U\u0012QI\u0005\u0005\u0003\u000f\n9D\u0001\u0005ECR\fG+\u001f9f+\t\tY\u0005\u0005\u0003\u0002N\u0005Uc\u0002BA(\u0003#\u0002\"\u0001W)\n\u0007\u0005M\u0013+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\nIF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'\n\u0016aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA0!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3a\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002j\u0005\r$a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003-9\u0018\u000e\u001e5OK^\u001cV-\u001a3\u0015\u0007q\n)\bC\u0004\u0002xY\u0001\r!!\u001f\u0002\u000f9,woU3fIB\u0019\u0001+a\u001f\n\u0007\u0005u\u0014K\u0001\u0003M_:<\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001da\u00141QAD\u0003\u0017Ca!!\"\u0018\u0001\u0004a\u0014\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005%u\u00031\u0001=\u0003%qWm^*fG>tG\r\u0003\u0004\u0002\u000e^\u0001\r\u0001P\u0001\t]\u0016<H\u000b[5sI\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003\u0011\u0019w\u000e]=\u0015\u0013A\f)*a&\u0002\u001a\u0006m\u0005bB1\u001a!\u0003\u0005\r\u0001\u0010\u0005\bIf\u0001\n\u00111\u0001=\u0011\u001d1\u0017\u0004%AA\u0002qBq\u0001[\r\u0011\u0002\u0003\u0007!.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005&f\u0001\u001f\u0002$.\u0012\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003%)hn\u00195fG.,GMC\u0002\u00020F\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019,!+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA_U\rQ\u00171U\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0007\u0003BAc\u0003\u001fl!!a2\u000b\t\u0005%\u00171Z\u0001\u0005Y\u0006twM\u0003\u0002\u0002N\u0006!!.\u0019<b\u0013\u0011\t9&a2\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0007c\u0001)\u0002X&\u0019\u0011\u0011\\)\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0017Q\u001d\t\u0004!\u0006\u0005\u0018bAAr#\n\u0019\u0011I\\=\t\u0013\u0005\u001d\b%!AA\u0002\u0005U\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002nB1\u0011q^A{\u0003?l!!!=\u000b\u0007\u0005M\u0018+\u0001\u0006d_2dWm\u0019;j_:LA!a>\u0002r\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rQ\u0017Q \u0005\n\u0003O\u0014\u0013\u0011!a\u0001\u0003?\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111\u0019B\u0002\u0011%\t9oIA\u0001\u0002\u0004\t).\u0001\u0004fcV\fGn\u001d\u000b\u0004U\n%\u0001\"CAtI\u0005\u0005\t\u0019AApQM\u0001!Q\u0002B\n\u0005+\u0011IBa\u0007\u0003 \t\u0005\"Q\u0005B\u0014!\ri$qB\u0005\u0004\u0005#q#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005/\t1\u0011\u001f\u0006!A\u0001\u0002sLR+O\u0007~CS.\u001b8-A5\f\u0007p\u0017\u0017!g\u0016,G-X\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t:b]\u0012|W\u000e\t<bYV,\u0007e^5uQ\u0002Jg\u000eZ3qK:$WM\u001c;!C:$\u0007%\u001b3f]RL7-\u00197ms*\u0001\u0003\u0005\t\u0011!A\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011)S:Jg\u0006\u001a\u0018*AY\fG.^3tA]LG\u000f\u001b\u0011uQ\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011sC:<W\rI8gA9,XNY3sg:\u0002C\u000b[3!e\u0006tGm\\7!g\u0016,G\rI5tA=\u0004H/[8oC2t#\u0002\t\u0011!A\u0001\u0002C\u000b[3!aJ|g/\u001b3fI\u0002rW/\u001c2feN\u00043\u000f]3dS\u001aL\u0018N\\4!i\",\u0007%\\5oS6,X\u000eI1oI\u0002j\u0017\r_5nk6\u0004c/\u00197vKN\u0004sN\u001a\u0011uQ\u0016\u0004#/\u00198hK\u0002jWo\u001d;!E\u0016\u00043m\u001c8ti\u0006tGO\f\u0006!A\u0001\u0002\u0003\u0005I%gA\t|G\u000f\u001b\u0011pM\u0002\"\b.Z:fA9,XNY3sg\u0002\n'/\u001a\u0011j]R,w-\u001a:tY\u0001\"\b.\u001a8!i\",\u0007E]3tk2$\be^5mY\u0002\nGn]8!E\u0016\u0004\u0013M\u001c\u0011j]R,w-\u001a:/A=#\b.\u001a:xSN,\u0007%\u001b4\u000bA\u0001\u0002\u0003\u0005\t\u0011p]\u0016\u0004sN\u001d\u0011c_RD\u0007e\u001c4!i\",7/\u001a\u0011be\u0016\u0004c\r\\8bi&tw-\f9pS:$\bE\\;nE\u0016\u00148\u000f\f\u0011uQ\u0016t\u0007\u0005\u001e5fAI,7/\u001e7uA]LG\u000e\u001c\u0011bYN|\u0007EY3!C\u00022Gn\\1uS:<W\u0006]8j]RT\u0001\u0005\t\u0011!A\u0001rW/\u001c2fe:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QD\u0001M\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0004\u0007\f\u00113a1\u0002\u0003'\u000b\u0011?AA\u0002\u0013i\u0015\u0011sKN,H\u000e^\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t\r\u0012!\u0002\u001b/a9\u0002\u0014!B4s_V\u0004\u0018E\u0001B\u0015\u0003)i\u0017\r\u001e5`MVt7m]\u0001\b+:Lgm\u001c:n!\tideE\u0003'\u0005c\u00119\u0004E\u0002Q\u0005gI1A!\u000eR\u0005\u0019\te.\u001f*fMB!!\u0011\bB \u001b\t\u0011YD\u0003\u0003\u0003>\u0005-\u0017AA5p\u0013\ry&1\b\u000b\u0003\u0005[\tQ!\u00199qYf$R\u0001\u001dB$\u0005\u0013BQ!\u0019\u0015A\u0002qBQ\u0001\u001a\u0015A\u0002q\"r\u0001\u001dB'\u0005\u001f\u0012\t\u0006C\u0003bS\u0001\u0007A\bC\u0003eS\u0001\u0007A\bC\u0003gS\u0001\u0007A\bF\u0005q\u0005+\u00129F!\u0017\u0003\\!)\u0011M\u000ba\u0001y!)AM\u000ba\u0001y!)aM\u000ba\u0001y!)\u0001N\u000ba\u0001U\u00069QO\\1qa2LH\u0003\u0002B1\u0005[\u0002R\u0001\u0015B2\u0005OJ1A!\u001aR\u0005\u0019y\u0005\u000f^5p]B9\u0001K!\u001b=yqR\u0017b\u0001B6#\n1A+\u001e9mKRB\u0001Ba\u001c,\u0003\u0003\u0005\r\u0001]\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B;!\u0011\t)Ma\u001e\n\t\te\u0014q\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class Uniform
extends Expression
implements RuntimeReplaceable,
TernaryLike<Expression>,
RDG,
ExpectsInputTypes,
Serializable {
    private boolean deterministic;
    private final Expression min;
    private final Expression max;
    private final Expression seedExpression;
    private final boolean hideSeed;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient XORShiftRandom rng;
    private transient long seed;
    private transient Seq<Expression> children;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(Uniform x$0) {
        return Uniform$.MODULE$.unapply(x$0);
    }

    @Override
    public boolean stateful() {
        return RDG.stateful$(this);
    }

    @Override
    public boolean nullable() {
        return RDG.nullable$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public XORShiftRandom rng() {
        return this.rng;
    }

    @Override
    public void rng_$eq(XORShiftRandom x$1) {
        this.rng = x$1;
    }

    private long seed$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.seed = RDG.seed$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.seed;
    }

    @Override
    public long seed() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.seed$lzycompute();
        }
        return this.seed;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    private Seq<Expression> children$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    private Expression canonicalized$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression min() {
        return this.min;
    }

    public Expression max() {
        return this.max;
    }

    @Override
    public Expression seedExpression() {
        return this.seedExpression;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    private boolean deterministic$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.deterministic = false;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection randomSeedTypes = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, LongType$.MODULE$}));
        return new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)randomSeedTypes, (List)Nil$.MODULE$)));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public DataType dataType() {
        block20: {
            block19: {
                var4_1 = new Tuple2((Object)this.min().dataType(), (Object)this.max().dataType());
                if (!this.seedExpression().resolved()) break block19;
                v0 = this.seedExpression().dataType();
                var5_2 = NullType$.MODULE$;
                if (v0 != null ? v0.equals(var5_2) == false : var5_2 != null) break block20;
            }
            return NullType$.MODULE$;
        }
        if (var4_1 != null) {
            left = (DataType)var4_1._1();
            right = (DataType)var4_1._2();
            if (left instanceof IntegralType) {
                var8_5 = (IntegralType)left;
                if (right instanceof IntegralType) {
                    var9_6 = (IntegralType)right;
                    if (UpCastRule$.MODULE$.legalNumericPrecedence((DataType)var8_5, (DataType)var9_6)) {
                        return var9_6;
                    }
                    return var8_5;
                }
            }
        }
        if (var4_1 == null) ** GOTO lbl-1000
        var10_7 = (DataType)var4_1._2();
        if (var4_1._1() instanceof NumericType && DoubleType$.MODULE$.equals(var10_7)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var4_1 != null && DoubleType$.MODULE$.equals(var11_8 = (DataType)var4_1._1()) != false && var4_1._2() instanceof NumericType != false;
        }
        if (v1) {
            return DoubleType$.MODULE$;
        }
        if (var4_1 == null) ** GOTO lbl-1000
        var12_9 = (DataType)var4_1._2();
        if (var4_1._1() instanceof NumericType && FloatType$.MODULE$.equals(var12_9)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = var4_1 != null && FloatType$.MODULE$.equals(var13_10 = (DataType)var4_1._1()) != false && var4_1._2() instanceof NumericType != false;
        }
        if (v2) {
            return FloatType$.MODULE$;
        }
        if (var4_1 != null) {
            lhs = (DataType)var4_1._1();
            rhs = (DataType)var4_1._2();
            if (lhs instanceof DecimalType) {
                var16_13 = (DecimalType)lhs;
                if (rhs instanceof DecimalType) {
                    var17_14 = (DecimalType)rhs;
                    if (var16_13.isWiderThan((DataType)var17_14)) {
                        return var16_13;
                    }
                    return var17_14;
                }
            }
        }
        if (var4_1 != null && (d = (DataType)var4_1._2()) instanceof DecimalType) {
            var19_16 = (DecimalType)d;
            return var19_16;
        }
        if (var4_1 != null && (d = (DataType)var4_1._1()) instanceof DecimalType) {
            var21_18 = (DecimalType)d;
            return var21_18;
        }
        throw SparkException$.MODULE$.internalError("Unexpected argument data types: " + this.min().dataType() + ", " + this.max().dataType());
    }

    @Override
    public String sql() {
        return "uniform(" + this.min().sql() + ", " + this.max().sql() + (this.hideSeed() ? "" : ", " + this.seedExpression().sql()) + ")";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ObjectRef result = ObjectRef.create((Object)ExpectsInputTypes.checkInputDataTypes$(this));
        new .colon.colon((Object)new Tuple2((Object)this.min(), (Object)"min"), (List)new .colon.colon((Object)new Tuple2((Object)this.max(), (Object)"max"), (List)new .colon.colon((Object)new Tuple2((Object)this.seedExpression(), (Object)"seed"), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x0$1 -> {
            Uniform.$anonfun$checkInputDataTypes$1(result, x0$1);
            return BoxedUnit.UNIT;
        });
        return (TypeCheckResult)result.elem;
    }

    @Override
    public Expression first() {
        return this.min();
    }

    @Override
    public Expression second() {
        return this.max();
    }

    @Override
    public Expression third() {
        return this.seedExpression();
    }

    @Override
    public Expression withNewSeed(long newSeed) {
        return new Uniform(this.min(), this.max(), new Literal(BoxesRunTime.boxToLong((long)newSeed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return new Uniform(newFirst, newSecond, newThird, this.hideSeed());
    }

    @Override
    public Expression replacement() {
        if (new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.max(), (List)new .colon.colon((Object)this.seedExpression(), (List)Nil$.MODULE$))).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Uniform.$anonfun$replacement$1(x$2)))) {
            return Literal$.MODULE$.apply(null);
        }
        return Uniform.cast$1(new Add(Uniform.cast$1(this.min(), (DataType)DoubleType$.MODULE$), new Multiply(new Subtract(Uniform.cast$1(this.max(), (DataType)DoubleType$.MODULE$), Uniform.cast$1(this.min(), (DataType)DoubleType$.MODULE$), Subtract$.MODULE$.apply$default$3()), Rand$.MODULE$.apply(this.seed()), Multiply$.MODULE$.apply$default$3()), Add$.MODULE$.apply$default$3()), this.dataType());
    }

    public Uniform copy(Expression min, Expression max, Expression seedExpression, boolean hideSeed) {
        return new Uniform(min, max, seedExpression, hideSeed);
    }

    public Expression copy$default$1() {
        return this.min();
    }

    public Expression copy$default$2() {
        return this.max();
    }

    public Expression copy$default$3() {
        return this.seedExpression();
    }

    public boolean copy$default$4() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Uniform";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.min();
            }
            case 1: {
                return this.max();
            }
            case 2: {
                return this.seedExpression();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uniform;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "min";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "seedExpression";
            }
            case 3: {
                return "hideSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uniform)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uniform uniform = (Uniform)x$1;
        if (this.hideSeed() != uniform.hideSeed()) return false;
        Expression expression = this.min();
        Expression expression2 = uniform.min();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.max();
        Expression expression4 = uniform.max();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.seedExpression();
        Expression expression6 = uniform.seedExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!uniform.canEqual(this)) return false;
        return true;
    }

    private static final String requiredType$1() {
        return "integer or floating-point";
    }

    public static final /* synthetic */ void $anonfun$checkInputDataTypes$1(ObjectRef result$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Expression expr = (Expression)tuple2._1();
            String name = (String)tuple2._2();
            if (expr != null) {
                Expression expression = expr;
                if (name != null) {
                    String string = name;
                    TypeCheckResult typeCheckResult = (TypeCheckResult)result$1.elem;
                    TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    if (!(typeCheckResult != null ? !typeCheckResult.equals(typeCheckResult$TypeCheckSuccess$) : typeCheckResult$TypeCheckSuccess$ != null) && !expression.foldable()) {
                        result$1.elem = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)ExpectsInputTypes$.MODULE$.toSQLId(string)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Uniform.requiredType$1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)ExpectsInputTypes$.MODULE$.toSQLExpr(expression))}))));
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$replacement$1(Expression x$2) {
        DataType dataType = x$2.dataType();
        NullType$ nullType$ = NullType$.MODULE$;
        return !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null);
    }

    private static final Expression cast$1(Expression e, DataType to) {
        DataType dataType = e.dataType();
        DataType dataType2 = to;
        if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
            return e;
        }
        return new Cast(e, to, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
    }

    public Uniform(Expression min, Expression max, Expression seedExpression, boolean hideSeed) {
        this.min = min;
        this.max = max;
        this.seedExpression = seedExpression;
        this.hideSeed = hideSeed;
        RuntimeReplaceable.$init$(this);
        TernaryLike.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        RDG.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)new .colon.colon((Object)TreePattern$.MODULE$.EXPRESSION_WITH_RANDOM_SEED(), (List)Nil$.MODULE$));
    }

    public Uniform(Expression min, Expression max) {
        this(min, max, UnresolvedSeed$.MODULE$, true);
    }

    public Uniform(Expression min, Expression max, Expression seedExpression) {
        this(min, max, seedExpression, false);
    }
}

