/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.HiveHash$;
import org.apache.spark.sql.catalyst.expressions.HiveHashFunction$;
import org.apache.spark.sql.catalyst.expressions.HiveHasher;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a hash value of the arguments.", since="2.2.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B\u0015+\u0001^B\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t3\u0002\u0011\t\u0012)A\u0005'\")!\f\u0001C\u00017\"9a\f\u0001b\u0001\n\u0003z\u0006B\u00021\u0001A\u0003%A\bC\u0003b\u0001\u0011\u0005#\rC\u0003j\u0001\u0011\u0005#\u000eC\u0003t\u0001\u0011E#\u000eC\u0003u\u0001\u0011ES\u000fC\u0003z\u0001\u0011E#\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!I\u00111\u0007\u0001\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\b\u0003\u0017\u0002A\u0011KA'\u0011\u001d\t9\u0006\u0001C)\u00033Bq!!\u0019\u0001\t#\n\u0019\u0007C\u0004\u0002l\u0001!\t&!\u001c\t\u000f\u0005}\u0004\u0001\"\u0015\u0002\u0002\"9\u0011q\u0011\u0001\u0005R\u0005%\u0005bBAH\u0001\u0011E\u0013\u0011\u0013\u0005\b\u0003G\u0003A\u0011KAS\u0011\u001d\t)\f\u0001C)\u0003oCq!a3\u0001\t#\ni\rC\u0004\u0002f\u0002!\t&a:\t\u0013\u0005M\b!!A\u0005\u0002\u0005U\b\"CA}\u0001E\u0005I\u0011AA~\u0011%\ty\u0010AA\u0001\n\u0003\u0012\t\u0001\u0003\u0005\u0003\u0012\u0001\t\t\u0011\"\u0001`\u0011%\u0011\u0019\u0002AA\u0001\n\u0003\u0011)\u0002C\u0005\u0003\u001c\u0001\t\t\u0011\"\u0011\u0003\u001e!I!1\u0006\u0001\u0002\u0002\u0013\u0005!Q\u0006\u0005\n\u0005c\u0001\u0011\u0011!C!\u0005gA\u0011Ba\u000e\u0001\u0003\u0003%\tE!\u000f\b\u0013\t]#&!A\t\u0002\tec\u0001C\u0015+\u0003\u0003E\tAa\u0017\t\ri\u001bC\u0011\u0001B:\u0011%\u0011)hIA\u0001\n\u000b\u00129\bC\u0005\u0003z\r\n\t\u0011\"!\u0003|!I!qP\u0012\u0002\u0002\u0013\u0005%\u0011\u0011\u0005\n\u0005\u001b\u001b\u0013\u0011!C\u0005\u0005\u001f\u0013\u0001\u0002S5wK\"\u000b7\u000f\u001b\u0006\u0003W1\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QFL\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0006M\u0001\u0004gFd'BA\u00193\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u000f\"F!\rI$\bP\u0007\u0002U%\u00111H\u000b\u0002\u000f\u0011\u0006\u001c\b.\u0012=qe\u0016\u001c8/[8o!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\rIe\u000e\u001e\t\u0003{\rK!\u0001\u0012 \u0003\u000fA\u0013x\u000eZ;diB\u0011aI\u0014\b\u0003\u000f2s!\u0001S&\u000e\u0003%S!A\u0013\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014BA'?\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0014)\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00055s\u0014\u0001C2iS2$'/\u001a8\u0016\u0003M\u00032A\u0012+W\u0013\t)\u0006KA\u0002TKF\u0004\"!O,\n\u0005aS#AC#yaJ,7o]5p]\u0006I1\r[5mIJ,g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005qk\u0006CA\u001d\u0001\u0011\u0015\t6\u00011\u0001T\u0003\u0011\u0019X-\u001a3\u0016\u0003q\nQa]3fI\u0002\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011aML\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0016\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#A6\u0011\u00051\u0004hBA7o!\tAe(\u0003\u0002p}\u00051\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\tyg(A\biCNDWM]\"mCN\u001ch*Y7f\u0003AI7oQ8mY\u0006$\u0018n\u001c8Bo\u0006\u0014X-F\u0001w!\tit/\u0003\u0002y}\t9!i\\8mK\u0006t\u0017aC2p[B,H/\u001a%bg\"$b\u0001P>\u0002\u0002\u0005\r\u0001\"\u0002?\u000b\u0001\u0004i\u0018!\u0002<bYV,\u0007CA\u001f\u007f\u0013\tyhHA\u0002B]fDQ!\u0019\u0006A\u0002\rDQA\u0018\u0006A\u0002q\n\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005%\u0011QCA\u0010!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\bU\u000591m\u001c3fO\u0016t\u0017\u0002BA\n\u0003\u001b\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003/Y\u0001\u0019AA\r\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0017\tY\"\u0003\u0003\u0002\u001e\u00055!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003CY\u0001\u0019AA\u0005\u0003\t)g/\u0001\u0003fm\u0006dGc\u0001\u001f\u0002(!I\u0011\u0011\u0006\u0007\u0011\u0002\u0003\u0007\u00111F\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003[\ty#D\u0001-\u0013\r\t\t\u0004\f\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\bfm\u0006dG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005]\"\u0006BA\u0016\u0003sY#!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000br\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011JA \u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bO\u0016t\u0007*Y:i\u0013:$H#B6\u0002P\u0005M\u0003BBA)\u001d\u0001\u00071.A\u0001j\u0011\u0019\t)F\u0004a\u0001W\u00061!/Z:vYR\f1bZ3o\u0011\u0006\u001c\b\u000eT8oOR)1.a\u0017\u0002`!1\u0011QL\bA\u0002-\f\u0011\u0001\u001c\u0005\u0007\u0003+z\u0001\u0019A6\u0002\u0019\u001d,g\u000eS1tQ\nKH/Z:\u0015\u000b-\f)'!\u001b\t\r\u0005\u001d\u0004\u00031\u0001l\u0003\u0005\u0011\u0007BBA+!\u0001\u00071.\u0001\bhK:D\u0015m\u001d5EK\u000eLW.\u00197\u0015\u0013-\fy'!\u001d\u0002|\u0005u\u0004bBA\f#\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003g\n\u0002\u0019AA;\u0003\u0005!\u0007c\u00013\u0002x%\u0019\u0011\u0011P3\u0003\u0017\u0011+7-[7bYRK\b/\u001a\u0005\u0007\u0003S\t\u0002\u0019A6\t\r\u0005U\u0013\u00031\u0001l\u0003]9WM\u001c%bg\"\u001c\u0015\r\\3oI\u0006\u0014\u0018J\u001c;feZ\fG\u000eF\u0003l\u0003\u0007\u000b)\t\u0003\u0004\u0002*I\u0001\ra\u001b\u0005\u0007\u0003+\u0012\u0002\u0019A6\u0002!\u001d,g\u000eS1tQRKW.Z:uC6\u0004H#B6\u0002\f\u00065\u0005BBA\u0015'\u0001\u00071\u000e\u0003\u0004\u0002VM\u0001\ra[\u0001\u000eO\u0016t\u0007*Y:i'R\u0014\u0018N\\4\u0015\u0013-\f\u0019*!&\u0002 \u0006\u0005\u0006bBA\f)\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003/#\u0002\u0019AAM\u0003)\u0019HO]5oORK\b/\u001a\t\u0004I\u0006m\u0015bAAOK\nQ1\u000b\u001e:j]\u001e$\u0016\u0010]3\t\r\u0005%B\u00031\u0001l\u0011\u0019\t)\u0006\u0006a\u0001W\u0006yq-\u001a8ICNDgi\u001c:BeJ\f\u0017\u0010F\u0006l\u0003O\u000bI+a+\u0002.\u0006E\u0006bBA\f+\u0001\u0007\u0011\u0011\u0004\u0005\u0007\u0003S)\u0002\u0019A6\t\r\u0005US\u00031\u0001l\u0011\u0019\ty+\u0006a\u0001G\u0006YQ\r\\3nK:$H+\u001f9f\u0011\u0019\t\u0019,\u0006a\u0001m\u0006a1m\u001c8uC&t7OT;mY\u0006iq-\u001a8ICNDgi\u001c:NCB$Rb[A]\u0003w\u000bi,a0\u0002D\u0006\u001d\u0007bBA\f-\u0001\u0007\u0011\u0011\u0004\u0005\u0007\u0003S1\u0002\u0019A6\t\r\u0005Uc\u00031\u0001l\u0011\u0019\t\tM\u0006a\u0001G\u000691.Z=UsB,\u0007BBAc-\u0001\u00071-A\u0005wC2,X\rV=qK\"1\u0011\u0011\u001a\fA\u0002Y\f\u0011C^1mk\u0016\u001cuN\u001c;bS:\u001ch*\u001e7m\u0003A9WM\u001c%bg\"4uN]*ueV\u001cG\u000fF\u0005l\u0003\u001f\f\t.a5\u0002V\"9\u0011qC\fA\u0002\u0005e\u0001BBA\u0015/\u0001\u00071\u000e\u0003\u0004\u0002V]\u0001\ra\u001b\u0005\b\u0003/<\u0002\u0019AAm\u0003\u00191\u0017.\u001a7egB)Q(a7\u0002`&\u0019\u0011Q\u001c \u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0011\f\t/C\u0002\u0002d\u0016\u00141b\u0015;sk\u000e$h)[3mI\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u00049\u0006%\bbBAv1\u0001\u0007\u0011Q^\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003G\u0003_4\u0016bAAy!\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u00049\u0006]\bbB)\u001a!\u0003\u0005\raU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiPK\u0002T\u0003s\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0002!\u0011\u0011)Aa\u0004\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\tA\u0001\\1oO*\u0011!QB\u0001\u0005U\u00064\u0018-C\u0002r\u0005\u000f\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002~\u0005/A\u0001B!\u0007\u001e\u0003\u0003\u0005\r\u0001P\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t}\u0001#\u0002B\u0011\u0005OiXB\u0001B\u0012\u0015\r\u0011)CP\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0015\u0005G\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019aOa\f\t\u0011\teq$!AA\u0002u\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!1\u0001B\u001b\u0011!\u0011I\u0002IA\u0001\u0002\u0004a\u0014AB3rk\u0006d7\u000fF\u0002w\u0005wA\u0001B!\u0007\"\u0003\u0003\u0005\r! \u0015\u0010\u0001\t}\"Q\tB$\u0005\u0017\u0012iE!\u0015\u0003TA\u0019\u0011H!\u0011\n\u0007\t\r#FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t%\u0013AQ0G+:\u001bu\fK3yaJ\fD\u0006I3yaJ\u0014D\u0006\t\u0018/]%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA!\f7\u000f\u001b\u0011wC2,X\rI8gAQDW\rI1sOVlWM\u001c;t]\u0005)1/\u001b8dK\u0006\u0012!qJ\u0001\u0006e9\u0012d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005+\n!\u0002[1tQ~3WO\\2t\u0003!A\u0015N^3ICND\u0007CA\u001d$'\u0015\u0019#Q\fB5!\u0019\u0011yF!\u001aT96\u0011!\u0011\r\u0006\u0004\u0005Gr\u0014a\u0002:v]RLW.Z\u0005\u0005\u0005O\u0012\tGA\tBEN$(/Y2u\rVt7\r^5p]F\u0002BAa\u001b\u0003r5\u0011!Q\u000e\u0006\u0005\u0005_\u0012Y!\u0001\u0002j_&\u0019qJ!\u001c\u0015\u0005\te\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\r\u0011!B1qa2LHc\u0001/\u0003~!)\u0011K\na\u0001'\u00069QO\\1qa2LH\u0003\u0002BB\u0005\u0013\u0003B!\u0010BC'&\u0019!q\u0011 \u0003\r=\u0003H/[8o\u0011!\u0011YiJA\u0001\u0002\u0004a\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0013\t\u0005\u0005\u000b\u0011\u0019*\u0003\u0003\u0003\u0016\n\u001d!AB(cU\u0016\u001cG\u000f")
public class HiveHash
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final int seed;

    public static Option<Seq<Expression>> unapply(HiveHash x$0) {
        return HiveHash$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<HiveHash, A> g) {
        return HiveHash$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, HiveHash> compose(Function1<A$, Seq<Expression>> g) {
        return HiveHash$.MODULE$.compose(g);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public int seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "hive-hash";
    }

    @Override
    public String hasherClassName() {
        return HiveHasher.class.getName();
    }

    @Override
    public boolean isCollationAware() {
        return true;
    }

    @Override
    public int computeHash(Object value, DataType dataType, int seed) {
        return (int)HiveHashFunction$.MODULE$.hash(value, dataType, this.seed(), this.isCollationAware(), this.legacyCollationAwareHashing());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ev.isNull_$eq(FalseLiteral$.MODULE$);
        String childHash = ctx.freshName("childHash");
        Seq childrenHash = (Seq)this.children().map((Function1 & Serializable)child -> {
            ExprCode childGen = child.genCode(ctx);
            String codeToComputeHash = ctx.nullSafeExec(child.nullable(), ExprValue$.MODULE$.exprValueToString(childGen.isNull()), this.computeHash(ExprValue$.MODULE$.exprValueToString(childGen.value()), child.dataType(), childHash, ctx));
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + childGen.code() + "\n         |" + childHash + " = 0;\n         |" + codeToComputeHash + "\n         |" + ev.value() + " = (31 * " + ev.value() + ") + " + childHash + ";\n       "));
        });
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)childrenHash, "computeHash", (Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"int"), (Object)ExprValue$.MODULE$.exprValueToString(ev.value())), (List)Nil$.MODULE$), "int", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |int " + childHash + " = 0;\n           |" + body + "\n           |return " + ev.value() + ";\n         ")), (Function1<Seq<String>, String>)(Function1 & Serializable)x$9 -> ((IterableOnceOps)x$9.map((Function1 & Serializable)funcCall -> ev.value() + " = " + funcCall + ";")).mkString("\n"));
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |", " ", " = 0;\n         |", "\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"int", ev.value(), BoxesRunTime.boxToInteger((int)this.seed()), "int", childHash, codes})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    public int eval(InternalRow input) {
        int hash = this.seed();
        int len = this.children().length();
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + this.computeHash(((Expression)this.children().apply(i)).eval(input), ((Expression)this.children().apply(i)).dataType(), hash);
        }
        return hash;
    }

    @Override
    public InternalRow eval$default$1() {
        return null;
    }

    @Override
    public String genHashInt(String i, String result) {
        return result + " = " + this.hasherClassName() + ".hashInt(" + i + ");";
    }

    @Override
    public String genHashLong(String l, String result) {
        return result + " = " + this.hasherClassName() + ".hashLong(" + l + ");";
    }

    @Override
    public String genHashBytes(String b, String result) {
        return result + " = " + this.hasherClassName() + ".hashUnsafeBytes(" + b + ", Platform.BYTE_ARRAY_OFFSET, " + b + ".length);";
    }

    @Override
    public String genHashDecimal(CodegenContext ctx, DecimalType d, String input, String result) {
        return "\n      " + result + " = " + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(HiveHashFunction$.MODULE$.getClass().getName()), "$") + ".normalizeDecimal(\n        " + input + ".toJavaBigDecimal()).hashCode();";
    }

    @Override
    public String genHashCalendarInterval(String input, String result) {
        return "\n      " + result + " = (int)\n        " + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(HiveHashFunction$.MODULE$.getClass().getName()), "$") + ".hashCalendarInterval(" + input + ");\n     ";
    }

    @Override
    public String genHashTimestamp(String input, String result) {
        return "\n      " + result + " = (int) " + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(HiveHashFunction$.MODULE$.getClass().getName()), "$") + ".hashTimestamp(" + input + ");\n     ";
    }

    @Override
    public String genHashString(CodegenContext ctx, StringType stringType, String input, String result) {
        if (stringType.supportsBinaryEquality() || !this.isCollationAware()) {
            String baseObject = input + ".getBaseObject()";
            String baseOffset = input + ".getBaseOffset()";
            String numBytes = input + ".numBytes()";
            return result + " = " + this.hasherClassName() + ".hashUnsafeBytes(" + baseObject + ", " + baseOffset + ", " + numBytes + ");";
        }
        String key = ctx.freshName("key");
        int offset = Platform.BYTE_ARRAY_OFFSET;
        return "\n        byte[] " + key + " = (byte[]) CollationFactory.fetchCollation(" + stringType.collationId() + ")\n          .sortKeyFunction.apply(" + input + ");\n        " + result + " = " + this.hasherClassName() + ".hashUnsafeBytes(" + key + ", " + offset + ", " + key + ".length, " + result + ");\n      ";
    }

    @Override
    public String genHashForArray(CodegenContext ctx, String input, String result, DataType elementType, boolean containsNull) {
        String index = ctx.freshName("index");
        String childResult = ctx.freshName("childResult");
        return "\n        int " + childResult + " = 0;\n        for (int " + index + " = 0; " + index + " < " + input + ".numElements(); " + index + "++) {\n          " + childResult + " = 0;\n          " + this.nullSafeElementHash(input, index, containsNull, elementType, childResult, ctx) + ";\n          " + result + " = (31 * " + result + ") + " + childResult + ";\n        }\n      ";
    }

    @Override
    public String genHashForMap(CodegenContext ctx, String input, String result, DataType keyType, DataType valueType, boolean valueContainsNull) {
        String index = ctx.freshName("index");
        String keys = ctx.freshName("keys");
        String values = ctx.freshName("values");
        String keyResult = ctx.freshName("keyResult");
        String valueResult = ctx.freshName("valueResult");
        return "\n        final ArrayData " + keys + " = " + input + ".keyArray();\n        final ArrayData " + values + " = " + input + ".valueArray();\n        int " + keyResult + " = 0;\n        int " + valueResult + " = 0;\n        for (int " + index + " = 0; " + index + " < " + input + ".numElements(); " + index + "++) {\n          " + keyResult + " = 0;\n          " + this.nullSafeElementHash(keys, index, false, keyType, keyResult, ctx) + "\n          " + valueResult + " = 0;\n          " + this.nullSafeElementHash(values, index, valueContainsNull, valueType, valueResult, ctx) + "\n          " + result + " += " + keyResult + " ^ " + valueResult + ";\n        }\n      ";
    }

    @Override
    public String genHashForStruct(CodegenContext ctx, String input, String result, StructField[] fields) {
        String tmpInput = ctx.freshName("input");
        String childResult = ctx.freshName("childResult");
        String[] fieldsHash = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])fields))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int index = tuple2._2$mcI$sp();
                String computeFieldHash = this.nullSafeElementHash(tmpInput, Integer.toString(index), field.nullable(), field.dataType(), childResult, ctx);
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + childResult + " = 0;\n         |" + computeFieldHash + "\n         |" + result + " = (31 * " + result + ") + " + childResult + ";\n       "));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class));
        String code = ctx.splitExpressions((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)fieldsHash).toImmutableArraySeq(), "computeHashForStruct", (Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"InternalRow"), (Object)tmpInput), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"int"), (Object)result), (List)Nil$.MODULE$)), "int", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |int " + childResult + " = 0;\n           |" + body + "\n           |return " + result + ";\n           ")), (Function1<Seq<String>, String>)(Function1 & Serializable)x$10 -> ((IterableOnceOps)x$10.map((Function1 & Serializable)funcCall -> result + " = " + funcCall + ";")).mkString("\n"));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |final InternalRow " + tmpInput + " = " + input + ";\n       |int " + childResult + " = 0;\n       |" + code + "\n     "));
    }

    @Override
    public HiveHash withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public HiveHash copy(Seq<Expression> children2) {
        return new HiveHash(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "HiveHash";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HiveHash;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HiveHash)) return false;
        boolean bl = true;
        if (!bl) return false;
        HiveHash hiveHash = (HiveHash)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = hiveHash.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!hiveHash.canEqual(this)) return false;
        return true;
    }

    public HiveHash(Seq<Expression> children2) {
        this.children = children2;
        this.seed = 0;
    }
}

