/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Extract;
import org.apache.spark.sql.catalyst.expressions.Extract$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(field, source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted, and supported string values are as same as the fields of the equivalent function `EXTRACT`.\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_('week', timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_('doy', DATE'2019-08-12');\n       224\n      > SELECT _FUNC_('SECONDS', timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_('days', interval 5 days 3 hours 7 minutes);\n       5\n      > SELECT _FUNC_('seconds', interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n      > SELECT _FUNC_('MONTH', INTERVAL '2021-11' YEAR TO MONTH);\n       11\n      > SELECT _FUNC_('MINUTE', INTERVAL '123 23:55:59.002001' DAY TO SECOND);\n       55\n  ", note="\n    The _FUNC_ function is equivalent to the SQL-standard function `EXTRACT(field FROM source)`\n  ", group="datetime_funcs", since="3.0.0")
public final class DatePartExpressionBuilder$
implements ExpressionBuilder {
    public static final DatePartExpressionBuilder$ MODULE$ = new DatePartExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        int numArgs = expressions.length();
        if (numArgs == 2) {
            Expression field = (Expression)expressions.apply(0);
            Expression source = (Expression)expressions.apply(1);
            return new Extract(field, source, Extract$.MODULE$.createExpr(funcName, field, source));
        }
        throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(funcName, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}))), numArgs, QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
    }

    private DatePartExpressionBuilder$() {
    }
}

