/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.spark.SparkException$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001\u0002\u0012$\u0001AB\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u000b\")!\n\u0001C\u0001\u0017\"9a\n\u0001b\u0001\n\u0013y\u0005B\u0002,\u0001A\u0003%\u0001\u000bC\u0004X\u0001\t\u0007I\u0011B(\t\ra\u0003\u0001\u0015!\u0003Q\u0011!I\u0006\u0001#b\u0001\n\u0013Q\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007g\u0002\u0001\u000b\u0011\u00021\t\u000fQ\u0004!\u0019!C\u0005k\"9\u0011q\u0001\u0001!\u0002\u00131\b\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\t\u0019\u0002\u0001Q\u0001\n\u00055\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003\u001f\u0003A\u0011BAI\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!a'\u0001\t\u0013\ti\nC\u0004\u0002\"\u0002!I!a)\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003o\u0003A\u0011BA]\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017D\u0011\"!6\u0001\u0005\u0004%I!a6\t\u0011\u0005}\u0007\u0001)A\u0005\u00033\u0014abQ*W\u0013:4WM]*dQ\u0016l\u0017M\u0003\u0002%K\u0005\u00191m\u001d<\u000b\u0005\u0019:\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005!J\u0013aA:rY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003q\u0001s!!\u000f \u000f\u0005ijT\"A\u001e\u000b\u0005qz\u0013A\u0002\u001fs_>$h(C\u00015\u0013\ty4'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0013%\u0001D*fe&\fG.\u001b>bE2,'BA 4\u0003\u001dy\u0007\u000f^5p]N,\u0012!\u0012\t\u0003\r\u001ek\u0011aI\u0005\u0003\u0011\u000e\u0012!bQ*W\u001fB$\u0018n\u001c8t\u0003!y\u0007\u000f^5p]N\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002M\u001bB\u0011a\t\u0001\u0005\u0006\u0007\u000e\u0001\r!R\u0001\u0010i&lWm\u001d;b[B\u0004\u0016M]:feV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002TK\u0005!Q\u000f^5m\u0013\t)&K\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\u0018\u0001\u0005;j[\u0016\u001cH/Y7q!\u0006\u00148/\u001a:!\u0003U!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\fa\u0003^5nKN$\u0018-\u001c9O)j3uN]7biR,'\u000fI\u0001\u000eI\u0006$XMR8s[\u0006$H/\u001a:\u0016\u0003m\u0003\"!\u0015/\n\u0005u\u0013&!\u0004#bi\u00164uN]7biR,'/A\u0007eK\u000eLW.\u00197QCJ\u001cXM]\u000b\u0002AB!!'Y2l\u0013\t\u00117GA\u0005Gk:\u001cG/[8ocA\u0011A\r\u001b\b\u0003K\u001a\u0004\"AO\u001a\n\u0005\u001d\u001c\u0014A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u001a\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001B7bi\"T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\nQ!)[4EK\u000eLW.\u00197\u0002\u001d\u0011,7-[7bYB\u000b'o]3sA\u0005YC*\u0012(J\u000b:#v\fV*`\r>\u0013V*\u0011+U\u000bJ{6+\u0016)Q\u001fJ#V\tR0E\u0003R+uLR(S\u001b\u0006#6+F\u0001w!\r9HP`\u0007\u0002q*\u0011\u0011P_\u0001\nS6lW\u000f^1cY\u0016T!a_\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002~q\n\u00191+\u001a;\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A8\u0002\t1\fgnZ\u0005\u0004S\u0006\u0005\u0011\u0001\f'F\u001d&+e\nV0U'~3uJU'B)R+%kX*V!B{%\u000bV#E?\u0012\u000bE+R0G\u001fJk\u0015\tV*!\u00031I7\u000fR3gCVdGO\u0014+[+\t\ti\u0001E\u00023\u0003\u001fI1!!\u00054\u0005\u001d\u0011un\u001c7fC:\fQ\"[:EK\u001a\fW\u000f\u001c;O)j\u0003\u0013!B5oM\u0016\u0014HCBA\r\u0003K\tY\u0004\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tybJ\u0001\u0006if\u0004Xm]\u0005\u0005\u0003G\tiB\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!a\n\u0010\u0001\u0004\tI#\u0001\u0005u_.,gN\u0015#E!\u0019\tY#!\r\u000265\u0011\u0011Q\u0006\u0006\u0004\u0003_I\u0013a\u0001:eI&!\u00111GA\u0017\u0005\r\u0011F\t\u0012\t\u0005e\u0005]2-C\u0002\u0002:M\u0012Q!\u0011:sCfDq!!\u0010\u0010\u0001\u0004\t)$\u0001\u0004iK\u0006$WM]\u0001\u000fi>\u001cFO];di\u001aKW\r\u001c3t)\u0019\t\u0019%a\u0013\u0002XA)!'a\u000e\u0002FA!\u00111DA$\u0013\u0011\tI%!\b\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0005\b\u0003\u001b\u0002\u0002\u0019AA(\u0003)1\u0017.\u001a7e)f\u0004Xm\u001d\t\u0006e\u0005]\u0012\u0011\u000b\t\u0005\u00037\t\u0019&\u0003\u0003\u0002V\u0005u!\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005u\u0002\u00031\u0001\u00026\u0005a\u0011N\u001c4feJ{w\u000fV=qKR1\u0011qJA/\u0003CBq!a\u0018\u0012\u0001\u0004\ty%\u0001\u0005s_^\u001cvNR1s\u0011\u001d\t\u0019'\u0005a\u0001\u0003k\tAA\\3yi\u0006iQ.\u001a:hKJ{w\u000fV=qKN$b!a\u0014\u0002j\u00055\u0004bBA6%\u0001\u0007\u0011qJ\u0001\u0006M&\u00148\u000f\u001e\u0005\b\u0003_\u0012\u0002\u0019AA(\u0003\u0019\u0019XmY8oI\u0006Q\u0011N\u001c4fe\u001aKW\r\u001c3\u0015\r\u0005E\u0013QOA=\u0011\u001d\t9h\u0005a\u0001\u0003#\n\u0011\u0002^=qKN{g)\u0019:\t\r\u0005m4\u00031\u0001d\u0003\u00151\u0017.\u001a7e\u0003)I7/\u00138g\u001fJt\u0015M\u001c\u000b\u0005\u0003\u001b\t\t\t\u0003\u0004\u0002|Q\u0001\raY\u0001\u0010iJL\b+\u0019:tK&sG/Z4feR!\u0011\u0011KAD\u0011\u0019\tY(\u0006a\u0001G\u0006aAO]=QCJ\u001cX\rT8oOR!\u0011\u0011KAG\u0011\u0019\tYH\u0006a\u0001G\u0006yAO]=QCJ\u001cX\rR3dS6\fG\u000e\u0006\u0003\u0002R\u0005M\u0005BBA>/\u0001\u00071-\u0001\buef\u0004\u0016M]:f\t>,(\r\\3\u0015\t\u0005E\u0013\u0011\u0014\u0005\u0007\u0003wB\u0002\u0019A2\u0002\u0019Q\u0014\u0018\u0010U1sg\u0016$\u0015\r^3\u0015\t\u0005E\u0013q\u0014\u0005\u0007\u0003wJ\u0002\u0019A2\u0002)Q\u0014\u0018\u0010U1sg\u0016$\u0016.\\3ti\u0006l\u0007O\u0014+[)\u0011\t\t&!*\t\r\u0005m$\u00041\u0001d\u0003E!(/\u001f)beN,G+[7fgR\fW\u000e\u001d\u000b\u0005\u0003#\nY\u000b\u0003\u0004\u0002|m\u0001\raY\u0001\u0010iJL\b+\u0019:tK\n{w\u000e\\3b]R!\u0011\u0011KAY\u0011\u0019\tY\b\ba\u0001G\u0006Q1\u000f\u001e:j]\u001e$\u0016\u0010]3\u0015\u0005\u0005E\u0013AD2p[B\fG/\u001b2mKRK\b/\u001a\u000b\u0007\u0003w\u000b\t-!2\u0011\u000bI\ni,!\u0015\n\u0007\u0005}6G\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u0007t\u0002\u0019AA)\u0003\t!\u0018\u0007C\u0004\u0002Hz\u0001\r!!\u0015\u0002\u0005Q\u0014\u0014aF2b]B\u000b'o]3ECR,\u0017i\u001d+j[\u0016\u001cH/Y7q)\u0019\ti!!4\u0002R\"1\u0011qZ\u0010A\u0002\r\f!\u0002Z1uK\u001a{'/\\1u\u0011\u001d\t\u0019n\ba\u0001\u0003#\na\u0001^:UsB,\u0017\u0001\u00074j]\u0012\u001cu.\u001c9bi&\u0014G.\u001a+za\u00164uN]\"T-V\u0011\u0011\u0011\u001c\t\ne\u0005m\u0017\u0011KA)\u0003wK1!!84\u0005%1UO\\2uS>t''A\rgS:$7i\\7qCRL'\r\\3UsB,gi\u001c:D'Z\u0003\u0003")
public class CSVInferSchema
implements Serializable {
    private DateFormatter dateFormatter;
    private final CSVOptions options;
    private final TimestampFormatter timestampParser;
    private final TimestampFormatter timestampNTZFormatter;
    private final Function1<String, BigDecimal> decimalParser;
    private final Set<String> LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS;
    private final boolean isDefaultNTZ;
    private final Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV;
    private volatile boolean bitmap$0;

    public CSVOptions options() {
        return this.options;
    }

    private TimestampFormatter timestampParser() {
        return this.timestampParser;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        CSVInferSchema cSVInferSchema = this;
        synchronized (cSVInferSchema) {
            if (!this.bitmap$0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormatInRead(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = true;
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        if (!this.bitmap$0) {
            return this.dateFormatter$lzycompute();
        }
        return this.dateFormatter;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private Set<String> LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS() {
        return this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS;
    }

    private boolean isDefaultNTZ() {
        return this.isDefaultNTZ;
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header) {
        StructField[] structFieldArray;
        if (this.options().inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2 & Serializable)(rowSoFar, next) -> this.inferRowType((DataType[])rowSoFar, (String[])next), (Function2 & Serializable)(first, second) -> this.mergeRowTypes((DataType[])first, (DataType[])second), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = this.toStructFields(rootTypes, header);
        } else {
            structFieldArray = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])header), (Function1 & Serializable)fieldName -> new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), ClassTag$.MODULE$.apply(StructField.class));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public StructField[] toStructFields(DataType[] fieldTypes, String[] header) {
        return (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])header), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String thisHeader = (String)tuple2._1();
                DataType rootType = (DataType)tuple2._2();
                DataType dataType = rootType;
                StringType$ dType = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
                return new StructField(thisHeader, (DataType)dType, true, StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(StructField.class));
    }

    public DataType[] inferRowType(DataType[] rowSoFar, String[] next) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next[i]);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipAll$extension(Predef$.MODULE$.refArrayOps((Object[])first), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DataType a = (DataType)tuple2._1();
                DataType b = (DataType)tuple2._2();
                return (DataType)this.compatibleType(a, b).getOrElse((Function0 & Serializable)() -> NullType$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(DataType.class));
    }

    public DataType inferField(DataType typeSoFar, String field) {
        DataType dataType;
        block25: {
            block24: {
                if (field == null || field.isEmpty()) break block24;
                String string = field;
                String string2 = this.options().nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block25;
            }
            return typeSoFar;
        }
        DataType dataType2 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseInteger(field);
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseInteger(field);
        } else if (LongType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseLong(field);
        } else if (dataType2 instanceof DecimalType) {
            dataType = this.tryParseDecimal(field);
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseDouble(field);
        } else if (DateType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseDate(field);
        } else if (TimestampNTZType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseTimestampNTZ(field);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseTimestamp(field);
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseBoolean(field);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            dataType = StringType$.MODULE$;
        } else {
            if (dataType2 != null) {
                DataType dataType3 = dataType2;
                throw SparkException$.MODULE$.internalError("Unexpected data type " + dataType3);
            }
            throw new MatchError((Object)dataType2);
        }
        DataType typeElemInfer = dataType;
        return (DataType)this.compatibleType(typeSoFar, typeElemInfer).getOrElse((Function0 & Serializable)() -> StringType$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field) {
        String string = field;
        String string2 = this.options().nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = this.options().negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = this.options().positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(field))).isDefined()) {
            return IntegerType$.MODULE$;
        }
        return this.tryParseLong(field);
    }

    private DataType tryParseLong(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(field))).isDefined()) {
            return LongType$.MODULE$;
        }
        return this.tryParseDecimal(field);
    }

    private DataType tryParseDecimal(String field) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
            BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field);
            if (bigDecimal.scale() <= 0) {
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }
            return this.tryParseDouble(field);
        });
        return (DataType)decimalTry.getOrElse((Function0 & Serializable)() -> this.tryParseDouble(field));
    }

    private DataType tryParseDouble(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(field))).isDefined() || this.isInfOrNan(field)) {
            return DoubleType$.MODULE$;
        }
        if (this.options().preferDate()) {
            return this.tryParseDate(field);
        }
        return this.tryParseTimestampNTZ(field);
    }

    private DataType tryParseDate(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable)() -> this.dateFormatter().parse(field)).isDefined()) {
            return DateType$.MODULE$;
        }
        return this.tryParseTimestampNTZ(field);
    }

    private DataType tryParseTimestampNTZ(String field) {
        if (this.isDefaultNTZ() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined()) {
            return TimestampNTZType$.MODULE$;
        }
        return this.tryParseTimestamp(field);
    }

    private DataType tryParseTimestamp(String field) {
        if (this.timestampParser().parseOptional(field).isDefined()) {
            return TimestampType$.MODULE$;
        }
        return this.tryParseBoolean(field);
    }

    private DataType tryParseBoolean(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(field))).isDefined()) {
            return BooleanType$.MODULE$;
        }
        return this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private Option<DataType> compatibleType(DataType t1, DataType t2) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        var7_3 = new Tuple2((Object)t1, (Object)t2);
                        if (var7_3 == null) break block5;
                        var8_4 = (DataType)var7_3._1();
                        var9_5 = (DataType)var7_3._2();
                        if (!DateType$.MODULE$.equals(var8_4) || !TimestampType$.MODULE$.equals(var9_5)) break block5;
                        v0 = true;
                        break block6;
                    }
                    if (var7_3 == null) break block7;
                    var10_6 = (DataType)var7_3._1();
                    var11_7 = (DataType)var7_3._2();
                    if (!DateType$.MODULE$.equals(var10_6) || !TimestampNTZType$.MODULE$.equals(var11_7)) break block7;
                    v0 = true;
                    break block6;
                }
                if (var7_3 == null) break block8;
                var12_8 = (DataType)var7_3._1();
                var13_9 = (DataType)var7_3._2();
                if (!TimestampNTZType$.MODULE$.equals(var12_8) || !DateType$.MODULE$.equals(var13_9)) break block8;
                v0 = true;
                break block6;
            }
            if (var7_3 == null) ** GOTO lbl-1000
            var14_10 = (DataType)var7_3._1();
            var15_11 = (DataType)var7_3._2();
            if (TimestampType$.MODULE$.equals(var14_10) && DateType$.MODULE$.equals(var15_11)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            dateFormat = (String)this.options().dateFormatInRead().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compatibleType$1(), ()Ljava/lang/String;)());
            var17_13 = t1;
            if (DateType$.MODULE$.equals(var17_13) && this.canParseDateAsTimestamp(dateFormat, t2)) {
                return new Some((Object)t2);
            }
            if ((TimestampType$.MODULE$.equals(var17_13) != false ? true : TimestampNTZType$.MODULE$.equals(var17_13) != false) && this.canParseDateAsTimestamp(dateFormat, t1)) {
                return new Some((Object)t1);
            }
            return new Some((Object)StringType$.MODULE$);
        }
        return ((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compatibleType$2(org.apache.spark.sql.catalyst.csv.CSVInferSchema org.apache.spark.sql.types.DataType org.apache.spark.sql.types.DataType ), ()Lscala/Option;)((CSVInferSchema)this, (DataType)t1, (DataType)t2));
    }

    private boolean canParseDateAsTimestamp(String dateFormat, DataType tsType) {
        if (tsType instanceof TimestampType && this.options().timestampFormatInRead().isEmpty() || tsType instanceof TimestampNTZType && this.options().timestampNTZFormatInRead().isEmpty()) {
            return this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS().contains((Object)dateFormat);
        }
        return false;
    }

    private Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV() {
        return this.findCompatibleTypeForCSV;
    }

    public static final /* synthetic */ String $anonfun$compatibleType$1() {
        return DateFormatter$.MODULE$.defaultPattern();
    }

    public static final /* synthetic */ Option $anonfun$compatibleType$2(CSVInferSchema $this, DataType t1$1, DataType t2$1) {
        return (Option)$this.findCompatibleTypeForCSV().apply((Object)t1$1, (Object)t2$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$findCompatibleTypeForCSV$1(CSVInferSchema $this, DataType x0$1, DataType x1$1) {
        block21: {
            block20: {
                block19: {
                    block18: {
                        var6_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (var6_3 != null && StringType$.MODULE$.equals(var7_4 = (DataType)var6_3._1())) {
                            return new Some((Object)StringType$.MODULE$);
                        }
                        if (var6_3 != null && StringType$.MODULE$.equals(var8_5 = (DataType)var6_3._2())) {
                            return new Some((Object)StringType$.MODULE$);
                        }
                        if (var6_3 != null) {
                            t1 = (DataType)var6_3._1();
                            t2 = (DataType)var6_3._2();
                            if (t1 instanceof IntegralType) {
                                var11_8 = (IntegralType)t1;
                                if (t2 instanceof DecimalType) {
                                    var12_9 = (DecimalType)t2;
                                    return $this.compatibleType((DataType)DecimalType$.MODULE$.forType((DataType)var11_8), (DataType)var12_9);
                                }
                            }
                        }
                        if (var6_3 != null) {
                            t1 = (DataType)var6_3._1();
                            t2 = (DataType)var6_3._2();
                            if (t1 instanceof DecimalType) {
                                var15_12 = (DecimalType)t1;
                                if (t2 instanceof IntegralType) {
                                    var16_13 = (IntegralType)t2;
                                    return $this.compatibleType((DataType)var15_12, (DataType)DecimalType$.MODULE$.forType((DataType)var16_13));
                                }
                            }
                        }
                        if (var6_3 == null || !DoubleType$.MODULE$.equals(var17_14 = (DataType)var6_3._1()) || !(var6_3._2() instanceof DecimalType)) break block18;
                        v0 = true;
                        break block19;
                    }
                    if (var6_3 == null) ** GOTO lbl-1000
                    var18_15 = (DataType)var6_3._2();
                    if (var6_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var18_15)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                if (v0) {
                    return new Some((Object)DoubleType$.MODULE$);
                }
                if (var6_3 != null) {
                    t1 = (DataType)var6_3._1();
                    t2 = (DataType)var6_3._2();
                    if (t1 instanceof DecimalType) {
                        var21_18 = (DecimalType)t1;
                        if (t2 instanceof DecimalType) {
                            var22_19 = (DecimalType)t2;
                            scale = package$.MODULE$.max(var21_18.scale(), var22_19.scale());
                            range = package$.MODULE$.max(var21_18.precision() - var21_18.scale(), var22_19.precision() - var22_19.scale());
                            if (range + scale > 38) {
                                return new Some((Object)DoubleType$.MODULE$);
                            }
                            return new Some((Object)new DecimalType(range + scale, scale));
                        }
                    }
                }
                if (var6_3 == null) break block20;
                var25_22 = (DataType)var6_3._1();
                var26_23 = (DataType)var6_3._2();
                if (!TimestampNTZType$.MODULE$.equals(var25_22) || !TimestampType$.MODULE$.equals(var26_23)) break block20;
                v1 = true;
                break block21;
            }
            if (var6_3 == null) ** GOTO lbl-1000
            var27_24 = (DataType)var6_3._1();
            var28_25 = (DataType)var6_3._2();
            if (TimestampType$.MODULE$.equals(var27_24) && TimestampNTZType$.MODULE$.equals(var28_25)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v1) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        return None$.MODULE$;
    }

    public CSVInferSchema(CSVOptions options) {
        this.options = options;
        this.timestampParser = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        Locale locale = options.locale();
        Locale locale2 = Locale.US;
        this.decimalParser = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? s -> new BigDecimal((String)s) : ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd", "yyyy-M-d", "yyyy-M-dd", "yyyy-MM-d", "yyyy-MM", "yyyy-M", "yyyy"}));
        AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        this.isDefaultNTZ = !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
        this.findCompatibleTypeForCSV = (arg_0, arg_1) -> CSVInferSchema.$anonfun$findCompatibleTypeForCSV$1(this, arg_0, arg_1);
    }
}

