/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterBuilder;
import io.fabric8.kubernetes.api.model.NamedClusterFluent;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluent;
import io.fabric8.kubernetes.api.model.Preferences;
import io.fabric8.kubernetes.api.model.PreferencesBuilder;
import io.fabric8.kubernetes.api.model.PreferencesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConfigFluent<A extends ConfigFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<NamedClusterBuilder> clusters = new ArrayList();
    private ArrayList<NamedContextBuilder> contexts = new ArrayList();
    private String currentContext;
    private ArrayList<NamedExtensionBuilder> extensions = new ArrayList();
    private String kind;
    private PreferencesBuilder preferences;
    private ArrayList<NamedAuthInfoBuilder> users = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ConfigFluent() {
    }

    public ConfigFluent(Config instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Config instance) {
        Config config = instance = instance != null ? instance : new Config();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withClusters(instance.getClusters());
            this.withContexts(instance.getContexts());
            this.withCurrentContext(instance.getCurrentContext());
            this.withExtensions(instance.getExtensions());
            this.withKind(instance.getKind());
            this.withPreferences(instance.getPreferences());
            this.withUsers(instance.getUsers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToClusters(int index, NamedCluster item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        NamedClusterBuilder builder = new NamedClusterBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").add(index, builder);
            this.clusters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusters(int index, NamedCluster item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        NamedClusterBuilder builder = new NamedClusterBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").set(index, builder);
            this.clusters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusters(NamedCluster ... items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusters(Collection<NamedCluster> items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusters(NamedCluster ... items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusters(Collection<NamedCluster> items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusters(Predicate<NamedClusterBuilder> predicate) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        Iterator<NamedClusterBuilder> each = this.clusters.iterator();
        List visitables = this._visitables.get((Object)"clusters");
        while (each.hasNext()) {
            NamedClusterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NamedCluster> buildClusters() {
        return this.clusters != null ? ConfigFluent.build(this.clusters) : null;
    }

    public NamedCluster buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    public NamedCluster buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    public NamedCluster buildLastCluster() {
        return this.clusters.get(this.clusters.size() - 1).build();
    }

    public NamedCluster buildMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
        for (NamedClusterBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
        for (NamedClusterBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusters(List<NamedCluster> clusters) {
        if (this.clusters != null) {
            this._visitables.get((Object)"clusters").clear();
        }
        if (clusters != null) {
            this.clusters = new ArrayList();
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        } else {
            this.clusters = null;
        }
        return (A)((Object)this);
    }

    public A withClusters(NamedCluster ... clusters) {
        if (this.clusters != null) {
            this.clusters.clear();
            this._visitables.remove((Object)"clusters");
        }
        if (clusters != null) {
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusters() {
        return this.clusters != null && !this.clusters.isEmpty();
    }

    public ClustersNested<A> addNewCluster() {
        return new ClustersNested(-1, null);
    }

    public ClustersNested<A> addNewClusterLike(NamedCluster item) {
        return new ClustersNested(-1, item);
    }

    public ClustersNested<A> setNewClusterLike(int index, NamedCluster item) {
        return new ClustersNested(index, item);
    }

    public ClustersNested<A> editCluster(int index) {
        if (this.clusters.size() <= index) {
            throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editFirstCluster() {
        if (this.clusters.size() == 0) {
            throw new RuntimeException("Can't edit first clusters. The list is empty.");
        }
        return this.setNewClusterLike(0, this.buildCluster(0));
    }

    public ClustersNested<A> editLastCluster() {
        int index = this.clusters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusters. The list is empty.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!predicate.test(this.clusters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusters. No match found.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public A addToContexts(int index, NamedContext item) {
        if (this.contexts == null) {
            this.contexts = new ArrayList();
        }
        NamedContextBuilder builder = new NamedContextBuilder(item);
        if (index < 0 || index >= this.contexts.size()) {
            this._visitables.get((Object)"contexts").add(builder);
            this.contexts.add(builder);
        } else {
            this._visitables.get((Object)"contexts").add(index, builder);
            this.contexts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContexts(int index, NamedContext item) {
        if (this.contexts == null) {
            this.contexts = new ArrayList();
        }
        NamedContextBuilder builder = new NamedContextBuilder(item);
        if (index < 0 || index >= this.contexts.size()) {
            this._visitables.get((Object)"contexts").add(builder);
            this.contexts.add(builder);
        } else {
            this._visitables.get((Object)"contexts").set(index, builder);
            this.contexts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContexts(NamedContext ... items) {
        if (this.contexts == null) {
            this.contexts = new ArrayList();
        }
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.get((Object)"contexts").add(builder);
            this.contexts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContexts(Collection<NamedContext> items) {
        if (this.contexts == null) {
            this.contexts = new ArrayList();
        }
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.get((Object)"contexts").add(builder);
            this.contexts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContexts(NamedContext ... items) {
        if (this.contexts == null) {
            return (A)((Object)this);
        }
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.get((Object)"contexts").remove((Object)builder);
            this.contexts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContexts(Collection<NamedContext> items) {
        if (this.contexts == null) {
            return (A)((Object)this);
        }
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.get((Object)"contexts").remove((Object)builder);
            this.contexts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContexts(Predicate<NamedContextBuilder> predicate) {
        if (this.contexts == null) {
            return (A)((Object)this);
        }
        Iterator<NamedContextBuilder> each = this.contexts.iterator();
        List visitables = this._visitables.get((Object)"contexts");
        while (each.hasNext()) {
            NamedContextBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NamedContext> buildContexts() {
        return this.contexts != null ? ConfigFluent.build(this.contexts) : null;
    }

    public NamedContext buildContext(int index) {
        return this.contexts.get(index).build();
    }

    public NamedContext buildFirstContext() {
        return this.contexts.get(0).build();
    }

    public NamedContext buildLastContext() {
        return this.contexts.get(this.contexts.size() - 1).build();
    }

    public NamedContext buildMatchingContext(Predicate<NamedContextBuilder> predicate) {
        for (NamedContextBuilder item : this.contexts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContext(Predicate<NamedContextBuilder> predicate) {
        for (NamedContextBuilder item : this.contexts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContexts(List<NamedContext> contexts) {
        if (this.contexts != null) {
            this._visitables.get((Object)"contexts").clear();
        }
        if (contexts != null) {
            this.contexts = new ArrayList();
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        } else {
            this.contexts = null;
        }
        return (A)((Object)this);
    }

    public A withContexts(NamedContext ... contexts) {
        if (this.contexts != null) {
            this.contexts.clear();
            this._visitables.remove((Object)"contexts");
        }
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContexts() {
        return this.contexts != null && !this.contexts.isEmpty();
    }

    public ContextsNested<A> addNewContext() {
        return new ContextsNested(-1, null);
    }

    public ContextsNested<A> addNewContextLike(NamedContext item) {
        return new ContextsNested(-1, item);
    }

    public ContextsNested<A> setNewContextLike(int index, NamedContext item) {
        return new ContextsNested(index, item);
    }

    public ContextsNested<A> editContext(int index) {
        if (this.contexts.size() <= index) {
            throw new RuntimeException("Can't edit contexts. Index exceeds size.");
        }
        return this.setNewContextLike(index, this.buildContext(index));
    }

    public ContextsNested<A> editFirstContext() {
        if (this.contexts.size() == 0) {
            throw new RuntimeException("Can't edit first contexts. The list is empty.");
        }
        return this.setNewContextLike(0, this.buildContext(0));
    }

    public ContextsNested<A> editLastContext() {
        int index = this.contexts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last contexts. The list is empty.");
        }
        return this.setNewContextLike(index, this.buildContext(index));
    }

    public ContextsNested<A> editMatchingContext(Predicate<NamedContextBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.contexts.size(); ++i) {
            if (!predicate.test(this.contexts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching contexts. No match found.");
        }
        return this.setNewContextLike(index, this.buildContext(index));
    }

    public String getCurrentContext() {
        return this.currentContext;
    }

    public A withCurrentContext(String currentContext) {
        this.currentContext = currentContext;
        return (A)((Object)this);
    }

    public boolean hasCurrentContext() {
        return this.currentContext != null;
    }

    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get((Object)"extensions").add(index, builder);
            this.extensions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get((Object)"extensions").set(index, builder);
            this.extensions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").remove((Object)builder);
            this.extensions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").remove((Object)builder);
            this.extensions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        Iterator<NamedExtensionBuilder> each = this.extensions.iterator();
        List visitables = this._visitables.get((Object)"extensions");
        while (each.hasNext()) {
            NamedExtensionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NamedExtension> buildExtensions() {
        return this.extensions != null ? ConfigFluent.build(this.extensions) : null;
    }

    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get((Object)"extensions").clear();
        }
        if (extensions != null) {
            this.extensions = new ArrayList();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)((Object)this);
    }

    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
            this._visitables.remove((Object)"extensions");
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public A addNewExtension(Object extension, String name) {
        return this.addToExtensions(new NamedExtension(extension, name));
    }

    public ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNested(-1, null);
    }

    public ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNested(-1, item);
    }

    public ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNested(index, item);
    }

    public ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    public ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.test(this.extensions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public Preferences buildPreferences() {
        return this.preferences != null ? this.preferences.build() : null;
    }

    public A withPreferences(Preferences preferences) {
        this._visitables.remove((Object)"preferences");
        if (preferences != null) {
            this.preferences = new PreferencesBuilder(preferences);
            this._visitables.get((Object)"preferences").add(this.preferences);
        } else {
            this.preferences = null;
            this._visitables.get((Object)"preferences").remove((Object)this.preferences);
        }
        return (A)((Object)this);
    }

    public boolean hasPreferences() {
        return this.preferences != null;
    }

    public PreferencesNested<A> withNewPreferences() {
        return new PreferencesNested(null);
    }

    public PreferencesNested<A> withNewPreferencesLike(Preferences item) {
        return new PreferencesNested(item);
    }

    public PreferencesNested<A> editPreferences() {
        return this.withNewPreferencesLike(Optional.ofNullable(this.buildPreferences()).orElse(null));
    }

    public PreferencesNested<A> editOrNewPreferences() {
        return this.withNewPreferencesLike(Optional.ofNullable(this.buildPreferences()).orElse(new PreferencesBuilder().build()));
    }

    public PreferencesNested<A> editOrNewPreferencesLike(Preferences item) {
        return this.withNewPreferencesLike(Optional.ofNullable(this.buildPreferences()).orElse(item));
    }

    public A addToUsers(int index, NamedAuthInfo item) {
        if (this.users == null) {
            this.users = new ArrayList();
        }
        NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
        if (index < 0 || index >= this.users.size()) {
            this._visitables.get((Object)"users").add(builder);
            this.users.add(builder);
        } else {
            this._visitables.get((Object)"users").add(index, builder);
            this.users.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToUsers(int index, NamedAuthInfo item) {
        if (this.users == null) {
            this.users = new ArrayList();
        }
        NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
        if (index < 0 || index >= this.users.size()) {
            this._visitables.get((Object)"users").add(builder);
            this.users.add(builder);
        } else {
            this._visitables.get((Object)"users").set(index, builder);
            this.users.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToUsers(NamedAuthInfo ... items) {
        if (this.users == null) {
            this.users = new ArrayList();
        }
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.get((Object)"users").add(builder);
            this.users.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToUsers(Collection<NamedAuthInfo> items) {
        if (this.users == null) {
            this.users = new ArrayList();
        }
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.get((Object)"users").add(builder);
            this.users.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromUsers(NamedAuthInfo ... items) {
        if (this.users == null) {
            return (A)((Object)this);
        }
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.get((Object)"users").remove((Object)builder);
            this.users.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUsers(Collection<NamedAuthInfo> items) {
        if (this.users == null) {
            return (A)((Object)this);
        }
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.get((Object)"users").remove((Object)builder);
            this.users.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromUsers(Predicate<NamedAuthInfoBuilder> predicate) {
        if (this.users == null) {
            return (A)((Object)this);
        }
        Iterator<NamedAuthInfoBuilder> each = this.users.iterator();
        List visitables = this._visitables.get((Object)"users");
        while (each.hasNext()) {
            NamedAuthInfoBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NamedAuthInfo> buildUsers() {
        return this.users != null ? ConfigFluent.build(this.users) : null;
    }

    public NamedAuthInfo buildUser(int index) {
        return this.users.get(index).build();
    }

    public NamedAuthInfo buildFirstUser() {
        return this.users.get(0).build();
    }

    public NamedAuthInfo buildLastUser() {
        return this.users.get(this.users.size() - 1).build();
    }

    public NamedAuthInfo buildMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
        for (NamedAuthInfoBuilder item : this.users) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
        for (NamedAuthInfoBuilder item : this.users) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUsers(List<NamedAuthInfo> users) {
        if (this.users != null) {
            this._visitables.get((Object)"users").clear();
        }
        if (users != null) {
            this.users = new ArrayList();
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        } else {
            this.users = null;
        }
        return (A)((Object)this);
    }

    public A withUsers(NamedAuthInfo ... users) {
        if (this.users != null) {
            this.users.clear();
            this._visitables.remove((Object)"users");
        }
        if (users != null) {
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    public UsersNested<A> addNewUser() {
        return new UsersNested(-1, null);
    }

    public UsersNested<A> addNewUserLike(NamedAuthInfo item) {
        return new UsersNested(-1, item);
    }

    public UsersNested<A> setNewUserLike(int index, NamedAuthInfo item) {
        return new UsersNested(index, item);
    }

    public UsersNested<A> editUser(int index) {
        if (this.users.size() <= index) {
            throw new RuntimeException("Can't edit users. Index exceeds size.");
        }
        return this.setNewUserLike(index, this.buildUser(index));
    }

    public UsersNested<A> editFirstUser() {
        if (this.users.size() == 0) {
            throw new RuntimeException("Can't edit first users. The list is empty.");
        }
        return this.setNewUserLike(0, this.buildUser(0));
    }

    public UsersNested<A> editLastUser() {
        int index = this.users.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last users. The list is empty.");
        }
        return this.setNewUserLike(index, this.buildUser(index));
    }

    public UsersNested<A> editMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.users.size(); ++i) {
            if (!predicate.test(this.users.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching users. No match found.");
        }
        return this.setNewUserLike(index, this.buildUser(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigFluent that = (ConfigFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.clusters, that.clusters)) {
            return false;
        }
        if (!Objects.equals(this.contexts, that.contexts)) {
            return false;
        }
        if (!Objects.equals(this.currentContext, that.currentContext)) {
            return false;
        }
        if (!Objects.equals(this.extensions, that.extensions)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals((Object)this.preferences, (Object)that.preferences)) {
            return false;
        }
        if (!Objects.equals(this.users, that.users)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.clusters, this.contexts, this.currentContext, this.extensions, this.kind, this.preferences, this.users, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.clusters != null && !this.clusters.isEmpty()) {
            sb.append("clusters:");
            sb.append(this.clusters + ",");
        }
        if (this.contexts != null && !this.contexts.isEmpty()) {
            sb.append("contexts:");
            sb.append(this.contexts + ",");
        }
        if (this.currentContext != null) {
            sb.append("currentContext:");
            sb.append(this.currentContext + ",");
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            sb.append("extensions:");
            sb.append(this.extensions + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.preferences != null) {
            sb.append("preferences:");
            sb.append(this.preferences + ",");
        }
        if (this.users != null && !this.users.isEmpty()) {
            sb.append("users:");
            sb.append(this.users + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UsersNested<N>
    extends NamedAuthInfoFluent<UsersNested<N>>
    implements Nested<N> {
        NamedAuthInfoBuilder builder;
        int index;

        UsersNested(int index, NamedAuthInfo item) {
            this.index = index;
            this.builder = new NamedAuthInfoBuilder(this, item);
        }

        public N and() {
            return (N)ConfigFluent.this.setToUsers(this.index, this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }

    public class PreferencesNested<N>
    extends PreferencesFluent<PreferencesNested<N>>
    implements Nested<N> {
        PreferencesBuilder builder;

        PreferencesNested(Preferences item) {
            this.builder = new PreferencesBuilder(this, item);
        }

        public N and() {
            return (N)ConfigFluent.this.withPreferences(this.builder.build());
        }

        public N endPreferences() {
            return this.and();
        }
    }

    public class ExtensionsNested<N>
    extends NamedExtensionFluent<ExtensionsNested<N>>
    implements Nested<N> {
        NamedExtensionBuilder builder;
        int index;

        ExtensionsNested(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        public N and() {
            return (N)ConfigFluent.this.setToExtensions(this.index, this.builder.build());
        }

        public N endExtension() {
            return this.and();
        }
    }

    public class ContextsNested<N>
    extends NamedContextFluent<ContextsNested<N>>
    implements Nested<N> {
        NamedContextBuilder builder;
        int index;

        ContextsNested(int index, NamedContext item) {
            this.index = index;
            this.builder = new NamedContextBuilder(this, item);
        }

        public N and() {
            return (N)ConfigFluent.this.setToContexts(this.index, this.builder.build());
        }

        public N endContext() {
            return this.and();
        }
    }

    public class ClustersNested<N>
    extends NamedClusterFluent<ClustersNested<N>>
    implements Nested<N> {
        NamedClusterBuilder builder;
        int index;

        ClustersNested(int index, NamedCluster item) {
            this.index = index;
            this.builder = new NamedClusterBuilder(this, item);
        }

        public N and() {
            return (N)ConfigFluent.this.setToClusters(this.index, this.builder.build());
        }

        public N endCluster() {
            return this.and();
        }
    }
}

