/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.startup.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.sling.starter.startup.impl.StartupFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.context.ServletContextHelper;

public class HttpStartupSetup {
    private static final String CONTEXT_NAME = "internal.sling.setup";
    private volatile ServiceRegistration<ServletContextHelper> httpContextRegistration;
    private volatile ServiceRegistration<Servlet> defaultServletRegistration;
    private volatile ServiceRegistration<Filter> startupFilterRegistration;
    private final BundleContext context;

    HttpStartupSetup(BundleContext context) {
        this.context = context;
    }

    public void start() {
        this.registerHttpContext();
        this.registerStartupFilter();
    }

    public void stop() {
        this.unregisterStartupFilter();
        this.unregisterHttpContext();
    }

    private void registerHttpContext() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.http.whiteboard.context.name", CONTEXT_NAME);
        ((Dictionary)properties).put("osgi.http.whiteboard.context.path", "/");
        ((Dictionary)properties).put("service.ranking", Integer.MAX_VALUE);
        this.httpContextRegistration = this.context.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, properties);
        Hashtable<String, String> servletProps = new Hashtable<String, String>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=internal.sling.setup)");
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/");
        this.defaultServletRegistration = this.context.registerService(Servlet.class, (Object)new HttpServlet(){
            private static final long serialVersionUID = 1L;
        }, servletProps);
    }

    private void unregisterHttpContext() {
        if (this.defaultServletRegistration != null) {
            this.defaultServletRegistration.unregister();
            this.defaultServletRegistration = null;
        }
        if (this.httpContextRegistration != null) {
            this.httpContextRegistration.unregister();
            this.httpContextRegistration = null;
        }
    }

    private void registerStartupFilter() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=internal.sling.setup)");
        ((Dictionary)properties).put("osgi.http.whiteboard.filter.pattern", "/");
        ((Dictionary)properties).put("service.ranking", Integer.MAX_VALUE);
        this.startupFilterRegistration = this.context.registerService(Filter.class, (Object)new StartupFilter(), properties);
    }

    private void unregisterStartupFilter() {
        if (this.startupFilterRegistration != null) {
            this.startupFilterRegistration.unregister();
            this.startupFilterRegistration = null;
        }
    }
}

