/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.bundle;

import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.type.ResourceType;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.apache.sling.scripting.spi.bundle.TypeProvider;
import org.apache.sling.servlets.resolver.internal.bundle.RequestWrapper;
import org.jetbrains.annotations.NotNull;

public class BundledScriptServlet
extends GenericServlet {
    private static final long serialVersionUID = 6320375093932073555L;
    private final BundledRenderUnit executable;
    private final String servletInfo;
    private final Set<ResourceType> types;

    public BundledScriptServlet(@NotNull Set<TypeProvider> wiredTypeProviders, @NotNull BundledRenderUnit executable) {
        this.executable = executable;
        this.servletInfo = "Script " + executable.getPath();
        this.types = wiredTypeProviders.stream().map(typeProvider -> typeProvider.getBundledRenderUnitCapability().getResourceTypes()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String getServletInfo() {
        return this.servletInfo;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (req instanceof SlingJakartaHttpServletRequest && res instanceof SlingJakartaHttpServletResponse) {
            String contentType;
            SlingJakartaHttpServletRequest request = (SlingJakartaHttpServletRequest)req;
            SlingJakartaHttpServletResponse response = (SlingJakartaHttpServletResponse)res;
            if (request.getAttribute("jakarta.servlet.include.servlet_path") == null && (contentType = request.getResponseContentType()) != null) {
                response.setContentType(contentType);
                if (contentType.startsWith("text/")) {
                    response.setCharacterEncoding("UTF-8");
                }
            }
            RequestWrapper requestWrapper = new RequestWrapper(request, this.types);
            try {
                this.executable.eval((HttpServletRequest)requestWrapper, (HttpServletResponse)response);
            }
            catch (RuntimeException see) {
                this.logScriptError(request, see);
                throw see;
            }
            catch (Exception e) {
                this.logScriptError(request, e);
                throw new SlingException("Cannot get DefaultSlingScript: " + e.getMessage(), (Throwable)e);
            }
        } else {
            throw new ServletException("Not a Sling HTTP request/response");
        }
    }

    private void logScriptError(SlingJakartaHttpServletRequest request, Throwable throwable) {
        String message = throwable.getMessage();
        message = message != null ? throwable.getMessage().replace('\n', '/') : throwable.toString();
        request.getRequestProgressTracker().log("SCRIPT ERROR: {0}", new Object[]{message});
    }

    @NotNull
    public BundledRenderUnit getBundledRenderUnit() {
        return this.executable;
    }

    public InputStream getInputStream() {
        return this.executable.getInputStream();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.executable.getPath() + ")";
    }
}

