/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonResourceWriter {
    private static DateFormat calendarFormat;
    private final Set<String> propertyNamesToIgnore;
    public static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    public static final Locale DATE_FORMAT_LOCALE;

    public JsonResourceWriter(Set<String> propertyNamesToIgnore) {
        this.propertyNamesToIgnore = propertyNamesToIgnore;
    }

    public void dump(Resource resource, Writer w, int maxRecursionLevels) throws JSONException {
        this.dump(resource, w, maxRecursionLevels, false);
    }

    public void dump(Resource resource, Writer w, int maxRecursionLevels, boolean tidy) throws JSONException {
        JSONWriter jw = new JSONWriter(w);
        jw.setTidy(tidy);
        this.dump(resource, jw, 0, maxRecursionLevels);
    }

    protected void dump(Resource resource, JSONWriter w, int currentRecursionLevel, int maxRecursionLevels) throws JSONException {
        block5: {
            ValueMap propertyMap;
            ValueMap valueMap;
            block3: {
                block4: {
                    valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
                    propertyMap = valueMap != null ? valueMap : (Map)resource.adaptTo(Map.class);
                    w.object();
                    if (propertyMap != null) break block3;
                    String value = (String)resource.adaptTo(String.class);
                    if (value == null) break block4;
                    w.key(ResourceUtil.getName((Resource)resource));
                    w.value((Object)value);
                    break block5;
                }
                String[] values = (String[])resource.adaptTo(String[].class);
                if (values == null) break block5;
                w.key(ResourceUtil.getName((Resource)resource));
                w.value((Object)new JSONArray(Arrays.asList(values)));
                break block5;
            }
            for (Map.Entry prop : propertyMap.entrySet()) {
                if (this.propertyNamesToIgnore != null && this.propertyNamesToIgnore.contains(prop.getKey())) continue;
                this.writeProperty(w, valueMap, prop.getKey().toString(), prop.getValue());
            }
        }
        if (this.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
            Iterator children = ResourceUtil.listChildren((Resource)resource);
            while (children.hasNext()) {
                Resource n = (Resource)children.next();
                this.dumpSingleResource(n, w, currentRecursionLevel, maxRecursionLevels);
            }
        }
        w.endObject();
    }

    public void dumpProperties(Resource resource, JSONWriter w, List<String> properties) throws JSONException {
        ValueMap propertyMap;
        ValueMap valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
        Object object = propertyMap = valueMap != null ? valueMap : (Map)resource.adaptTo(Map.class);
        if (propertyMap == null) {
            return;
        }
        for (Map.Entry prop : propertyMap.entrySet()) {
            if (this.propertyNamesToIgnore != null && this.propertyNamesToIgnore.contains(prop.getKey()) || !properties.contains(prop.getKey().toString())) continue;
            this.writeProperty(w, valueMap, prop.getKey().toString(), prop.getValue());
        }
    }

    public void dumpValue(JSONWriter w, Object value) throws JSONException {
        if (value instanceof InputStream) {
            w.value(0L);
        } else if (value instanceof Calendar) {
            w.value((Object)JsonResourceWriter.format((Calendar)value));
        } else if (value instanceof Boolean) {
            w.value(((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            w.value(((Long)value).longValue());
        } else if (value instanceof Integer) {
            w.value(((Integer)value).longValue());
        } else if (value instanceof Double) {
            w.value(((Double)value).doubleValue());
        } else {
            w.value((Object)value.toString());
        }
    }

    protected void dumpSingleResource(Resource n, JSONWriter w, int currentRecursionLevel, int maxRecursionLevels) throws JSONException {
        if (this.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
            w.key(ResourceUtil.getName((Resource)n));
            this.dump(n, w, currentRecursionLevel + 1, maxRecursionLevels);
        }
    }

    protected boolean recursionLevelActive(int currentRecursionLevel, int maxRecursionLevels) {
        return maxRecursionLevels < 0 || currentRecursionLevel < maxRecursionLevels;
    }

    protected void writeProperty(JSONWriter w, ValueMap valueMap, String key, Object value) throws JSONException {
        Object[] values = null;
        if (value.getClass().isArray() && (values = (Object[])value).length == 0) {
            w.key(key);
            w.array();
            w.endArray();
            return;
        }
        if (value instanceof InputStream || values != null && values[0] instanceof InputStream) {
            w.key(":" + key);
            if (values == null) {
                this.writeLength(w, valueMap, -1, key, (InputStream)value);
            } else {
                w.array();
                for (int i = 0; i < values.length; ++i) {
                    this.writeLength(w, valueMap, i, key, (InputStream)values[i]);
                }
                w.endArray();
            }
            return;
        }
        w.key(key);
        if (!value.getClass().isArray()) {
            this.dumpValue(w, value);
        } else {
            w.array();
            for (Object v : values) {
                this.dumpValue(w, v);
            }
            w.endArray();
        }
    }

    private void writeLength(JSONWriter w, ValueMap valueMap, int index, String key, InputStream stream) throws JSONException {
        try {
            stream.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        long length = -1L;
        if (valueMap != null) {
            if (index == -1) {
                length = (Long)valueMap.get(key, (Object)length);
            } else {
                Long[] lengths = (Long[])valueMap.get(key, Long[].class);
                if (lengths != null && lengths.length > index) {
                    length = lengths[index];
                }
            }
        }
        w.value(length);
    }

    public static synchronized String format(Calendar date) {
        if (calendarFormat == null) {
            calendarFormat = new SimpleDateFormat(ECMA_DATE_FORMAT, DATE_FORMAT_LOCALE);
        }
        return calendarFormat.format(date.getTime());
    }

    static {
        DATE_FORMAT_LOCALE = Locale.US;
    }
}

