/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.collection.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.collection.ResourceCollection;
import org.apache.sling.resource.collection.ResourceCollectionManager;
import org.apache.sling.resource.collection.impl.ResourceCollectionImpl;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceCollectionManager.class}, property={"service.vendor=The Apache Software Foundation"})
public class ResourceCollectionManagerImpl
implements ResourceCollectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public ResourceCollection getCollection(Resource resource) {
        if (resource != null) {
            if (resource.isResourceType("sling/collection")) {
                return new ResourceCollectionImpl(resource);
            }
        } else {
            throw new IllegalArgumentException("resource can not be null");
        }
        return null;
    }

    @Override
    public ResourceCollection createCollection(Resource parentResource, String name) throws PersistenceException {
        return this.createCollection(parentResource, name, null);
    }

    @Override
    public ResourceCollection createCollection(Resource parentResource, String name, Map<String, Object> properties) throws PersistenceException {
        if (parentResource != null) {
            String fullPath = parentResource.getPath() + "/" + name;
            if (parentResource.getResourceResolver().getResource(fullPath) != null) {
                throw new IllegalArgumentException("invalid path, " + fullPath + "resource already exists");
            }
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            if (properties.get("sling:resourceType") != null && !"sling/collection".equals(properties.get("sling:resourceType"))) {
                properties.put("sling:resourceSuperType", "sling/collection");
            } else {
                properties.put("sling:resourceType", "sling/collection");
            }
            Resource collectionRes = parentResource.getResourceResolver().create(parentResource, name, properties);
            parentResource.getResourceResolver().create(collectionRes, "sling:members", null);
            this.log.debug("collection  {} created", (Object)fullPath);
            return new ResourceCollectionImpl(collectionRes);
        }
        this.log.error("parent resource can not be null");
        throw new IllegalArgumentException("parent resource can not be null ");
    }

    @Override
    public boolean deleteCollection(Resource resource) throws PersistenceException {
        if (resource != null) {
            this.log.debug("collection  {} deleted", (Object)resource.getPath());
            resource.getResourceResolver().delete(resource);
            return true;
        }
        throw new IllegalArgumentException("resource can not be null");
    }
}

