/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.installer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchpadConfigInstaller {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final String ROOT_PATH = "resources";
    private static final String CONFIG_NAME = "config";
    private static final String INSTALL_NAME = "install";
    private static final String INSTALL_PREFIX = "install.";
    private static final Integer PRIORITY = new Integer(50);
    private static final int PRIORITY_BOOST = 5;
    private final LaunchpadContentProvider resourceProvider;
    private final Set<String> activeRunModes;
    private final Collection<InstallableResource> installables = new HashSet<InstallableResource>();

    private boolean checkPath(String rootPath, String resourceType, Integer prio) {
        int count = 0;
        Iterator configPaths = this.resourceProvider.getChildren(rootPath);
        if (configPaths != null) {
            int hintPos = rootPath.lastIndexOf(47);
            String hint = rootPath.substring(hintPos + 1);
            while (configPaths.hasNext()) {
                String path = (String)configPaths.next();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (this.checkPath(path, resourceType, prio)) continue;
                ++count;
                URL url = this.resourceProvider.getResource(path);
                if (url == null) {
                    this.logger.debug("Launchpad ignoring path '{}' due to null URL", (Object)path);
                    continue;
                }
                Hashtable<String, String> dict = null;
                if ("file".equals(resourceType)) {
                    dict = new Hashtable<String, String>();
                    if (!hint.startsWith(INSTALL_NAME)) {
                        ((Dictionary)dict).put("installation.hint", hint);
                    }
                    try {
                        ((Dictionary)dict).put("resource.uri.hint", url.toURI().toString());
                    }
                    catch (URISyntaxException e) {}
                } else if (!hint.equals(CONFIG_NAME)) {
                    int activeModes = this.isActive(hint);
                    if (activeModes == 0) {
                        this.logger.debug("Launchpad ignoring {} : {} due to unactivated run mode: {}", new Object[]{resourceType, path, hint});
                        continue;
                    }
                    prio = PRIORITY + 5 * activeModes;
                }
                long lastModified = -1L;
                try {
                    lastModified = url.openConnection().getLastModified();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.logger.debug("Launchpad {} will be registered: {}", (Object)resourceType, (Object)path);
                String digest = lastModified > 0L ? String.valueOf(lastModified) : null;
                InputStream stream = this.resourceProvider.getResourceAsStream(path);
                this.installables.add(new InstallableResource(path, stream, dict, digest, resourceType, prio));
            }
        }
        return count > 0;
    }

    private int isActive(String runModesString) {
        String[] runModes = runModesString.split("\\.");
        boolean active = true;
        for (String mode : runModes) {
            if (this.activeRunModes.contains(mode)) continue;
            active = false;
            break;
        }
        return active ? runModes.length : 0;
    }

    public static void install(OsgiInstaller installer, LaunchpadContentProvider resourceProvider, Set<String> activeRunModes) {
        new LaunchpadConfigInstaller(resourceProvider, activeRunModes).install(installer);
    }

    private LaunchpadConfigInstaller(LaunchpadContentProvider resourceProvider, Set<String> activeRunModes) {
        this.resourceProvider = resourceProvider;
        this.activeRunModes = activeRunModes;
    }

    private void install(OsgiInstaller installer) {
        this.logger.info("Activating launchpad config installer, configuration path={}/{}, install path={}/{}", new Object[]{ROOT_PATH, CONFIG_NAME, ROOT_PATH, INSTALL_NAME});
        Iterator configPaths = this.resourceProvider.getChildren(ROOT_PATH);
        if (configPaths != null) {
            while (configPaths.hasNext()) {
                int namePos;
                String name;
                String path = (String)configPaths.next();
                this.logger.debug("Found launchpad resource {}", (Object)path);
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((name = path.substring((namePos = path.lastIndexOf(47)) + 1)).equals(CONFIG_NAME)) {
                    this.checkPath(path, "properties", PRIORITY);
                    continue;
                }
                if (name.equals(INSTALL_NAME)) {
                    this.checkPath(path, "file", PRIORITY);
                    continue;
                }
                if (name.startsWith(INSTALL_PREFIX)) {
                    int activeModes = this.isActive(name.substring(INSTALL_PREFIX.length()));
                    if (activeModes > 0) {
                        int prio = PRIORITY + 5 * activeModes;
                        this.checkPath(path, "file", prio);
                        continue;
                    }
                    this.logger.debug("Ignoring path {} due to unactivated run mode: {}", (Object)path, (Object)name.substring(INSTALL_PREFIX.length()));
                    continue;
                }
                this.logger.debug("Ignoring path {} - not an installation path", (Object)path);
            }
        } else {
            this.logger.warn("Run mode dependent installation not supported by launchpad content provider {}", (Object)this.resourceProvider);
            this.checkPath("resources/config", "properties", PRIORITY);
            this.checkPath("resources/install", "file", PRIORITY);
        }
        InstallableResource[] toInstall = this.installables.toArray(new InstallableResource[0]);
        installer.registerResources("launchpad", toInstall);
        this.logger.info("{} resources registered with OsgiInstaller", (Object)toInstall.length);
    }
}

