/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl.security;

import java.io.IOException;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.jackrabbit.core.security.authentication.CredentialsCallback;
import org.apache.jackrabbit.core.security.authentication.ImpersonationCallback;
import org.apache.sling.jcr.jackrabbit.server.impl.security.TrustedCredentials;

public class CallbackHandlerWrapper
implements CallbackHandler {
    private CallbackHandler callbackHandler;

    public CallbackHandlerWrapper(Subject subject, CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            Credentials creds;
            if (cb instanceof NameCallback) {
                creds = this.getCredentials();
                NameCallback nameCallback = (NameCallback)cb;
                if (!(creds instanceof TrustedCredentials)) continue;
                nameCallback.setName(((TrustedCredentials)creds).getPrincipal().getName());
                return;
            }
            if (!(cb instanceof ImpersonationCallback)) continue;
            creds = this.getCredentials();
            ImpersonationCallback impersonationCallback = (ImpersonationCallback)cb;
            if (!(creds instanceof TrustedCredentials)) continue;
            impersonationCallback.setImpersonator(((TrustedCredentials)creds).getImpersonator());
            return;
        }
        if (this.callbackHandler != null) {
            this.callbackHandler.handle(callbacks);
        }
    }

    private Credentials getCredentials() throws IOException, UnsupportedCallbackException {
        CredentialsCallback credentialsCallback = new CredentialsCallback();
        this.callbackHandler.handle(new Callback[]{credentialsCallback});
        return credentialsCallback.getCredentials();
    }
}

