/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.jcr.base.internal.Configuration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;

@Component(configurationPid={"org.apache.sling.jcr.base.LoginAdminAllowList.fragment"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={AllowListFragment.class})
@Designate(ocd=Configuration.class, factory=true)
public class AllowListFragment {
    public static final String FACTORY_PID = "org.apache.sling.jcr.base.LoginAdminAllowList.fragment";
    final String name;
    final Set<String> bundles;

    @Activate
    public AllowListFragment(Configuration config) {
        this.name = config.allowlist_name();
        this.bundles = this.asSet(config.allowlist_bundles());
    }

    AllowListFragment(String name, String[] bundles) {
        this.name = name;
        this.bundles = this.asSet(bundles);
    }

    boolean allows(String bsn) {
        return this.bundles.contains(bsn);
    }

    public String toString() {
        return this.name + ": " + this.bundles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AllowListFragment)) {
            return false;
        }
        AllowListFragment that = (AllowListFragment)o;
        return this.name.equals(that.name) && this.bundles.equals(that.bundles);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.bundles.hashCode();
        return result;
    }

    private Set<String> asSet(String[] values) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(values)));
    }
}

