/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.subsystems.impl;

import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.factories.subsystems.impl.InstallSubsystemTask;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.subsystem.Subsystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSubsystemTask
extends InstallTask {
    private static final String INSTALL_ORDER = "54-";
    private final Subsystem rootSubsystem;
    private final ServiceReference<Subsystem> subsystemReference;
    private final BundleContext bundleContext;

    public UpdateSubsystemTask(TaskResourceGroup grp, BundleContext bundleContext, ServiceReference<Subsystem> ref, Subsystem rootSubsystem) {
        super(grp);
        this.bundleContext = bundleContext;
        this.subsystemReference = ref;
        this.rootSubsystem = rootSubsystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InstallationContext ctx) {
        TaskResource tr = this.getResource();
        ctx.log("Updating subsystem from {}", new Object[]{tr});
        Subsystem subsystem = null;
        try {
            subsystem = (Subsystem)this.bundleContext.getService(this.subsystemReference);
            if (subsystem != null) {
                subsystem.stop();
                subsystem.uninstall();
                ctx.addTaskToCurrentCycle((InstallTask)new InstallSubsystemTask(this.getResourceGroup(), this.rootSubsystem));
            } else {
                ctx.log("Unable to update subsystem {}.", new Object[]{tr});
                ctx.addTaskToCurrentCycle((InstallTask)new ChangeStateTask(this.getResourceGroup(), ResourceState.IGNORED));
            }
        }
        finally {
            if (subsystem != null) {
                this.bundleContext.ungetService(this.subsystemReference);
            }
        }
    }

    public String getSortKey() {
        return INSTALL_ORDER + this.getResource().getURL();
    }
}

