/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.junitbridge;

import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.sling.hc.junitbridge.HealthCheckTest;
import org.apache.sling.hc.junitbridge.TestBridgeContext;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.AllTests;
import org.osgi.framework.ServiceReference;

@RunWith(value=AllTests.class)
public class JUnitTestBridge {
    private static ThreadLocal<TestBridgeContext> testContext = new ThreadLocal();

    static void setThreadContext(TestBridgeContext c) {
        testContext.set(c);
    }

    public static Test suite() {
        TestBridgeContext context = testContext.get();
        Assert.assertNotNull((String)"Expecting non-null TestBridgeContext, via ThreadLocal", (Object)context);
        TestSuite suite = new TestSuite();
        for (ServiceReference ref : context.getFilter().getTaggedHealthCheckServiceReferences(context.getTags())) {
            suite.addTest((Test)new HealthCheckTest(context, ref));
        }
        if (suite.countTestCases() == 0) {
            Assert.fail((String)("No Health Checks found with tags " + Arrays.asList(context.getTags())));
        }
        return suite;
    }
}

