/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.sightly;

import java.util.Map;
import javax.script.Bindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.hapi.HApiUtil;
import org.apache.sling.hapi.MicrodataAttributeHelper;
import org.apache.sling.scripting.sightly.pojo.Use;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class HApiUse
implements Use {
    private static final Logger LOG = LoggerFactory.getLogger(HApiUse.class);
    private HApiUtil hapi;
    private MicrodataAttributeHelper helper;
    private SlingHttpServletRequest request;
    private SlingScriptHelper sling;
    private ResourceResolver resourceResolver;
    private String typeId;
    private Map<String, String> itemTypeAttr;
    private Map<String, Map<String, String>> itemPropAttrs;
    private Map<String, String> itemPropTypes;

    public void init(Bindings bindings) {
        this.request = (SlingHttpServletRequest)bindings.get("request");
        this.sling = (SlingScriptHelper)bindings.get("sling");
        this.resourceResolver = this.request.getResourceResolver();
        this.typeId = (String)bindings.get("type");
        LOG.debug("init type: {}", (Object)this.typeId);
        try {
            this.activate();
        }
        catch (Exception e) {
            LOG.error("Failed to activate Use class", (Throwable)e);
        }
    }

    public void activate() throws Exception {
        this.hapi = (HApiUtil)this.sling.getService(HApiUtil.class);
        this.helper = this.hapi.getHelper(this.resourceResolver, this.typeId);
        this.itemTypeAttr = this.helper.itemtypeMap();
        this.itemPropAttrs = this.helper.allItemPropMap();
        this.itemPropTypes = this.helper.allPropTypesMap();
    }

    public Map<String, String> getItemtype() {
        LOG.debug("itemtype attrs: {}", this.itemTypeAttr);
        return this.itemTypeAttr;
    }

    public Map<String, Map<String, String>> getItemprop() {
        LOG.debug("itemprop attrs: {}", this.itemPropAttrs);
        return this.itemPropAttrs;
    }

    public Map<String, String> getProptype() {
        LOG.debug("property type attrs: {}", this.itemPropTypes);
        return this.itemPropTypes;
    }
}

