/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.modelconverter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.artifacts.ArtifactHandler;
import org.apache.sling.feature.io.artifacts.ArtifactManager;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.MergeUtility;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Section;
import org.apache.sling.provisioning.model.Traceable;
import org.apache.sling.provisioning.model.io.ModelReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningToFeature {
    private static Logger LOGGER = LoggerFactory.getLogger(ProvisioningToFeature.class);

    public static List<File> convert(File file, File outDir, Map<String, Object> options) {
        Model model = ProvisioningToFeature.createModel(Collections.singletonList(file), null, true, false);
        String bareFileName = ProvisioningToFeature.getBareFileName(file);
        List<Feature> features = ProvisioningToFeature.buildFeatures(model, bareFileName, options);
        ArrayList<File> files = new ArrayList<File>();
        for (Feature f : features) {
            String id = (String)f.getVariables().get("provisioning.model.name");
            if (id == null) {
                id = f.getId().getArtifactId();
            }
            id = id.replaceAll("[:]", "");
            id = bareFileName + "_" + id;
            boolean noProvisioningModelName = ProvisioningToFeature.getOption(options, "noProvisioningModelName", false);
            if (noProvisioningModelName) {
                f.getVariables().remove("provisioning.model.name");
            }
            File outFile = new File(outDir, id + ".json");
            files.add(outFile);
            if (outFile.exists()) {
                if (outFile.lastModified() >= file.lastModified()) {
                    LOGGER.debug("Skipping the generation of {} as this file already exists and is not older.", (Object)outFile);
                    continue;
                }
                LOGGER.debug("Deleting existing file {} as source is newer, modified: out: '{}', source: '{}'", new Object[]{outFile, outFile.lastModified(), file.lastModified()});
                outFile.delete();
            }
            ProvisioningToFeature.writeFeature(f, outFile.getAbsolutePath(), 0);
        }
        return files;
    }

    public static void convert(List<File> files, String outputFile, String runModes, boolean createApp, boolean includeModelInfo, String propsFile) {
        Model model = ProvisioningToFeature.createModel(files, runModes, false, includeModelInfo);
        List<Feature> features = ProvisioningToFeature.buildFeatures(model, null, Collections.emptyMap());
        int index = 1;
        for (Feature feature : features) {
            ProvisioningToFeature.writeFeature(feature, outputFile, features.size() > 1 ? index : 0);
            ++index;
        }
    }

    private static Model createModel(List<File> files, String runModes, boolean allRunModes, boolean includeModelInfo) {
        Set<Object> modes;
        LOGGER.info("Assembling model...");
        ModelUtility.ResolverOptions variableResolver = new ModelUtility.ResolverOptions().variableResolver(new ModelUtility.VariableResolver(){

            public String resolve(org.apache.sling.provisioning.model.Feature feature, String name) {
                return "${" + name + "}";
            }
        });
        Model model = null;
        for (File initFile : files) {
            try {
                model = ProvisioningToFeature.processModel(model, initFile.toURI().toURL(), includeModelInfo, variableResolver);
            }
            catch (IOException iae) {
                LOGGER.error("Unable to read provisioning model {} : {}", new Object[]{initFile, iae.getMessage(), iae});
                System.exit(1);
            }
        }
        Model effectiveModel = ModelUtility.getEffectiveModel(model, (ModelUtility.ResolverOptions)variableResolver);
        Map errors = ModelUtility.validate((Model)effectiveModel);
        if (errors != null) {
            LOGGER.error("Invalid assembled provisioning model.");
            for (Map.Entry entry : errors.entrySet()) {
                LOGGER.error("- {} : {}", (Object)((Traceable)entry.getKey()).getLocation(), entry.getValue());
            }
            System.exit(1);
        }
        if (allRunModes) {
            modes = new HashSet();
            for (org.apache.sling.provisioning.model.Feature f : effectiveModel.getFeatures()) {
                for (RunMode rm : f.getRunModes()) {
                    String[] names = rm.getNames();
                    if (names == null) continue;
                    modes.addAll(Arrays.asList(names));
                }
            }
        } else {
            modes = ProvisioningToFeature.calculateRunModes(effectiveModel, runModes);
        }
        return effectiveModel;
    }

    private static Model processModel(Model model, URL modelFile, boolean includeModelInfo) throws IOException {
        return ProvisioningToFeature.processModel(model, modelFile, includeModelInfo, new ModelUtility.ResolverOptions().variableResolver(new ModelUtility.VariableResolver(){

            public String resolve(org.apache.sling.provisioning.model.Feature feature, String name) {
                return name;
            }
        }));
    }

    private static Model processModel(Model model, URL modelFile, boolean includeModelInfo, ModelUtility.ResolverOptions options) throws IOException {
        LOGGER.info("- reading model {}", (Object)modelFile);
        Model nextModel = ProvisioningToFeature.readProvisioningModel(modelFile);
        Model effectiveModel = ModelUtility.getEffectiveModel((Model)nextModel, (ModelUtility.ResolverOptions)options);
        for (org.apache.sling.provisioning.model.Feature feature : effectiveModel.getFeatures()) {
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    ArrayList<org.apache.sling.provisioning.model.Artifact> removeList = new ArrayList<org.apache.sling.provisioning.model.Artifact>();
                    for (org.apache.sling.provisioning.model.Artifact a : group) {
                        if ("slingstart".equals(a.getType()) || "slingfeature".equals(a.getType())) {
                            ArtifactManagerConfig cfg = new ArtifactManagerConfig();
                            ArtifactManager mgr = ArtifactManager.getArtifactManager((ArtifactManagerConfig)cfg);
                            ArtifactId correctedId = new ArtifactId(a.getGroupId(), a.getArtifactId(), a.getVersion(), "slingstart".equals(a.getType()) ? "slingosgifeature" : a.getClassifier(), "txt");
                            ArtifactHandler handler = mgr.getArtifactHandler(correctedId.toMvnUrl());
                            model = ProvisioningToFeature.processModel(model, handler.getLocalURL(), includeModelInfo);
                            removeList.add(a);
                            continue;
                        }
                        org.apache.sling.provisioning.model.Artifact realArtifact = nextModel.getFeature(feature.getName()).getRunMode(runMode.getNames()).getArtifactGroup(group.getStartLevel()).search(a);
                        if (includeModelInfo) {
                            realArtifact.getMetadata().put("model-filename", modelFile.getPath().substring(modelFile.getPath().lastIndexOf("/") + 1));
                        }
                        if (runMode.getNames() == null) continue;
                        realArtifact.getMetadata().put("runmodes", String.join((CharSequence)",", runMode.getNames()));
                    }
                    for (org.apache.sling.provisioning.model.Artifact r : removeList) {
                        nextModel.getFeature(feature.getName()).getRunMode(runMode.getNames()).getArtifactGroup(group.getStartLevel()).remove((Object)r);
                    }
                }
            }
        }
        if (model == null) {
            model = nextModel;
        } else {
            MergeUtility.merge((Model)model, (Model)nextModel);
        }
        return model;
    }

    private static Model readProvisioningModel(URL file) throws IOException {
        try (InputStreamReader is = new InputStreamReader(file.openStream(), "UTF-8");){
            Model model = ModelReader.read((Reader)is, (String)file.getPath());
            return model;
        }
    }

    private static Set<String> calculateRunModes(Model model, String runModes) {
        org.apache.sling.provisioning.model.Feature feature;
        HashSet<String> modesSet = new HashSet<String>();
        if (runModes != null && runModes.trim().length() > 0) {
            String[] modes = runModes.split(",");
            for (int i = 0; i < modes.length; ++i) {
                modesSet.add(modes[i].trim());
            }
        }
        if ((feature = model.getFeature(":boot")) != null) {
            ProvisioningToFeature.handleOptions(modesSet, (String)feature.getRunMode(new String[0]).getSettings().get("sling.run.mode.options"));
            ProvisioningToFeature.handleOptions(modesSet, (String)feature.getRunMode(new String[0]).getSettings().get("sling.run.mode.install.options"));
        }
        return modesSet;
    }

    private static void handleOptions(Set<String> modesSet, String propOptions) {
        if (propOptions != null && propOptions.trim().length() > 0) {
            String[] options;
            for (String opt : options = propOptions.trim().split("\\|")) {
                String selected = null;
                String[] modes = opt.trim().split(",");
                for (int i = 0; i < modes.length; ++i) {
                    modes[i] = modes[i].trim();
                    if (selected != null) {
                        modesSet.remove(modes[i]);
                        continue;
                    }
                    if (!modesSet.contains(modes[i])) continue;
                    selected = modes[i];
                }
                if (selected != null) continue;
                selected = modes[0];
                modesSet.add(modes[0]);
            }
        }
    }

    private static void buildFromFeature(org.apache.sling.provisioning.model.Feature feature, Map<String, String> variables, List<String> dropVariables, Bundles bundles, List<String> excludeBundles, Configurations configurations, List<String> currentRunModes, Extensions extensions, Map<String, String> properties) {
        for (Object entry : feature.getVariables()) {
            boolean found = false;
            if (dropVariables != null) {
                for (String variableName : dropVariables) {
                    if (!((String)entry.getKey()).equals(variableName)) continue;
                    found = true;
                }
            }
            if (found) continue;
            variables.put((String)entry.getKey(), (String)entry.getValue());
        }
        Extension cpExtension = extensions.getByName("content-packages");
        for (RunMode runMode : feature.getRunModes()) {
            int runModelFilteringMode = 0;
            CharSequence[] runModeNames = runMode.getNames();
            if (!currentRunModes.isEmpty()) {
                if (runModeNames == null || runModeNames.length == 0) {
                    runModelFilteringMode = 1;
                } else {
                    for (CharSequence runModeName : runModeNames) {
                        if (!currentRunModes.contains(runModeName)) continue;
                        runModelFilteringMode = 2;
                    }
                    if (runModelFilteringMode != 2) {
                        runModelFilteringMode = -1;
                    }
                }
            }
            if (runModelFilteringMode < 0) continue;
            for (ArtifactGroup group : runMode.getArtifactGroups()) {
                for (org.apache.sling.provisioning.model.Artifact artifact : group) {
                    String versionFromVariable;
                    ArtifactId id = ArtifactId.fromMvnUrl((String)artifact.toMvnUrl());
                    String artifactId = id.getArtifactId();
                    LOGGER.info("Check Artitfact Id: '{}' if excluded by: '{}'", (Object)artifactId, excludeBundles);
                    if (excludeBundles.contains(artifactId)) continue;
                    String version = id.getVersion();
                    if (version.startsWith("${") && version.endsWith("}") && (versionFromVariable = variables.get(version.substring(2, version.length() - 1))) != null && !versionFromVariable.isEmpty()) {
                        id = new ArtifactId(id.getGroupId(), id.getArtifactId(), versionFromVariable, id.getClassifier(), id.getType());
                    }
                    Artifact newArtifact = new Artifact(id);
                    for (Map.Entry entry : artifact.getMetadata().entrySet()) {
                        newArtifact.getMetadata().put(entry.getKey(), entry.getValue());
                    }
                    if (newArtifact.getId().getType().equals("zip")) {
                        if (cpExtension == null) {
                            cpExtension = new Extension(ExtensionType.ARTIFACTS, "content-packages", true);
                            extensions.add((Object)cpExtension);
                        }
                        cpExtension.getArtifacts().add(newArtifact);
                        continue;
                    }
                    int startLevel = group.getStartLevel();
                    if (startLevel == 0) {
                        if (":boot".equals(feature.getName())) {
                            startLevel = 1;
                        } else if (startLevel == 0) {
                            startLevel = 20;
                        }
                    }
                    newArtifact.getMetadata().put("start-order", String.valueOf(startLevel));
                    bundles.add(newArtifact);
                }
            }
            for (org.apache.sling.provisioning.model.Configuration cfg : runMode.getConfigurations()) {
                String pid = cfg.getPid();
                if (pid.startsWith(":")) {
                    pid = ".." + pid.substring(1);
                }
                LOGGER.info("Check Configuration Id: '{}' if excluded by: '{}'", (Object)pid, excludeBundles);
                if (excludeBundles.contains(pid)) continue;
                if (runModeNames != null && runModelFilteringMode != 2) {
                    pid = pid + ".runmodes." + String.join((CharSequence)".", runModeNames);
                    pid = pid.replaceAll("[:]", "..");
                }
                Configuration newCfg = cfg.getFactoryPid() != null ? new Configuration(cfg.getFactoryPid() + '~' + pid) : new Configuration(pid);
                Enumeration keys = cfg.getProperties().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    Object value = cfg.getProperties().get(key);
                    if (key.startsWith(":")) {
                        key = ".." + key.substring(1);
                    }
                    newCfg.getProperties().put(key, value);
                }
                configurations.add((Object)newCfg);
            }
            for (Map.Entry prop : runMode.getSettings()) {
                if (runModeNames == null && runModelFilteringMode != 2) {
                    properties.put((String)prop.getKey(), (String)prop.getValue());
                    continue;
                }
                properties.put((String)prop.getKey() + ".runmodes:" + String.join((CharSequence)",", runModeNames), (String)prop.getValue());
            }
        }
        StringBuilder repoinitText = new StringBuilder();
        for (Section sect : feature.getAdditionalSections("repoinit")) {
            repoinitText.append(sect.getContents()).append("\n");
        }
        if (repoinitText.length() > 0) {
            Extension repoExtension = extensions.getByName("repoinit");
            if (repoExtension == null) {
                repoExtension = new Extension(ExtensionType.TEXT, "repoinit", true);
                extensions.add((Object)repoExtension);
                repoExtension.setText(repoinitText.toString());
            } else {
                throw new IllegalStateException("Repoinit sections already processed");
            }
        }
    }

    private static String textToJSON(String text) {
        text = text.replace('\t', ' ');
        String[] lines = text.split("[\n]");
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (String t : lines) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(t);
            sb.append('\"');
        }
        sb.append(']');
        return sb.toString();
    }

    private static List<Feature> buildFeatures(Model model, String bareFileName, Map<String, Object> options) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String groupId = ProvisioningToFeature.getOption(options, "groupId", "generated");
        String version = ProvisioningToFeature.getOption(options, "version", "1.0.0");
        String nameOption = ProvisioningToFeature.getOption(options, "name", "");
        boolean useProvidedVersion = ProvisioningToFeature.getOption(options, "useProvidedVersion", false);
        List dropVariables = ProvisioningToFeature.getOption(options, "dropVariables", new ArrayList());
        List excludeBundles = ProvisioningToFeature.getOption(options, "excludeBundles", new ArrayList());
        Map addFrameworkProperties = ProvisioningToFeature.getOption(options, "addFrameworkProperties", new HashMap());
        List runModes = ProvisioningToFeature.getOption(options, "runModes", new ArrayList());
        for (org.apache.sling.provisioning.model.Feature feature : model.getFeatures()) {
            Map modelFeatureProperties;
            String name = feature.getName();
            if (name == null) {
                name = "feature";
            }
            if (!"feature".equals(name = name.replaceAll("[:]", "")) && !name.equals(bareFileName)) {
                name = bareFileName + "_" + name;
            }
            if (feature.getVersion() != null && !useProvidedVersion) {
                version = feature.getVersion();
            }
            String idString = groupId + "/" + (nameOption.isEmpty() ? name : nameOption) + "/" + version + (nameOption.isEmpty() ? "" : "/slingosgifeature/" + name);
            Feature f = new Feature(ArtifactId.parse((String)idString));
            features.add(f);
            Map variables = f.getVariables();
            if (dropVariables != null) {
                for (String variableName : dropVariables) {
                    if (!variables.containsKey(variableName)) continue;
                    variables.remove(variableName);
                }
            }
            Map frameworkProperties = f.getFrameworkProperties();
            String simpleName = feature.getName().replaceAll("[:]", "");
            if (addFrameworkProperties.containsKey(simpleName) && (modelFeatureProperties = (Map)addFrameworkProperties.get(simpleName)) != null) {
                for (Map.Entry entry : modelFeatureProperties.entrySet()) {
                    frameworkProperties.put(entry.getKey(), entry.getValue());
                }
            }
            ProvisioningToFeature.buildFromFeature(feature, variables, dropVariables, f.getBundles(), excludeBundles, f.getConfigurations(), runModes, f.getExtensions(), frameworkProperties);
            if (f.getId().getArtifactId().equals(feature.getName())) continue;
            f.getVariables().put("provisioning.model.name", feature.getName());
        }
        return features;
    }

    private static String getBareFileName(File file) {
        String bareFileName = file.getName();
        int idx = bareFileName.lastIndexOf(46);
        if (idx > 0) {
            bareFileName = bareFileName.substring(0, idx);
        }
        return bareFileName;
    }

    private static <T> T getOption(Map<String, Object> options, String name, T defaultValue) {
        if (options.containsKey(name)) {
            return (T)options.get(name);
        }
        return defaultValue;
    }

    private static void writeFeature(Feature f, String out, int index) {
        if (index > 0) {
            int lastDot = out.lastIndexOf(46);
            out = lastDot == -1 ? out + "_" + String.valueOf(index) : out.substring(0, lastDot) + "_" + String.valueOf(index) + out.substring(lastDot);
        }
        LOGGER.info("to file {}", (Object)out);
        File file = new File(out);
        while (file.exists()) {
            LOGGER.error("Output file already exists: {}", (Object)file.getAbsolutePath());
            System.exit(1);
        }
        try (FileWriter writer = new FileWriter(file);){
            FeatureJSONWriter.write((Writer)writer, (Feature)f);
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to write feature to {} : {}", new Object[]{out, ioe.getMessage(), ioe});
            System.exit(1);
        }
    }
}

