/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.util.Optional;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.io.DocViewAnalyzerListener;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class DocViewAnalyzer
implements DocViewParserHandler {
    static final Logger log = LoggerFactory.getLogger(DocViewAnalyzer.class);
    private final DocViewAnalyzerListener listener;

    public static void analyze(DocViewAnalyzerListener listener, Session session, String rootPath, InputSource source) throws IOException {
        try {
            DocViewParser docViewParser = new DocViewParser(session);
            docViewParser.parse(rootPath, source, new DocViewAnalyzer(listener));
        }
        catch (DocViewParser.XmlParseException e) {
            throw new IllegalStateException(e);
        }
    }

    private DocViewAnalyzer(DocViewAnalyzerListener listener) {
        this.listener = listener;
    }

    @Override
    public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
        if (docViewNode.getProperties().isEmpty()) {
            this.listener.onNode(nodePath, true, "");
        } else {
            this.listener.onNode(nodePath, false, docViewNode.getPrimaryType().orElse(""));
        }
    }

    @Override
    public void endDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
    }
}

