/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntityAddition;

public class FactoryConfigurationDescriptionAddition
extends ConfigurableEntityAddition {
    private final List<String> internalNames = new ArrayList<String>();

    public FactoryConfigurationDescriptionAddition() {
        this.setDefaults();
    }

    @Override
    public void clear() {
        super.clear();
        this.internalNames.clear();
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            JsonValue val = this.getAttributes().remove("internal-names");
            if (val != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    this.getInternalNames().add(this.getString(innerVal));
                }
            }
        }
        catch (JsonException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public List<String> getInternalNames() {
        return this.internalNames;
    }

    @Override
    protected JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder objBuilder = super.createJson();
        if (!this.getInternalNames().isEmpty()) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String n : this.getInternalNames()) {
                arrayBuilder.add(n);
            }
            objBuilder.add("internal-names", arrayBuilder);
        }
        return objBuilder;
    }
}

