/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.NamespaceStorage;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

public class OnDemandRegisterNamespaceResolverWrapper
implements NamespaceResolver {
    private final NamespaceStorage nsStorage;
    static final String UNDECLARED_NAMESPACE_URI_PREFIX = "http://unknown.prefix.";

    public OnDemandRegisterNamespaceResolverWrapper(NamespaceStorage nsStorage) {
        this.nsStorage = nsStorage;
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.nsStorage.getPrefix(uri);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            try {
                return this.nsStorage.getURI(prefix);
            }
            catch (NamespaceException e) {
                String newNamespaceUri = UNDECLARED_NAMESPACE_URI_PREFIX + prefix;
                this.nsStorage.registerNamespace(prefix, newNamespaceUri);
                return newNamespaceUri;
            }
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Could not register prefix " + prefix + " on demand", (Throwable)e);
        }
    }
}

